/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import com.mapr.db.cdc.tests.TestCDPSCLIWithCluster;
import com.mapr.db.cdc.tests.TestCDPSUtil;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.ojai.Document;
import org.ojai.store.cdc.ChangeDataRecord;

class JsonConsumer
implements Runnable {
    private Thread tjConsumer_;
    private String threadName_;
    private String topicFullName_;
    private int rowCount_;

    JsonConsumer(String chgName, int rowcount) {
        this.topicFullName_ = chgName;
        this.rowCount_ = rowcount;
        this.threadName_ = "Consumer-" + this.topicFullName_;
        System.out.println("Consumer of changelog");
    }

    @Override
    public void run() {
        System.out.println("Running " + this.threadName_);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        try {
            consumerScf = TestCDPSUtil.startConsumer(this.topicFullName_);
            System.out.println("fetching " + this.rowCount_ + "rows");
            getListScf = TestCDPSUtil.fetchChangeData(this.rowCount_, consumerScf);
            String rowid = null;
            DBDocumentImpl rec = null;
            for (int i = 0; i < this.rowCount_; ++i) {
                crec = getListScf.get(i);
                cdr = (ChangeDataRecord)crec.value();
                rowid = cdr.getId().getString();
                String idx = rowid.substring("row".length());
                rec = new DBDocumentImpl();
                rec.set("a.b.m1.data", "abm1d" + idx).set("c.d.m1.int", Integer.parseInt(idx)).set("e.f.str", "efs" + idx).set("topicFullName", this.topicFullName_);
                TestCDPSCLIWithCluster.verifyColumnDataThroughIter1(rowid, cdr, (Document)rec, isDebug);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Thread " + this.threadName_ + " interrupted.");
        }
        catch (IOException e) {
            System.out.println("Thread " + this.threadName_ + " failed with IOexception " + e.getStackTrace());
        }
        catch (Exception e) {
            System.out.println("Thread " + this.threadName_ + " failed with exception " + e.getStackTrace());
        }
        System.out.println("Thread " + this.threadName_ + " finished.");
    }
}

