/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class SimpleProducer {
    public static boolean multipleFlushers = false;
    public static KafkaProducer<byte[], byte[]> producer;

    public static void usage() {
        System.err.println("SimpleProducer -path <topic-full-name> [-load <num of messages>]");
        System.exit(1);
    }

    public static int testSimpleProducer(String topicFullName, int load) throws IOException {
        Properties props = new Properties();
        if (props.getProperty("bootstrap.servers") == null) {
            props.put("bootstrap.servers", "localhost:9092");
        }
        if (props.getProperty("key.serializer") == null) {
            props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (props.getProperty("value.serializer") == null) {
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (props.getProperty("streams.parallel.flushers.per.partition") != null) {
            props.put("streams.parallel.flushers.per.partition", (Object)multipleFlushers);
        }
        producer = new KafkaProducer(props);
        return SimpleProducer.produceTransactions(topicFullName, load);
    }

    public static void main(String[] args) throws IOException {
        int retcode;
        String topicFullName = null;
        int load = 5;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                if (++i >= args.length) {
                    SimpleProducer.usage();
                }
                topicFullName = args[i];
                System.out.println("Starting producer on " + args[i]);
                continue;
            }
            if (args[i].equals("-load")) {
                if (++i >= args.length) {
                    SimpleProducer.usage();
                }
                load = Integer.parseInt(args[i]);
                continue;
            }
            SimpleProducer.usage();
        }
        if (topicFullName == null || topicFullName.length() == 0) {
            SimpleProducer.usage();
        }
        if ((retcode = SimpleProducer.testSimpleProducer(topicFullName, load)) != 0) {
            System.exit(retcode);
        }
    }

    private static int produceTransactions(String topicFullName, int load) {
        ProducerCallback cb = new ProducerCallback();
        try {
            for (int j = 0; j < load; ++j) {
                String keyStr = "key" + j;
                String valStr = "val" + j;
                byte[] key = keyStr.getBytes();
                byte[] value = valStr.getBytes();
                ProducerRecord record = new ProducerRecord(topicFullName, null, (Object)key, (Object)value);
                Future recordMetadataFuture = producer.send(record, (Callback)cb);
                producer.flush();
                recordMetadataFuture.get();
                System.out.println("send " + topicFullName + " key " + keyStr + " value " + valStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
        if (cb.opSucceed) {
            return 0;
        }
        return 1;
    }

    private static final class ProducerCallback
    implements Callback {
        private boolean opSucceed = true;

        public boolean opSucceed() {
            return this.opSucceed;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
                this.opSucceed = false;
            }
        }
    }
}

