/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixConsumer
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(MixConsumer.class);
    private final KafkaConsumer<String, String> consumer;
    private final List<String> topics;
    private final int id;
    Map<String, Boolean> topicMap;

    public MixConsumer(int id, String groupId, List<String> topics, Map<String, Boolean> topicMap) {
        this.id = id;
        this.topics = topics;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", groupId);
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", StringDeserializer.class.getName());
        this.consumer = new KafkaConsumer(props);
        this.topicMap = topicMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.consumer.subscribe(this.topics);
                block4: while (true) {
                    ConsumerRecords records = this.consumer.poll(Long.MAX_VALUE);
                    Iterator iterator = records.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        ConsumerRecord record = (ConsumerRecord)iterator.next();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("topic", record.topic());
                        data.put("partition", record.partition());
                        data.put("offset", record.offset());
                        data.put("value", record.value());
                        this.topicMap.put(record.topic(), true);
                        _logger.info(this.id + ": " + data);
                    }
                    break;
                }
            }
            catch (WakeupException wakeupException) {
                this.consumer.close();
            }
        }
        catch (Throwable throwable) {
            this.consumer.close();
            throw throwable;
        }
    }

    public void shutdown() {
        this.consumer.wakeup();
    }
}

