/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.baseutils.BinaryString;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.TimeAndUniq;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Values;

public class ChangeNodeImpl
implements ChangeNode {
    private ChangeEvent event_ = null;
    private ChangeOp op_ = null;
    private long opTime_ = 0L;
    private long serverTime_ = 0L;
    private String fieldName_ = null;
    private int arrayIndex_ = -1;
    private TimeAndUniq arrayIndexTime_ = null;
    private Value value_ = null;
    private boolean inMap_ = true;
    private boolean isJson_ = true;

    public ChangeNodeImpl() {
        this.event_ = ChangeEvent.NULL;
        this.op_ = ChangeOp.NULL;
        this.opTime_ = 0L;
        this.serverTime_ = 0L;
        this.fieldName_ = null;
        this.arrayIndex_ = -1;
        this.arrayIndexTime_ = new TimeAndUniq();
        this.value_ = null;
        this.inMap_ = true;
        this.isJson_ = true;
    }

    public ChangeNodeImpl(ChangeNodeImpl cni) {
        this.event_ = cni.event_;
        this.op_ = cni.op_;
        this.opTime_ = cni.opTime_;
        this.serverTime_ = cni.serverTime_;
        this.fieldName_ = cni.fieldName_;
        this.arrayIndex_ = cni.arrayIndex_;
        this.arrayIndexTime_ = cni.arrayIndexTime_ == null ? new TimeAndUniq() : new TimeAndUniq(cni.arrayIndexTime_);
        this.value_ = cni.value_;
        this.inMap_ = cni.inMap_;
        this.isJson_ = cni.isJson_;
    }

    public ChangeNodeImpl(ChangeEvent event, ChangeOp op, long opTime, long serverTime, String fieldName, int arrayIndex, TimeAndUniq arrayIndexTime, Value value, boolean inMap, boolean isJson) {
        this.event_ = event;
        this.op_ = op;
        this.opTime_ = opTime;
        this.serverTime_ = serverTime;
        this.fieldName_ = fieldName;
        this.arrayIndex_ = arrayIndex;
        this.arrayIndexTime_ = arrayIndexTime == null ? new TimeAndUniq() : new TimeAndUniq(arrayIndexTime);
        this.value_ = value;
        this.inMap_ = inMap;
        this.isJson_ = isJson;
    }

    public void ResetValues() {
        this.setValues(ChangeEvent.NULL, ChangeOp.NULL, 0L, 0L, null, -1, null, null, true, true);
    }

    public void setEvent(ChangeEvent event) {
        this.event_ = event;
    }

    public void setValues(ChangeNodeImpl cni) {
        this.setValues(cni.event_, cni.op_, cni.opTime_, cni.serverTime_, cni.fieldName_, cni.arrayIndex_, cni.arrayIndexTime_, cni.value_, cni.inMap_, cni.isJson_);
    }

    public void setValues(ChangeEvent event, ChangeOp op, long serverTime, long opTime, String fieldName, Value value, boolean inMap, boolean isJson) {
        this.setValues(event, op, opTime, serverTime, fieldName, -1, null, value, inMap, isJson);
    }

    public void setValues(ChangeEvent event, ChangeOp op, long opTime, long serverTime, String fieldName, int arrayIndex, TimeAndUniq arrayIndexTime, Value value, boolean inMap, boolean isJson) {
        this.event_ = event;
        this.op_ = op;
        this.opTime_ = opTime;
        this.serverTime_ = serverTime;
        this.fieldName_ = fieldName;
        this.arrayIndex_ = arrayIndex;
        if (arrayIndexTime == null) {
            this.arrayIndexTime_.setTime(0L);
            this.arrayIndexTime_.setUniq(0);
        } else {
            this.arrayIndexTime_.setTime(arrayIndexTime);
        }
        this.value_ = value;
        this.inMap_ = inMap;
        this.isJson_ = isJson;
    }

    public ChangeEvent getEvent() {
        return this.event_;
    }

    public ChangeOp getOp() {
        return this.op_;
    }

    public long getOpTimestamp() {
        return this.opTime_;
    }

    public long getServerTimestamp() {
        return this.serverTime_;
    }

    public int getArrayIndex() {
        return this.arrayIndex_;
    }

    public TimeAndUniq getArrayIndexTime() {
        return this.arrayIndexTime_;
    }

    public boolean isJson() {
        return this.isJson_;
    }

    public Value getValue() {
        if (this.value_ != null) {
            return this.value_;
        }
        if (this.event_ == ChangeEvent.NODE && this.op_ == ChangeOp.SET) {
            return DBValueBuilderImpl.KeyValueBuilder.initFromNull();
        }
        return null;
    }

    public String toString() {
        if (this.isJson_) {
            return this.toStringJsonChangeNode();
        }
        return this.toStringBinaryChangeNode();
    }

    public String toStringJsonChangeNode() {
        if (this.arrayIndex_ >= 0) {
            return new String("event(" + this.event_.name() + ") op(" + this.op_.name() + ") opTime(" + this.opTime_ + ", " + new OTimestamp(this.opTime_) + ") field(" + (this.fieldName_ == null ? "" : this.fieldName_) + (this.arrayIndex_ >= 0 ? "[" + this.arrayIndex_ + "]" : "") + ") value:" + (this.value_ == null ? "(nil)" : Values.asJsonString((Value)this.value_)));
        }
        return new String("event(" + this.event_.name() + ") op(" + this.op_.name() + ") opTime(" + this.opTime_ + ", " + new OTimestamp(this.opTime_) + ") field(" + (this.fieldName_ == null ? "nil" : this.fieldName_) + ") value:" + (this.value_ == null ? "(nil)" : Values.asJsonString((Value)this.value_)));
    }

    public String toStringWithArrayIndexTime() {
        if (this.arrayIndex_ < 0) {
            return this.toString();
        }
        return new String("event(" + this.event_.name() + ") op(" + this.op_.name() + ") opTime(" + this.opTime_ + ", " + new OTimestamp(this.opTime_) + ") ArrayIndex([" + this.arrayIndex_ + "] time:" + this.arrayIndexTime_.time() + " uniq:" + this.arrayIndexTime_.uniq() + ") value:" + (this.value_ == null ? "(nil)" : Values.asJsonString((Value)this.value_)));
    }

    public String toStringBinaryChangeNode() {
        byte[] strValue = this.value_ == null ? null : this.value_.getBinary().array();
        return new String("event(" + this.event_.name() + ") op(" + this.op_.name() + ") opTime(" + this.opTime_ + ", " + new OTimestamp(this.opTime_) + ") serverTime(" + this.serverTime_ + ", " + new OTimestamp(this.serverTime_) + ") field(" + (this.fieldName_ == null ? "nil" : this.fieldName_) + ") value:" + (strValue == null ? "(nil)" : BinaryString.toStringBinary((byte[])strValue)));
    }

    public String getFieldName() {
        if (this.inArray()) {
            return this.fieldName_ + "[" + this.arrayIndex_ + "]";
        }
        return this.fieldName_;
    }

    public ByteBuffer getFieldNameBytes() {
        return ByteBuffer.wrap(this.fieldName_.getBytes());
    }

    public boolean inMap() {
        return this.inMap_;
    }

    public boolean inArray() {
        return this.arrayIndex_ >= 0;
    }

    public Value.Type getType() {
        if (this.getValue() != null) {
            return this.getValue().getType();
        }
        if (this.getEvent() == ChangeEvent.NODE && this.getOp() == ChangeOp.SET) {
            return Value.Type.NULL;
        }
        return null;
    }

    public byte getByte() {
        return this.getValue().getByte();
    }

    public short getShort() {
        return this.getValue().getShort();
    }

    public int getInt() {
        return this.getValue().getInt();
    }

    public long getLong() {
        return this.getValue().getLong();
    }

    public float getFloat() {
        return this.getValue().getFloat();
    }

    public double getDouble() {
        return this.getValue().getDouble();
    }

    public BigDecimal getDecimal() {
        return this.getValue().getDecimal();
    }

    public boolean getBoolean() {
        return this.getValue().getBoolean();
    }

    public String getString() {
        return this.getValue().getString();
    }

    public OTimestamp getTimestamp() {
        return this.getValue().getTimestamp();
    }

    public long getTimestampAsLong() {
        return this.getValue().getTimestampAsLong();
    }

    public ODate getDate() {
        return this.getValue().getDate();
    }

    public int getDateAsInt() {
        return this.getValue().getDateAsInt();
    }

    public OTime getTime() {
        return this.getValue().getTime();
    }

    public int getTimeAsInt() {
        return this.getValue().getTimeAsInt();
    }

    public OInterval getInterval() {
        return this.getValue().getInterval();
    }

    public long getIntervalAsLong() {
        return this.getValue().getIntervalAsLong();
    }

    public ByteBuffer getBinary() {
        return this.getValue().getBinary();
    }

    public Map<String, Object> getMap() {
        return this.getValue().getMap();
    }

    public List<Object> getList() {
        return this.getValue().getList();
    }

    public Object getObject() {
        return this.getValue().getObject();
    }
}

