/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.demo;

import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.store.DocumentMutation;

public class TestMutateOP {
    Table table_ = null;
    private static String SrcTableName = "/teststream/jtsrc1";
    private static String rowIDPrefix = "row";
    static AdminImpl testAdmin = (AdminImpl)MapRDBImpl.newAdmin();
    private static final FieldPath P_MAP = FieldPath.parseFrom((String)"map");
    private static final FieldPath P_MAP2 = FieldPath.parseFrom((String)"map2");

    public TestMutateOP(boolean recreate, String tableName) throws IOException {
        if (tableName == null) {
            tableName = SrcTableName;
        }
        boolean createTable = false;
        if (MapRDBImpl.tableExists((String)tableName)) {
            if (recreate) {
                MapRDBImpl.deleteTable((String)tableName);
                createTable = true;
            }
        } else {
            createTable = true;
        }
        if (createTable) {
            Path TABLE_1 = new Path(tableName);
            TableDescriptor TABLE_DESC_1 = MapRDBImpl.newTableDescriptor((Path)TABLE_1);
            FamilyDescriptor familyDesc = MapRDBImpl.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.None);
            TABLE_DESC_1.addFamily(familyDesc);
            familyDesc = MapRDBImpl.newFamilyDescriptor().setName("cf1").setJsonFieldPath(P_MAP).setCompression(FamilyDescriptor.Compression.ZLIB);
            TABLE_DESC_1.addFamily(familyDesc);
            familyDesc = MapRDBImpl.newFamilyDescriptor().setName("cf2").setJsonFieldPath(P_MAP2).setCompression(FamilyDescriptor.Compression.None);
            TABLE_DESC_1.addFamily(familyDesc);
            this.table_ = testAdmin.createTable(TABLE_DESC_1);
            TableDescriptor desc = testAdmin.getTableDescriptor(TABLE_1);
            Assert.assertEquals((long)3L, (long)desc.getFamilies().size());
            List flist = desc.getFamilies();
            for (FamilyDescriptor fd : flist) {
                System.out.println("cf:" + fd.getName() + " path:" + fd.getJsonFieldPath());
            }
        } else {
            this.table_ = MapRDBImpl.getTable((String)tableName);
            System.out.println("get table " + tableName);
        }
        this.table_.setOption(Table.TableOption.BUFFERWRITE, false);
    }

    public void loadData(int rowcount) throws IOException, InterruptedException {
        DBDocumentImpl rec = new DBDocumentImpl();
        for (int i = 0; i < rowcount; ++i) {
            String rowID = rowIDPrefix + i;
            rec.empty();
            rec.setArray("Scores" + i, new int[]{10, 20, 30}).setArray("Friends" + i, new Object[]{"Anurag", "Bharat", new Integer(10)}).set("map.boolean" + i, true).set("map.string" + i, "string").set("map.byte" + i, (byte)1).set("map.short" + i, (short)10).set("map.int" + i, 100).set("map.long" + i, 12345678999L).set("map.float" + i, 1.1f).set("map.double" + i, 10.01).setArray("map.Array2" + i, new Object[]{new Double("-2321232.1234312"), new Long(-50000L), new Integer(10)}).setNull("NULL");
            this.table_.insert(rowID, (Document)rec);
            this.table_.flush();
            Thread.sleep(1111L);
        }
        DocumentStream recsReadback = this.table_.find();
        System.out.println("read back docs:");
        Iterator recItr = recsReadback.iterator();
        int num = 0;
        while (recItr.hasNext()) {
            Document d = (Document)recItr.next();
            System.out.println(num + ":" + d.asJsonString());
            ++num;
        }
    }

    public void readData(int rowId) throws IOException {
        String rowID = rowIDPrefix + rowId;
        Document recReadback = this.table_.findById(rowID);
        System.out.println(recReadback == null ? "NULL" : recReadback.asJsonString());
    }

    public void mutateRow(int rowId) throws IOException, InterruptedException {
        String rowID = rowIDPrefix + rowId;
        Document recReadback = this.table_.findById(rowID);
        System.out.println("before mutation, row:" + rowId);
        this.readData(rowId);
        System.out.println("---delete row:" + rowId);
        this.table_.delete(rowID);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---reinsert row:" + rowId);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("different" + rowId, "newInserted" + rowId).setArray("arraydifferent" + rowId, new Object[]{"newInsertedDB" + rowId, "newInsertedDrill" + rowId});
        this.table_.insert(rowID, (Document)rec);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---insertOrReplace row:" + rowId);
        HashMap<String, Integer> recmap = new HashMap<String, Integer>();
        recmap.put("replaceF1" + rowId, 111);
        recmap.put("replaceF2" + rowId, 222);
        rec = new DBDocumentImpl();
        rec.set("replacedMap" + rowId, recmap);
        this.table_.insertOrReplace(rowID, (Document)rec);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
    }

    public void mutateData(int rowId) throws IOException, InterruptedException {
        String rowID = rowIDPrefix + rowId;
        Document recReadback = this.table_.findById(rowID);
        System.out.println("before mutation, row:" + rowId);
        this.readData(rowId);
        System.out.println("---set map.field, map2.field map3.field and Friends[0] row:" + rowId);
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set("map.field" + rowId, "mutationset1").set("map2.fielda" + rowId, "mutationsetA").set("map2.fieldb" + rowId, "mutationsetB").set("map3.field" + rowId, "mutationset3").set("Friends" + rowId + "[0]", "Chen");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---setOrReplace map.int, map.Array2 and Friends row:" + rowId);
        Document mDoc = new DBDocumentImpl().setArray("map.Array2" + rowId, new Object[]{new Integer(10), new Integer(100)});
        mutation.empty();
        mutation.setOrReplace("map.int" + rowId, 200).setOrReplace("Friends" + rowId + "[1]", "Wang").setOrReplace("map.Array2" + rowId, mDoc);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---append map.string row:" + rowId);
        mutation.empty();
        mutation.append("map.string" + rowId, " string2");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---delete Friends[0]" + rowId);
        mutation.empty();
        mutation.delete("Friends" + rowId + "[0]");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---set Friends[0]" + rowId);
        mutation.empty();
        mutation.set("Friends" + rowId + "[0]", "Hello");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---merge map2" + rowId);
        mutation.empty();
        mDoc = new DBDocumentImpl().set("fieldb" + rowId, "mutationmergeBB").set("fieldc" + rowId, "mutationmergeC");
        mutation.merge("map2", mDoc);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---increate map.short" + rowId);
        mutation.empty();
        mutation.increment("map.short" + rowId, 1).increment("Scores" + rowId + "[1]", 10);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---delete map.float, map.Array2, map3" + rowId);
        mutation.empty();
        mutation.delete("map.float" + rowId).delete("map.Array2" + rowId + "[0]").delete("map3" + rowId);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
    }

    public void mutateArray(int id) throws IOException, InterruptedException {
        String rowID = rowIDPrefix + id;
        DocumentMutation mutation = MapRDBImpl.newMutation();
        System.out.println("---insertOrReplace entire array Scores" + id);
        mutation.empty();
        ArrayList<String> grades = new ArrayList<String>();
        grades.add("A");
        grades.add("B");
        grades.add("A+");
        grades.add("B+");
        mutation.setOrReplace("Scores" + id, grades);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---delete entire array Scores" + id);
        mutation.empty();
        mutation.delete("Scores" + id);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---setOrReplace a new array Pets" + id);
        mutation.empty();
        ArrayList<String> pets = new ArrayList<String>();
        pets.add("dog" + id);
        pets.add("cat" + id);
        pets.add("bird" + id);
        pets.add("monkey" + id);
        mutation.setOrReplace("Pets" + id, pets);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---setOrReplace Pets" + id + "[1]");
        mutation.setOrReplace("Pets" + id + "[1]", "pig" + id);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---delete Pets" + id + "[2]");
        mutation.delete("Pets" + id + "[2]");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---append Pets" + id);
        pets.clear();
        pets.add("bee" + id);
        pets.add("turtle" + id);
        mutation.append("Pets" + id, pets);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
        System.out.println("---append string to an item Pets[2]" + id);
        mutation.append("Pets" + id + "[2]", "_indoor");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(id);
    }

    public void mutateCf(int rowId) throws IOException, InterruptedException {
        String rowID = rowIDPrefix + rowId;
        Document recReadback = this.table_.findById(rowID);
        System.out.println("before mutation, row:" + rowId);
        this.readData(rowId);
        System.out.println("---insert an entire map2" + rowId);
        Document rec2 = MapRDBImpl.newDocument().set("sue", "engineer").set("om", "soft engineer");
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set("map2", rec2);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---delete the entire map" + rowId);
        mutation = MapRDBImpl.newMutation();
        mutation.delete("map");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---insert a field to existing map2" + rowId);
        mutation = MapRDBImpl.newMutation();
        mutation.set("map2.anurag", "manager");
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---insert a field to non-existing map" + rowId);
        mutation = MapRDBImpl.newMutation();
        mutation.set("map.firstfield" + rowId, "firstfieldvalue" + rowId);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
        System.out.println("---delete last field from existing map" + rowId);
        mutation = MapRDBImpl.newMutation();
        mutation.delete("map.firstfield" + rowId);
        this.table_.update(rowID, mutation);
        this.table_.flush();
        Thread.sleep(1111L);
        this.readData(rowId);
    }

    public static void usage() {
        System.out.println("Create a multi column family json table:\n\t java com.mapr.streams.demo.TestMutateOP -op[create|mutatedata(default)|mutaterow|mutatearray|mutatecf] -path <tableName> -createrowcount <num> -mutaterow <rowid>");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String tableName = null;
        boolean isCreate = false;
        boolean isMutateRow = false;
        boolean isMutateData = false;
        boolean isMutateArray = false;
        boolean isMutateCf = false;
        int mutateNum = 0;
        boolean deleterow = false;
        int createrowcount = 3;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                tableName = args[++i];
                continue;
            }
            if (args[i].equals("-op")) {
                String opType;
                if (++i >= args.length) {
                    TestMutateOP.usage();
                }
                if ((opType = args[i]).equalsIgnoreCase("create")) {
                    isCreate = true;
                    continue;
                }
                if (opType.equalsIgnoreCase("mutateRow")) {
                    isMutateRow = true;
                    continue;
                }
                if (opType.equalsIgnoreCase("mutateData")) {
                    isMutateData = true;
                    continue;
                }
                if (opType.equalsIgnoreCase("mutateArray")) {
                    isMutateArray = true;
                    continue;
                }
                if (opType.equalsIgnoreCase("mutateCf")) {
                    isMutateCf = true;
                    continue;
                }
                TestMutateOP.usage();
                continue;
            }
            if (args[i].equals("-mutaterow")) {
                if (++i >= args.length) {
                    TestMutateOP.usage();
                }
                mutateNum = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-createrowcount")) {
                if (++i >= args.length) {
                    TestMutateOP.usage();
                }
                createrowcount = Integer.parseInt(args[i]);
                continue;
            }
            TestMutateOP.usage();
        }
        System.out.println("Run with create=" + isCreate + " tableName=" + tableName + " createrowcount=" + createrowcount + " mutateNum=" + mutateNum);
        TestMutateOP tmOp = new TestMutateOP(isCreate, tableName);
        if (isCreate) {
            tmOp.loadData(createrowcount);
            tmOp.mutateRow(0);
            tmOp.mutateData(1);
        } else if (isMutateRow) {
            tmOp.mutateRow(mutateNum);
        } else if (isMutateData) {
            tmOp.mutateData(mutateNum);
        } else if (isMutateArray) {
            tmOp.mutateArray(mutateNum);
        } else if (isMutateCf) {
            tmOp.mutateCf(mutateNum);
        } else {
            TestMutateOP.usage();
        }
    }
}

