/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.baseutils.BinaryString;
import com.mapr.db.cdc.ChangeDataKeyValue;
import com.mapr.db.cdc.impl.ChangeDataDBDocumentReader;
import com.mapr.db.cdc.impl.ChangeDataReaderImpl;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.ojai.DBDocumentReader;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.KeyValue;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDataRecordImplJson
extends ChangeDataRecordImpl {
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataRecordImplJson.class);
    private Map<Integer, ByteBuffer> bufMap_ = null;

    public ChangeDataRecordImplJson(Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, Dbserver.RawChangeData rData, ByteBuffer valueBuf) throws IllegalArgumentException {
        super(jsonPathMap, idToCFNameMap, rData, valueBuf);
        if (!this.isJson()) {
            throw new IllegalArgumentException("Not a json record");
        }
        if (this.result_.getIsDelete()) {
            return;
        }
        try {
            this.bufMap_ = this.result_.getJsonByteBufs();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No row key found", e);
        }
        if (this.jsonPathMap_ == null || this.jsonPathMap_.size() == 0) {
            throw new IllegalArgumentException("Missing JSON path map");
        }
        ChangeDataReaderImpl cdReader = this.getReaderInternal(null);
        if (cdReader == null) {
            throw new IllegalStateException("Fail to get ChangeDataReader reader for op " + this.opBaseType_ + " of row " + (this.getId().getType() == Value.Type.STRING ? this.getId().getString() : BinaryString.toStringBinary((byte[])this.getId().getBinary().array())));
        }
        if (!cdReader.hasRootTS()) {
            LOG.debug("---No default CF TS found for row" + (this.getId().getType() == Value.Type.STRING ? this.getId().getString() : BinaryString.toStringBinary((byte[])this.getId().getBinary().array())) + "opBaseTime:" + this.opBaseTime_ + " rowTime:" + this.rowTime_ + "---");
            return;
        }
        TimeAndUniq[] rootTS = cdReader.getRootTS();
        if (rootTS == null) {
            return;
        }
        if (rootTS.length != 3) {
            throw new IllegalStateException("the root (create/update/delete) time array length is " + rootTS.length + ", it should be " + 3);
        }
        TimeAndUniq createTime = rootTS[0];
        TimeAndUniq updateTime = rootTS[1];
        TimeAndUniq deleteTime = rootTS[2];
        LOG.debug("root TS of " + this.getId() + " is " + this.getOpTimestamp() + ", default cf TS ct/ut/dt are " + (createTime == null ? "null" : Long.valueOf(createTime.time())) + "|" + (updateTime == null ? "null" : Long.valueOf(updateTime.time())) + "|" + (deleteTime == null ? "null" : Long.valueOf(deleteTime.time())));
        if (updateTime == null) {
            throw new IllegalStateException("Missing update time on default column family");
        }
        if (updateTime.time() != 0L) {
            this.opBaseTime_ = updateTime.time();
        }
        if (createTime == null && deleteTime == null) {
            this.opBaseType_ = ChangeOp.MERGE;
        } else if (deleteTime == null) {
            if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) < 0) {
                this.opBaseType_ = ChangeOp.MERGE;
            } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                this.opBaseType_ = this.initialCopy_ ? ChangeOp.SET : ChangeOp.MERGE;
            } else {
                LOG.info("Bug26626 r1: update time " + updateTime.time() + "should be larger or same as than create time " + createTime.time() + " on default column family");
                this.opBaseType_ = ChangeOp.MERGE;
            }
        } else if (createTime == null) {
            if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) < 0) {
                this.opBaseType_ = ChangeOp.MERGE;
            } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                this.opBaseType_ = ChangeOp.DELETE;
            } else {
                LOG.info("Bug26626 r2: update time " + updateTime.time() + " should be larger or same as delete time " + deleteTime.time());
                this.opBaseType_ = ChangeOp.MERGE;
            }
        } else {
            if (createTime.time() == 0L && updateTime.time() == 0L && deleteTime.time() == 0L) {
                createTime.setTime(this.opBaseTime_);
                updateTime.setTime(this.opBaseTime_);
                deleteTime.setTime(this.opBaseTime_);
                LOG.debug("---ct|ut|dt of " + this.getId() + " are all 0, set them to " + this.opBaseTime_);
            }
            if (updateTime.time() == 0L) {
                throw new IllegalStateException("update time on default column family is 0");
            }
            if (createTime.time() == 0L) {
                if (deleteTime.time() == 0L) {
                    this.opBaseType_ = ChangeOp.MERGE;
                } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                    this.opBaseType_ = ChangeOp.DELETE;
                } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) < 0) {
                    this.opBaseType_ = ChangeOp.MERGE;
                } else {
                    LOG.info("Bug26626 r3: update time " + updateTime.time() + " should be larger or same as delete time " + deleteTime.time());
                    this.opBaseType_ = ChangeOp.MERGE;
                }
            } else if (deleteTime.time() == 0L) {
                if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                    this.opBaseType_ = this.initialCopy_ ? ChangeOp.SET : ChangeOp.MERGE;
                } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) < 0) {
                    this.opBaseType_ = ChangeOp.MERGE;
                } else {
                    LOG.info("Bug26626 r4: update time " + updateTime.time() + " should be larger or same as create time " + createTime.time());
                    this.opBaseType_ = ChangeOp.MERGE;
                }
            } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0 && TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                this.opBaseType_ = ChangeOp.SET;
            } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 r5: update time " + updateTime.time() + " should be larger or same as create time " + createTime.time());
                }
                this.opBaseType_ = ChangeOp.DELETE;
            } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 r6: update time " + updateTime.time() + " should be larger or same as delete time " + deleteTime.time());
                }
                this.opBaseType_ = this.initialCopy_ ? ChangeOp.SET : ChangeOp.MERGE;
            } else {
                if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 r7: update time " + updateTime.time() + " should be larger or same as create time " + createTime.time() + " delete time " + deleteTime.time());
                }
                if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 r8: update time " + updateTime.time() + " should be larger or same as delete time " + deleteTime.time() + " create time" + createTime.time());
                }
                this.opBaseType_ = ChangeOp.MERGE;
            }
        }
    }

    public Iterator<KeyValue<FieldPath, ChangeNode>> iterator() {
        return new ChangeDataRecordIterator();
    }

    public ChangeDataReader getReader() {
        ChangeOp rowOp = null;
        if (this.opBaseType_ == ChangeOp.MERGE || this.opBaseType_ == ChangeOp.SET) {
            rowOp = this.opBaseType_;
        }
        return this.getReaderInternal(rowOp);
    }

    private ChangeDataReaderImpl getReaderInternal(ChangeOp rowOp) {
        if (!this.isJson()) {
            throw new IllegalStateException("Not a json record!");
        }
        ChangeDataDBDocumentReader cdDocReader = null;
        if (this.opBaseType_ != ChangeOp.NULL && this.opBaseType_ != ChangeOp.DELETE) {
            HashMap<Integer, ByteBuffer> bufMapReader = new HashMap<Integer, ByteBuffer>();
            ChangeDataRecordImplJson.copyByteBufferMap(this.bufMap_, bufMapReader);
            DBDocumentImpl jsonResultReader = RowcolCodec.decode(bufMapReader, (Map)this.jsonPathMap_, (Map)this.idToCFNameMap_, (ByteBuffer)this.result_.getKey(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, null);
            DBDocumentReader cachedDBDocReader = (DBDocumentReader)jsonResultReader.asReader();
            cdDocReader = new ChangeDataDBDocumentReader(cachedDBDocReader, this.rowTime_, this.opBaseTime_, rowOp);
        }
        return new ChangeDataReaderImpl(this, cdDocReader, this.recCachedNode_);
    }

    class ChangeDataRecordIterator
    implements Iterator<KeyValue<FieldPath, ChangeNode>> {
        private Map.Entry<String, ChangeNode> itrCachedEntry_ = null;
        private ChangeDataReaderImpl itrCdReader_ = null;
        private ChangeDataRecordImpl.ChangeNodeStack parentNodeStack_ = null;

        ChangeDataRecordIterator() {
            if (!ChangeDataRecordImplJson.this.isJson()) {
                throw new IllegalStateException("Not a json record!");
            }
            this.itrCdReader_ = (ChangeDataReaderImpl)ChangeDataRecordImplJson.this.getReader();
            if (this.itrCdReader_ == null) {
                throw new IllegalStateException("Fail to initialize internal ChangeDataReader");
            }
            this.parentNodeStack_ = new ChangeDataRecordImpl.ChangeNodeStack();
            this.itrCachedEntry_ = null;
        }

        private String genCurrentFieldName(ChangeNodeImpl currentNode) {
            String ret;
            String fieldName = this.parentNodeStack_.getFieldsInStack();
            String string = ret = fieldName == null ? "" : fieldName;
            if (currentNode == null) {
                return ret;
            }
            if (!currentNode.inArray()) {
                String newSegment = currentNode.getFieldName();
                if (newSegment != null && !newSegment.equals("") && ret != null && !ret.equals("")) {
                    return ret + "." + newSegment;
                }
                if (newSegment != null && !newSegment.equals("")) {
                    return newSegment;
                }
                if (ret != null && !ret.equals("")) {
                    return ret;
                }
                return ret;
            }
            int arrayIdx = currentNode.getArrayIndex();
            ret = ret + "[" + arrayIdx + "]";
            return ret;
        }

        private String genCurrentFieldNameWithoutArrayIndex(ChangeNodeImpl currentNode) {
            String ret;
            String fieldName = this.parentNodeStack_.getFieldsInStack();
            String string = ret = fieldName == null ? "" : fieldName;
            if (currentNode == null) {
                return ret;
            }
            if (!currentNode.inArray()) {
                String newSegment = currentNode.getFieldName();
                if (newSegment != null && !newSegment.equals("") && ret != null && !ret.equals("")) {
                    return ret + "." + newSegment;
                }
                if (newSegment != null && !newSegment.equals("")) {
                    return newSegment;
                }
                if (ret != null && !ret.equals("")) {
                    return ret;
                }
                return ret;
            }
            return ret;
        }

        private Map.Entry<String, ChangeNode> genCurrentEntry(ChangeNodeImpl currentNode) {
            String fieldName = this.genCurrentFieldName(currentNode);
            String nodeName = this.genCurrentFieldNameWithoutArrayIndex(currentNode);
            ChangeNodeImpl retNode = new ChangeNodeImpl(ChangeEvent.NODE, currentNode.getOp(), currentNode.getOpTimestamp(), currentNode.getServerTimestamp(), nodeName == "" ? null : nodeName, currentNode.getArrayIndex(), currentNode.getArrayIndexTime(), currentNode.getValue(), currentNode.inMap(), ChangeDataRecordImplJson.this.isJson());
            return new ChangeDataRecordImpl.ChangeNodeIteratorEntry<String, ChangeNode>(fieldName, retNode);
        }

        private Map.Entry<String, ChangeNode> genCurrentEntry(ChangeNodeImpl currentNode, Value subTreeDoc) {
            String fieldName = this.genCurrentFieldName(currentNode);
            String nodeName = this.genCurrentFieldNameWithoutArrayIndex(currentNode);
            ChangeNodeImpl retNode = new ChangeNodeImpl(ChangeEvent.NODE, currentNode.getOp(), currentNode.getOpTimestamp(), currentNode.getServerTimestamp(), nodeName == "" ? null : nodeName, currentNode.getArrayIndex(), currentNode.getArrayIndexTime(), subTreeDoc, currentNode.inMap(), ChangeDataRecordImplJson.this.isJson());
            return new ChangeDataRecordImpl.ChangeNodeIteratorEntry<String, ChangeNode>(fieldName, retNode);
        }

        @Override
        public boolean hasNext() {
            if (this.itrCachedEntry_ == null) {
                this.itrCachedEntry_ = this.nextInternal();
            }
            return this.itrCachedEntry_ != null;
        }

        @Override
        public KeyValue<FieldPath, ChangeNode> next() {
            Map.Entry<String, ChangeNode> ret = null;
            if (this.itrCachedEntry_ != null) {
                ret = this.itrCachedEntry_;
                this.itrCachedEntry_ = null;
            } else {
                ret = this.nextInternal();
            }
            return new ChangeDataKeyValue(FieldPath.parseFrom((String)ret.getKey()), ret.getValue());
        }

        private Map.Entry<String, ChangeNode> nextInternal() {
            ChangeNodeImpl currentNode;
            block22: {
                ChangeNodeImpl parentNode;
                currentNode = null;
                while (true) {
                    if ((currentNode = this.moveToNextNodeInReader()) == null) {
                        if (this.parentNodeStack_.size() != 0) {
                            throw new IllegalStateException("Extra parent START_MAP/START_ARRAY for field path " + this.genCurrentFieldName(currentNode));
                        }
                        return null;
                    }
                    if (currentNode.getOp() == ChangeOp.NULL) {
                        if (currentNode.getEvent() == ChangeEvent.NULL) {
                            return this.genCurrentEntry(currentNode);
                        }
                        if (currentNode.getEvent() == ChangeEvent.NODE) {
                            return this.genCurrentEntry(currentNode);
                        }
                        if (currentNode.getEvent() == ChangeEvent.START_MAP) {
                            this.parentNodeStack_.pushNode(currentNode);
                            continue;
                        }
                        if (currentNode.getEvent() == ChangeEvent.START_ARRAY) {
                            this.parentNodeStack_.pushNode(currentNode);
                            continue;
                        }
                        if (currentNode.getEvent() == ChangeEvent.END_MAP) {
                            this.parentNodeStack_.popNode();
                            continue;
                        }
                        if (currentNode.getEvent() == ChangeEvent.END_ARRAY) {
                            this.parentNodeStack_.popNode();
                            continue;
                        }
                        throw new IllegalStateException("Unknow event " + currentNode.getEvent() + " at field " + this.genCurrentFieldName(currentNode));
                    }
                    if (currentNode.getOp() == ChangeOp.DELETE || currentNode.getOp() == ChangeOp.DELETE_EXACT || currentNode.getOp() == ChangeOp.SET) {
                        ChangeNodeImpl tmp;
                        DBDocumentImpl subtreeDoc;
                        if (currentNode.getEvent() == ChangeEvent.NULL) {
                            return this.genCurrentEntry(currentNode);
                        }
                        if (currentNode.getEvent() == ChangeEvent.NODE) {
                            return this.genCurrentEntry(currentNode);
                        }
                        if (currentNode.getEvent() == ChangeEvent.START_MAP) {
                            subtreeDoc = new DBDocumentImpl();
                            ChangeNodeImpl child = this.moveToNextNodeInReader();
                            if (child == null) {
                                throw new IllegalStateException("Extra parent START_MAP for field path " + this.genCurrentFieldName(currentNode));
                            }
                            this.addMapNode(child, subtreeDoc);
                            return this.genCurrentEntry(currentNode, (Value)subtreeDoc);
                        }
                        if (currentNode.getEvent() == ChangeEvent.START_ARRAY) {
                            subtreeDoc = new DBList(InsertContext.OpType.NONE);
                            ChangeNodeImpl child = this.moveToNextNodeInReader();
                            if (child == null) {
                                throw new IllegalStateException("Extra parent START_ARRAY for field path " + this.genCurrentFieldName(currentNode));
                            }
                            this.addArrayNode(child, (DBList)subtreeDoc);
                            return this.genCurrentEntry(currentNode, (Value)subtreeDoc);
                        }
                        if (currentNode.getEvent() == ChangeEvent.END_MAP) {
                            tmp = this.parentNodeStack_.popNode();
                            if (tmp.getEvent() == ChangeEvent.START_MAP) continue;
                            throw new IllegalStateException("Missmatch event, field " + this.genCurrentFieldName(tmp) + " starts with " + tmp.getEvent() + ", but end with END_MAP)");
                        }
                        if (currentNode.getEvent() == ChangeEvent.END_ARRAY) {
                            tmp = this.parentNodeStack_.popNode();
                            if (tmp.getEvent() == ChangeEvent.START_ARRAY) continue;
                            throw new IllegalStateException("Missmatch event, field " + this.genCurrentFieldName(tmp) + " starts with " + tmp.getEvent() + ", but end with END_ARRAY)");
                        }
                        throw new IllegalStateException("Unknow event " + currentNode.getEvent() + " at field " + this.genCurrentFieldName(currentNode));
                    }
                    if (currentNode.getOp() != ChangeOp.MERGE) break block22;
                    if (currentNode.getEvent() == ChangeEvent.NULL || currentNode.getEvent() == ChangeEvent.NODE) {
                        throw new IllegalStateException("Merge Op can only apply to Map or Array, the current node is " + currentNode);
                    }
                    if (currentNode.getEvent() == ChangeEvent.START_MAP || currentNode.getEvent() == ChangeEvent.START_ARRAY) {
                        this.parentNodeStack_.pushNode(currentNode);
                        continue;
                    }
                    if (currentNode.getEvent() == ChangeEvent.END_MAP) {
                        parentNode = this.parentNodeStack_.popNode();
                        if (parentNode != null && parentNode.getEvent() == ChangeEvent.START_MAP) continue;
                        throw new IllegalStateException("An extra END_MAP at field path " + this.genCurrentFieldName(parentNode));
                    }
                    if (currentNode.getEvent() == ChangeEvent.END_ARRAY && ((parentNode = this.parentNodeStack_.popNode()) == null || parentNode.getEvent() != ChangeEvent.START_ARRAY)) break;
                }
                throw new IllegalStateException("An extra END_ARRAY at field path " + this.genCurrentFieldName(parentNode));
            }
            throw new IllegalStateException("Unknow Op can only apply to event NODE or NULL, the current node is " + currentNode);
        }

        private ChangeNodeImpl moveToNextNodeInReader() {
            if (this.itrCdReader_.next() == null) {
                return null;
            }
            return this.itrCdReader_.getChangeNode();
        }

        private void addArrayNode(ChangeNodeImpl currentNode, DBList parentDoc) {
            DBDocumentImpl subtreeDoc;
            if (currentNode == null) {
                return;
            }
            if (currentNode.getEvent() == ChangeEvent.NULL) {
                if (currentNode.getValue() == null) {
                    LOG.debug("Add NULL item in Array at " + this.genCurrentFieldName(currentNode) + ", node:" + currentNode);
                    parentDoc.addToDBList(new com.mapr.db.rowcol.KeyValue(Value.Type.NULL));
                } else {
                    parentDoc.addToDBList((com.mapr.db.rowcol.KeyValue)currentNode.getValue());
                }
            } else if (currentNode.getEvent() == ChangeEvent.NODE) {
                if (currentNode.getValue() == null) {
                    LOG.debug("Add NULL item in Array at " + this.genCurrentFieldName(currentNode) + ", node:" + currentNode);
                    parentDoc.addToDBList(new com.mapr.db.rowcol.KeyValue(Value.Type.NULL));
                } else {
                    parentDoc.addToDBList((com.mapr.db.rowcol.KeyValue)currentNode.getValue());
                }
            } else if (currentNode.getEvent() == ChangeEvent.START_MAP) {
                subtreeDoc = new DBDocumentImpl();
                ChangeNodeImpl child = this.moveToNextNodeInReader();
                if (child == null) {
                    throw new IllegalStateException("current START_MAP starts at field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + ", but miss END_MAP node. The doc so far is " + parentDoc.toString());
                }
                this.addMapNode(child, subtreeDoc);
                parentDoc.addToDBList((com.mapr.db.rowcol.KeyValue)subtreeDoc);
            } else if (currentNode.getEvent() == ChangeEvent.START_ARRAY) {
                subtreeDoc = new DBList(InsertContext.OpType.NONE);
                ChangeNodeImpl child = this.moveToNextNodeInReader();
                if (child == null) {
                    throw new IllegalStateException("current START_ARRAY starts at field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + ", but miss END_ARRAY node. The doc so far is " + parentDoc.toString());
                }
                this.addArrayNode(child, (DBList)subtreeDoc);
                parentDoc.addToDBList((com.mapr.db.rowcol.KeyValue)subtreeDoc);
            } else {
                if (currentNode.getEvent() == ChangeEvent.END_MAP) {
                    throw new IllegalStateException("current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + " should be in an array, but get and END_MAP node. The doc so far is " + parentDoc.toString());
                }
                if (currentNode.getEvent() == ChangeEvent.END_ARRAY) {
                    return;
                }
            }
            ChangeNodeImpl child = this.moveToNextNodeInReader();
            if (child == null) {
                throw new IllegalStateException("current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + " should be in an array, but get and END_MAP node. The doc so far is " + parentDoc.toString());
            }
            this.addArrayNode(child, parentDoc);
        }

        private void addMapNode(ChangeNodeImpl currentNode, DBDocumentImpl parentDoc) {
            DBDocumentImpl subtreeDoc;
            if (currentNode == null) {
                return;
            }
            if (currentNode.getEvent() == ChangeEvent.NULL) {
                if (currentNode.getValue() == null) {
                    LOG.debug("Add NULL item in map at " + this.genCurrentFieldName(currentNode) + ", node:" + currentNode);
                    parentDoc.setNull(currentNode.getFieldName());
                } else {
                    parentDoc.set(currentNode.getFieldName(), currentNode.getValue());
                }
            } else if (currentNode.getEvent() == ChangeEvent.NODE) {
                if (currentNode.getValue() == null) {
                    LOG.debug("Add NULL item in map at " + this.genCurrentFieldName(currentNode) + ", node:" + currentNode);
                    parentDoc.setNull(currentNode.getFieldName());
                } else {
                    parentDoc.set(currentNode.getFieldName(), currentNode.getValue());
                }
            } else if (currentNode.getEvent() == ChangeEvent.START_MAP) {
                subtreeDoc = new DBDocumentImpl();
                ChangeNodeImpl child = this.moveToNextNodeInReader();
                if (child == null) {
                    throw new IllegalStateException("START_MAP at current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + ", but miss END_MAP node. The doc so far is " + parentDoc.toString());
                }
                this.addMapNode(child, subtreeDoc);
                parentDoc.set(currentNode.getFieldName(), (Document)subtreeDoc);
            } else if (currentNode.getEvent() == ChangeEvent.START_ARRAY) {
                subtreeDoc = new DBList(InsertContext.OpType.NONE);
                ChangeNodeImpl child = this.moveToNextNodeInReader();
                if (child == null) {
                    throw new IllegalStateException("START_ARRAY at current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + ", but miss END_ARRAY node. The doc so far is " + parentDoc.toString());
                }
                this.addArrayNode(child, (DBList)subtreeDoc);
                parentDoc.set(currentNode.getFieldName(), (Value)subtreeDoc);
            } else {
                if (currentNode.getEvent() == ChangeEvent.END_MAP) {
                    return;
                }
                if (currentNode.getEvent() == ChangeEvent.END_ARRAY) {
                    throw new IllegalStateException("current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + " should be in a map, but get and END_ARRAY node. The doc so far is " + parentDoc.toString());
                }
            }
            ChangeNodeImpl child = this.moveToNextNodeInReader();
            if (child == null) {
                throw new IllegalStateException("current field " + this.parentNodeStack_.getFieldsInStack() + "..." + currentNode.getFieldName() + " should be in a Map, but miss END_MAP node. The doc so far is " + parentDoc.toString());
            }
            this.addMapNode(child, parentDoc);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

