/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mapr.baseutils.BinaryString;
import com.mapr.db.cdc.TopicCFMeta;
import com.mapr.db.cdc.impl.ChangeDataRecordImplBinary;
import com.mapr.db.cdc.impl.ChangeDataRecordImplJson;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.admin.MarlinAdminImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.ojai.FieldPath;
import org.ojai.store.cdc.ChangeDataRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDataRecordDeserializer
implements Deserializer<ChangeDataRecord> {
    public static final int TOPIC_CFMAP_CACHE_NUM_ENTRIES = 4096;
    public static final int TOPIC_CFMAP_CACHE_DURATION_MINS = 720;
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataRecordDeserializer.class);
    private MarlinAdminImpl mAdmin_ = null;
    private LoadingCache<String, TopicCFMeta> topicToCFMeta_ = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            this.mAdmin_ = new MarlinAdminImpl(new Configuration());
        }
        catch (IOException e) {
            LOG.error(Arrays.toString(e.getStackTrace()));
            throw new SerializationException("Failed to get mapr stream admin. Reason:" + e.getMessage());
        }
        this.topicToCFMeta_ = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<String, TopicCFMeta>(){

            public TopicCFMeta load(String topic) throws Exception {
                LOG.debug("fetch meta for topic(" + topic + ")");
                Marlinserver.MarlinTopicMetaEntry mtEntry = null;
                try {
                    mtEntry = ChangeDataRecordDeserializer.this.mAdmin_.getTopicMetaEntry(topic);
                }
                catch (IOException e) {
                    LOG.error("fetch meta failed for topic(" + topic + "). Reason:" + Arrays.toString(e.getStackTrace()));
                    throw new SerializationException("No changelog info found in topic " + e);
                }
                if (mtEntry == null || !mtEntry.hasTag()) {
                    throw new SerializationException("No changelog info found in topic " + topic);
                }
                Marlinserver.MarlinTopicMetaEntryTag mtTag = mtEntry.getTag();
                if (mtTag.getSrcColumnFamilyMapCount() <= 0) {
                    throw new SerializationException("No column family info found in topic " + topic + " meta data");
                }
                HashMap<FieldPath, Integer> jsonPathMap = new HashMap<FieldPath, Integer>();
                HashMap<Integer, String> idToCFNameMap = new HashMap<Integer, String>();
                for (int i = 0; i < mtTag.getSrcColumnFamilyMapCount(); ++i) {
                    Dbserver.ColumnFamily cf = mtTag.getSrcColumnFamilyMap(i);
                    if (!cf.hasId()) {
                        throw new SerializationException("Column family " + i + " does not have id in topic" + topic);
                    }
                    if (!cf.hasName()) {
                        throw new SerializationException("Column family " + i + " with id " + cf.getId() + " does not have name in topic" + topic);
                    }
                    idToCFNameMap.put(cf.getId(), cf.getName());
                    if (!cf.hasJsonPath()) continue;
                    jsonPathMap.put(FieldPath.parseFrom((String)cf.getJsonPath()), cf.getId());
                }
                return new TopicCFMeta(jsonPathMap, idToCFNameMap);
            }
        });
    }

    private Map<Integer, String> getIdCFNameMap(String topic) throws ExecutionException {
        if (topic == null || topic.isEmpty()) {
            throw new SerializationException("Invalid empty topic name.");
        }
        return ((TopicCFMeta)this.topicToCFMeta_.get((Object)topic)).getIdCFNameMap();
    }

    private Map<FieldPath, Integer> getJsonPath(String topic) throws ExecutionException {
        if (topic == null || topic.isEmpty()) {
            throw new SerializationException("Invalid empty topic name.");
        }
        return ((TopicCFMeta)this.topicToCFMeta_.get((Object)topic)).getJsonPathMap();
    }

    public ChangeDataRecord deserialize(String topic, byte[] data) {
        ByteBuffer recvecbuf = ByteBuffer.wrap(data);
        recvecbuf.order(ByteOrder.LITTLE_ENDIAN);
        int rawChangeDataLength = recvecbuf.getInt();
        int iovectorLength = recvecbuf.getInt();
        if (recvecbuf.position() + rawChangeDataLength + iovectorLength != data.length) {
            throw new SerializationException("Wrong value length. It should be " + (recvecbuf.position() + rawChangeDataLength + iovectorLength) + ", but received " + data.length);
        }
        ByteArrayInputStream rawChangeDataStream = new ByteArrayInputStream(data, recvecbuf.position(), rawChangeDataLength);
        ByteBuffer valuebuf = ByteBuffer.wrap(data, recvecbuf.position() + rawChangeDataLength, iovectorLength);
        boolean isJson = false;
        try {
            Dbserver.RawChangeData rdata = Dbserver.RawChangeData.parseFrom((InputStream)rawChangeDataStream);
            isJson = rdata.hasIsJson() && rdata.getIsJson();
            Map<Integer, String> idToCFNameMap = this.getIdCFNameMap(topic);
            if (idToCFNameMap == null) {
                throw new SerializationException("Fail to get column family ID to name mapping for topic " + topic);
            }
            Map<FieldPath, Integer> jsonPathMap = this.getJsonPath(topic);
            if (jsonPathMap == null && isJson) {
                throw new SerializationException("Fail to get jsonpath to column family ID mapping for topic " + topic);
            }
            if (isJson) {
                return new ChangeDataRecordImplJson(jsonPathMap, idToCFNameMap, rdata, valuebuf);
            }
            return new ChangeDataRecordImplBinary(idToCFNameMap, rdata, valuebuf);
        }
        catch (IOException | ExecutionException e) {
            byte[] rawChangeDataBytes = Arrays.copyOfRange(data, recvecbuf.position(), recvecbuf.position() + rawChangeDataLength);
            throw new SerializationException("Illegal value(" + BinaryString.toStringBinary((byte[])rawChangeDataBytes) + ").\n Protobuf parse failed.", (Throwable)e);
        }
    }

    public void close() {
        this.mAdmin_.close();
    }

    static {
        ShimLoader.load();
    }
}

