/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import com.mapr.db.Table;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.cdc.tests.TestCDPSUtil;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.KeyValue;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeDataRecord;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestCDPSMisc
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCDPSMisc.class);
    private static AdminImpl testAdmin = null;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        System.out.println("--- On single node cluster without other workload, these tests takes total about 3 minutes, please wait ---\nTestCDPSMisc#testNull          ------ 3 minutes\n");
        testAdmin = (AdminImpl)MapRDBImpl.newAdmin();
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        testAdmin.close();
        System.out.println("Done!");
    }

    public static void verifyL1NullArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL2NullArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL1NullFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL2NullFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname1, String fieldname2, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, fieldname1, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname2, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fieldname1, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL1DeleteArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, com.mapr.db.rowcol.KeyValue rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "c", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "c", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "c[0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, "c[1]", null);
        Assert.assertNull((Object)cd.getValue());
    }

    public static void verifyL2DeleteArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, com.mapr.db.rowcol.KeyValue rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "d", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "d", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[1][0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[1][1]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, "d[1][2]", null);
        Assert.assertNull((Object)cd.getValue());
    }

    public static void verifyL1DeleteFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname, null);
        Assert.assertNull((Object)cd.getValue());
        Assert.assertNull((Object)cd.getType());
    }

    public static void verifyL2DeleteFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname1, String fieldname2, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, fieldname1, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname2, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fieldname1, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname1 + "." + fieldname2, null);
        Assert.assertNull((Object)cd.getValue());
        Assert.assertNull((Object)cd.getType());
    }

    public static void verifyInitNullDataThroughReader1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "a0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "b0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "b1", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "b0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyInitDataThroughItr1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static DocumentMutation getMutOfAppendField(String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.append(fpname, "dummy1");
        return mutation;
    }

    public static DocumentMutation getMutOfAppendArray(String fpname) throws IOException {
        ArrayList<String> listaddition = new ArrayList<String>();
        listaddition.add("dummy2");
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.append(fpname, listaddition);
        return mutation;
    }

    public static Document setFieldNull(Table jsonTable, String rowid, String fpname) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        jsonTable.insertOrReplace(rowid, (Document)rec);
        return rec;
    }

    public static Document updateFieldNull(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setNull(fpname);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static Document setFieldBool(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set(fpname, true);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static Document replaceFieldInt(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setOrReplace(fpname, 111);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static void deleteField(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete(fpname);
        jsonTable.update(rowid, mutation);
    }

    public static void printChangeRec(ChangeDataRecord cdr) throws IOException {
        TestCDPSUtil.printChangeRecHeader(cdr);
        TestCDPSUtil.printChangeDataThroughReader(cdr);
        TestCDPSUtil.printChangeDataThroughIter(cdr);
    }

    @Test
    public void testNull() throws Exception {
        int RowCount = 10;
        String jsrc1 = "/tmp/jnullsrc1";
        String chglogdst1 = "/tmp/chglognulldst1";
        String topicFullName = chglogdst1 + ":jnullsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        Table jsonTable = MapRDBImpl.getTable((String)jsrc1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        DBDocumentImpl rec0 = new DBDocumentImpl();
        String rowid = "row0";
        rec0 = new DBDocumentImpl();
        rec0.setNull("a0").setNull("b0.b1").setNull("c[1]").setNull("d[1][2]");
        jsonTable.insertOrReplace(rowid, (Document)rec0);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        for (int i = 1; i < RowCount; ++i) {
            rowid = "row" + i;
            rec1 = new DBDocumentImpl();
            rec1.set("a0", "a0val").set("b0.b1", "b0b1val").set("c[1]", "c1").set("d[1][2]", "d1d2");
            jsonTable.insertOrReplace(rowid, (Document)rec1);
        }
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            rowid = "row" + i;
            if (i == 0) {
                TestCDPSMisc.verifyInitNullDataThroughReader1(rowid, cdr, (Document)rec0, isDebug);
                continue;
            }
            TestCDPSMisc.verifyInitDataThroughItr1(rowid, cdr, (Document)rec1, isDebug);
        }
        ArrayList<Document> presetValues = new ArrayList<Document>();
        rowid = "row1";
        Document rec = TestCDPSMisc.setFieldNull(jsonTable, rowid, "a0");
        presetValues.add(rec);
        rowid = "row2";
        rec = TestCDPSMisc.setFieldNull(jsonTable, rowid, "b0.b1");
        presetValues.add(rec);
        rowid = "row3";
        rec = TestCDPSMisc.setFieldNull(jsonTable, rowid, "c[1]");
        presetValues.add(rec);
        rowid = "row4";
        rec = TestCDPSMisc.setFieldNull(jsonTable, rowid, "d[1][2]");
        presetValues.add(rec);
        rowid = "row5";
        rec = new DBDocumentImpl();
        rec.setNull("a0").setNull("b0.b1").setNull("c[1]").setNull("d[1][2]");
        presetValues.add(rec);
        jsonTable.insertOrReplace(rowid, rec);
        jsonTable.flush();
        rowid = "row1";
        TestCDPSMisc.deleteField(jsonTable, rowid, "a0");
        rowid = "row2";
        TestCDPSMisc.deleteField(jsonTable, rowid, "b0.b1");
        rowid = "row3";
        TestCDPSMisc.deleteField(jsonTable, rowid, "c[1]");
        rowid = "row4";
        TestCDPSMisc.deleteField(jsonTable, rowid, "d[1][2]");
        rowid = "row5";
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete("a0").delete("b0.b1").delete("c[1]").delete("d[1][2]");
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        int i = 0;
        getListScf = TestCDPSUtil.fetchChangeData(10, consumerScf);
        crec = getListScf.get(i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1NullFieldThroughReader1("row1", cdr, "a0", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2NullFieldThroughReader1("row2", cdr, "b0", "b1", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1NullArrayThroughReader1("row3", cdr, "c", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2NullArrayThroughReader1("row4", cdr, "d", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1DeleteFieldThroughReader1("row1", cdr, "a0", isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2DeleteFieldThroughReader1("row2", cdr, "b0", "b1", isDebug);
        com.mapr.db.rowcol.KeyValue recval = new com.mapr.db.rowcol.KeyValue(Value.Type.NULL);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1DeleteArrayThroughReader1("row3", cdr, "c[1]", recval, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2DeleteArrayThroughReader1("row4", cdr, "d[1][2]", recval, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        ++i;
        jsonTable.close();
    }

    public void verifyTimeThroughIter(List<Long> timelist, ChangeDataRecord cdrec) throws Exception {
        ChangeDataRecordImpl cdr = (ChangeDataRecordImpl)cdrec;
        Iterator cdrItr = cdr.iterator();
        int count = 0;
        while (cdrItr.hasNext()) {
            Map.Entry cdEntry = (Map.Entry)cdrItr.next();
            String fpName = ((FieldPath)cdEntry.getKey()).asPathString();
            ChangeNodeImpl cd = (ChangeNodeImpl)cdEntry.getValue();
            if (count < timelist.size()) {
                Assert.assertEquals((long)timelist.get(count), (long)cd.getServerTimestamp());
            } else {
                int index = timelist.size() - 1;
                long lasttimestamp = index > 0 ? timelist.get(index) : 0L;
                System.out.println(index + ":" + lasttimestamp + ", " + count + ":" + cd.getServerTimestamp());
                Assert.assertTrue((lasttimestamp <= cd.getServerTimestamp() ? 1 : 0) != 0);
                timelist.add(cd.getServerTimestamp());
            }
            ++count;
        }
    }

    @Test
    public void testCtUtDt() throws Exception {
        int i;
        String rowid;
        int RowCount = 1;
        String jsrc1 = "/tmp/jctutdtsrc1";
        String chglogdst1 = "/tmp/chglogctutdtdst1";
        String topicFullName = chglogdst1 + ":jctutdtsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        Table jsonTable = MapRDBImpl.getTable((String)jsrc1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        Thread.sleep(5000L);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        int OpCount = 400;
        DBDocumentImpl rec1 = new DBDocumentImpl();
        for (int i2 = 0; i2 < RowCount; ++i2) {
            rowid = "row" + i2;
            rec1 = new DBDocumentImpl();
            rec1.set("ary1", Arrays.asList("a"));
            jsonTable.insertOrReplace(rowid, (Document)rec1);
        }
        ArrayList presetValues = new ArrayList();
        DocumentMutation mutation = null;
        for (int i3 = 0; i3 < RowCount; ++i3) {
            for (int j = 0; j < OpCount; ++j) {
                rowid = "row" + i3;
                mutation = MapRDBImpl.newMutation().append("ary1", Arrays.asList("b" + j));
                jsonTable.update(rowid, mutation);
            }
        }
        getListScf = TestCDPSUtil.fetchChangeData(RowCount * OpCount + RowCount, consumerScf);
        ArrayList<Long> timelist = new ArrayList<Long>();
        System.out.println("Inserted Rec:" + mutation + "\n Got:");
        for (i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            this.verifyTimeThroughIter(timelist, cdr);
        }
        System.out.println("Updated Rec:" + mutation + "\n Got:");
        for (i = 0; i < RowCount; ++i) {
            for (int j = 0; j < OpCount; ++j) {
                rowid = "row" + i;
                crec = getListScf.get(i * OpCount + j);
                cdr = (ChangeDataRecord)crec.value();
                TestCDPSMisc.printChangeRec(cdr);
                this.verifyTimeThroughIter(timelist, cdr);
            }
        }
        jsonTable.close();
    }
}

