/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import com.mapr.db.Table;
import com.mapr.db.cdc.impl.ChangeDataReaderImpl;
import com.mapr.db.cdc.tests.TestCDPSUtil;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.KeyValue;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeDataRecord;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestCDPSJSONWithCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCDPSJSONWithCluster.class);
    private static final String SRC_MCF_TABLE_NAME = "/tmp/jsonmcfsrc-TestCDPSJSONWithCluster";
    private static final String SRC_SCF_TABLE_NAME = "/tmp/jsonscfsrc-TestCDPSJSONWithCluster";
    private static final String DST_TABLE_NAME = "/tmp/cdpsdst-TestCDPSJSONWithCluster";
    private static final String DST_MCF_TOPIC_NAME = "jsonmcfsrc";
    private static final String DST_SCF_TOPIC_NAME = "jsonscfsrc";
    private static final String ROWID_PREFIX = "row";
    private static String jsonMcfSrcTableName = null;
    private static String jsonScfSrcTableName = null;
    private static String cdpsDstTableName = null;
    private static String cdpsMcfDstTopicName = null;
    private static String cdpsScfDstTopicName = null;
    private static Table jsonMcfSrcTable = null;
    private static Table jsonScfSrcTable = null;
    private static KafkaConsumer<byte[], ChangeDataRecord> consumerMcf = null;
    private static KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
    private static AdminImpl testAdmin = null;
    private static List<Document> presetValuesMcf = null;
    private static List<Document> presetValuesScf = null;
    private static List<String> presetFieldNamesScf = null;
    private static List<String> presetFieldNamesMcf = null;
    private static int putCount = 0;
    private static int initMapNum = 7;
    private static int initRowNum = 10;
    private static Document arrayWithAllTypeRec = null;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        jsonMcfSrcTableName = SRC_MCF_TABLE_NAME;
        jsonScfSrcTableName = SRC_SCF_TABLE_NAME;
        cdpsDstTableName = DST_TABLE_NAME;
        cdpsMcfDstTopicName = cdpsDstTableName + ":" + DST_MCF_TOPIC_NAME;
        cdpsScfDstTopicName = cdpsDstTableName + ":" + DST_SCF_TOPIC_NAME;
        System.out.println("srcMcf:" + jsonMcfSrcTableName + "srcScf:" + jsonScfSrcTableName + " dst:" + cdpsDstTableName + " dstMcfTopic:" + cdpsMcfDstTopicName + " dstScfTopic:" + cdpsScfDstTopicName);
        testAdmin = (AdminImpl)MapRDBImpl.newAdmin();
        presetValuesMcf = new ArrayList<Document>();
        presetValuesScf = new ArrayList<Document>();
        presetFieldNamesMcf = new ArrayList<String>();
        presetFieldNamesScf = new ArrayList<String>();
        Document putrecMcf = null;
        Document putrecScf = null;
        try {
            putCount = 0;
            jsonMcfSrcTable = TestCDPSUtil.replaceMcfJsonTable(testAdmin, jsonMcfSrcTableName);
            jsonScfSrcTable = TestCDPSUtil.replaceScfJsonTable(testAdmin, jsonScfSrcTableName);
            String strRowId = ROWID_PREFIX + putCount;
            putrecMcf = TestCDPSJSONWithCluster.putDataWithAllTypes(strRowId, jsonMcfSrcTable);
            putrecScf = TestCDPSJSONWithCluster.putDataWithAllTypes(strRowId, jsonScfSrcTable);
            presetValuesMcf.add(putrecMcf);
            presetValuesScf.add(putrecScf);
            presetFieldNamesMcf.add("");
            presetFieldNamesScf.add("");
            ++putCount;
            initMapNum = 7;
            while (putCount < initMapNum) {
                strRowId = ROWID_PREFIX + putCount;
                System.out.println("---put simpleMap to " + strRowId + " to table " + jsonMcfSrcTableName);
                putrecMcf = TestCDPSJSONWithCluster.putSimpleMap(strRowId, jsonMcfSrcTable);
                System.out.println("---put simpleMap to " + strRowId + " to table " + jsonScfSrcTableName);
                putrecScf = TestCDPSJSONWithCluster.putSimpleMap(strRowId, jsonScfSrcTable);
                presetValuesMcf.add(putrecMcf);
                presetValuesScf.add(putrecScf);
                presetFieldNamesMcf.add("");
                presetFieldNamesScf.add("");
                ++putCount;
            }
            initRowNum = 10;
            while (putCount < initRowNum) {
                strRowId = ROWID_PREFIX + putCount;
                System.out.println("---put ArrayWithAllTypes to " + strRowId + " to table " + jsonMcfSrcTableName);
                putrecMcf = TestCDPSJSONWithCluster.putArrayWithAllTypes(strRowId, jsonMcfSrcTable);
                System.out.println("---put ArrayWithAllTypes to " + strRowId + " to table " + jsonScfSrcTableName);
                putrecScf = TestCDPSJSONWithCluster.putArrayWithAllTypes(strRowId, jsonScfSrcTable);
                presetValuesMcf.add(putrecMcf);
                presetValuesScf.add(putrecScf);
                presetFieldNamesMcf.add("");
                presetFieldNamesScf.add("");
                ++putCount;
            }
            arrayWithAllTypeRec = putrecScf;
            TestCDPSUtil.replaceStreamTable(cdpsDstTableName);
            TestCDPSUtil.setupCDPSReplica(jsonMcfSrcTableName, cdpsDstTableName, cdpsMcfDstTopicName);
            TestCDPSUtil.setupCDPSReplica(jsonScfSrcTableName, cdpsDstTableName, cdpsScfDstTopicName);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        testAdmin.close();
        if (jsonMcfSrcTable != null) {
            // empty if block
        }
        if (jsonScfSrcTable != null) {
            // empty if block
        }
        if (MapRDBImpl.tableExists((String)cdpsDstTableName)) {
            // empty if block
        }
        System.out.println("Done!");
    }

    public static Document putSimpleMap(String rowid, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("mapA.fA", "valueA").set("mapB.fB", 100).set("mapB.mapC.fC", true).set("mapD.fD", "valueD");
        jsonTable.insertOrReplace(rowid, (Document)rec);
        return rec;
    }

    public static Document putDataWithAllTypes(String rowid, Table jsonTable) throws IOException {
        Document rec = TestMapRDBWithCluster.getMedRecord();
        jsonTable.insertOrReplace(rowid, rec);
        return rec;
    }

    public static Document putArrayWithAllTypes(String rowid, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("ArrayInArray[0][0]", "student1");
        rec.set("ArrayInArray[1][0]", "G1");
        rec.set("ArrayInArray[1][1]", "G2");
        rec.set("ArrayInArray[2][0]", 91);
        rec.set("ArrayInArray[2][1]", 92);
        rec.set("ArrayInArray[2][2]", 93);
        rec.set("mapD.MapInArray[0].name", "kid1");
        rec.set("mapD.MapInArray[1].name", "kid2");
        rec.set("mapD.MapInArray[1].score", 82);
        rec.set("mapB.mapC.SimpleArray[0]", "spring");
        rec.set("mapB.mapC.SimpleArray[2]", "fall");
        rec.setArray("arrayF[0]", new Object[]{"fieldValue1"});
        rec.set("arrayF[1].L1MapF1", "L1MapF1Value1");
        rec.set("arrayF[1].L1MapF2", "L1MapF2Value2");
        rec.set("arrayF[2][0].L2MapF11", "L2MapF11Value11");
        rec.set("arrayF[2][1].L2MapF21", "L2MapF21Value21");
        rec.set("arrayF[2][1].L2MapF22", "L2MapF21Value22");
        rec.set("arrayF[3][0][0]", "L3ArrayValue111");
        rec.set("arrayF[3][1][0]", "L3ArrayValue121");
        rec.set("arrayF[3][2][0]", "L3ArrayValue131");
        rec.set("arrayF[3][2][1]", "L3ArrayValue132");
        jsonTable.insertOrReplace(rowid, (Document)rec);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceRow(String rowid, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("mapA.fA", "replacedValueA").set("mapB.fB", 200).set("mapB.mapC.fC", false).set("mapD.fD", "replacedValueD");
        jsonTable.insertOrReplace(rowid, (Document)rec);
        jsonTable.flush();
        return rec;
    }

    public static void deleteRow(String rowid, Table jsonTable) throws IOException {
        jsonTable.delete(rowid);
        jsonTable.flush();
    }

    public static Document insertRow(String rowid, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("mapA.fA", "insertedValueA").set("mapB.fB", 300).set("mapB.mapC.fC", true).set("mapD.fD", "insertedValueD");
        jsonTable.insertOrReplace(rowid, (Document)rec);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceMap(String rowid, String fieldName, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("fRep1", "replacedCF1").set("fRep2", 400);
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set(fieldName, (Document)rec);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static void deleteField(String rowid, String fieldName, Table jsonTable) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete(fieldName);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
    }

    public static Document deleteArrayField(String rowid, String fieldName, Table jsonTable, Document origDoc) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete(fieldName);
        Document newdoc = TestCDPSUtil.copyDoc(origDoc);
        newdoc.delete(fieldName);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return newdoc;
    }

    public static Document insertMap(String rowid, String fieldName, Table jsonTable) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("fIns1", "insertedCF1").set("fIns2", 500);
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set(fieldName, (Document)rec);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceArrayItem(String rowid, String fieldName, String strValue, Table jsonTable, Document origDoc) throws IOException {
        return TestCDPSJSONWithCluster.replaceArrayItem(rowid, fieldName, strValue, jsonTable, origDoc, null);
    }

    public static Document replaceArrayItem(String rowid, String fieldName, String strValue, Table jsonTable, Document origDoc, String correctedFieldName) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setOrReplace(fieldName, strValue);
        Document rec = TestCDPSUtil.copyDoc(origDoc);
        if (correctedFieldName != null) {
            rec.set(correctedFieldName, strValue);
        } else {
            rec.set(fieldName, strValue);
        }
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceArrayInArray(String rowid, String fieldName, Table jsonTable, Document origDoc) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        ArrayList<String> alist = new ArrayList<String>();
        alist.add("replacedItem1");
        alist.add("replacedItem2");
        alist.add("replacedItem3");
        mutation.setOrReplace(fieldName, alist);
        Document rec = TestCDPSUtil.copyDoc(origDoc);
        rec.set(fieldName, alist);
        System.out.println("origDoc:" + origDoc + "\n putDoc: " + rec);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceArray(String rowid, String fieldName, Table jsonTable) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        ArrayList<String> alist = new ArrayList<String>();
        alist.add("replacedItem1");
        alist.add("replacedItem2");
        alist.add("replacedItem3");
        mutation.setOrReplace(fieldName, alist);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set(fieldName, alist);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document insertArray(String rowid, String fieldName, Table jsonTable) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        ArrayList<String> alist = new ArrayList<String>();
        alist.add("insertedItem1");
        alist.add("insertedItem2");
        alist.add("insertedItem3");
        mutation.setOrReplace(fieldName, alist);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set(fieldName, alist);
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document replaceField(String rowid, String fieldName, Table jsonTable) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setOrReplace(fieldName, "replacedLeafNode");
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set(fieldName, "replacedLeafNode");
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static Document insertField(String rowid, String fieldName, Table jsonTable) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setOrReplace(fieldName, "insertedLeafNode");
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set(fieldName, "insertedLeafNode");
        jsonTable.update(rowid, mutation);
        jsonTable.flush();
        return rec;
    }

    public static void verifyArrayWithAllTypesThroughIter(ChangeDataRecord cdr, Document rec, long opTime) {
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyDataWithAllTypesThroughIter(ChangeDataRecord cdr, Document rec, long opTime) {
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyArrayWithAllTypesThroughReaderScf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "arrayF", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[1].L1MapF1");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L1MapF1", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[1].L1MapF2");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L1MapF2", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][0].L2MapF11");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF11", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][1].L2MapF21");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF21", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][1].L2MapF22");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF22", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "arrayF", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "MapInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[0].name");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "name", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[1].name");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "name", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[1].score");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "score", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "MapInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayWithAllTypesThroughReaderMcf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "arrayF", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[1].L1MapF1");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L1MapF1", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[1].L1MapF2");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L1MapF2", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][0].L2MapF11");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF11", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][1].L2MapF21");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF21", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[2][1].L2MapF22");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "L2MapF22", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("arrayF[3][2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "arrayF", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "MapInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[0].name");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "name", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[1].name");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "name", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.MapInArray[1].score");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "score", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "MapInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal, true);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyDataWithAllTypesThroughReader(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Date");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "Date", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "Friends", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Friends[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Friends[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Friends[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "Friends", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("NAME");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "NAME", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("NULL");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "NULL", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "Scores", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Scores[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Scores[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Scores[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "Scores", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("Time");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "Time", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("binary3");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "binary3", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("boolean");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "boolean", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("byte");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "byte", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "map", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "Array2", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.Array2[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.Array2[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.Array2[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "Array2", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "LIST", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "LIST", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "LIST2", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[3][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[3][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[3][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.LIST2[3][3]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "LIST2", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "boolarray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.boolarray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.boolarray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.boolarray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "boolarray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.boolean");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "boolean", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.byte");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "byte", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.double");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "double", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.float");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "float", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.int");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "int", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.long");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "long", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.short");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "short", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("map.string");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "string", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "map", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("string");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "string", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyFieldDelete(String strRowId, ChangeDataRecord cdr, Document rec, String fieldname) throws IOException {
        Iterator cdrItr = cdr.iterator();
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname, null);
        ChangeDataReader reader = cdr.getReader();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        String[] fieldnames = fieldname.split("\\.");
        int levelcount = fieldnames.length;
        Assert.assertEquals((Object)true, (Object)(levelcount >= 1 ? 1 : 0));
        for (int idx = 0; idx < levelcount - 1; ++idx) {
            String fn = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, fn, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        String fname = fieldnames[levelcount - 1];
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fname, null);
        for (int idx = levelcount - 2; idx >= 0; --idx) {
            String fn = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fn, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayWithAllTypes(String strRowId, ChangeDataRecord cdr, Document rec, boolean isMcf) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        long opTime = cdr.getOpTimestamp();
        if (isMcf) {
            TestCDPSJSONWithCluster.verifyArrayWithAllTypesThroughReaderMcf(cdr, rec, opTime);
            TestCDPSJSONWithCluster.verifyArrayWithAllTypesThroughIter(cdr, rec, opTime);
        } else {
            TestCDPSJSONWithCluster.verifyArrayWithAllTypesThroughReaderScf(cdr, rec, opTime);
            TestCDPSJSONWithCluster.verifyArrayWithAllTypesThroughIter(cdr, rec, opTime);
        }
    }

    public static void verifyDataWithAllTypes(String strRowId, ChangeDataRecord cdr, Document rec) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyDataWithAllTypesThroughReader(cdr, rec, opTime);
        TestCDPSJSONWithCluster.verifyDataWithAllTypesThroughIter(cdr, rec, opTime);
    }

    public static void verifyReplaceRowMapThroughIter(ChangeDataRecord cdr, Document rec, long opTime) {
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifySimpleMapThroughIter(ChangeDataRecord cdr, Document rec, long opTime) {
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyReplaceRowMapThroughReaderMcf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapA.fA");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fA", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.fD");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fD", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.fB");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fB", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.fC");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fC", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyReplaceRowMapThroughReaderScf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapA.fA");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fA", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.fB");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fB", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.fC");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fC", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.fD");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fD", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifySimpleMapThroughReaderMcf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReaderImpl reader = (ChangeDataReaderImpl)cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        ndVal = rec.getValue("mapA.fA");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fA", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        ndVal = rec.getValue("mapD.fD");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fD", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        ndVal = rec.getValue("mapB.fB");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fB", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        ndVal = rec.getValue("mapB.mapC.fC");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fC", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader((ChangeDataReader)reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifySimpleMapThroughReaderScf(ChangeDataRecord cdr, Document rec, long opTime) {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapA.fA");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fA", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapA", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.fB");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fB", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.fC");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fC", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapD.fD");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "fD", ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapD", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyReplaceRowMap(String strRowId, ChangeDataRecord cdr, Document rec, boolean isMcf) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        System.out.println("rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.printChangeDataThroughReader(cdr);
        if (isMcf) {
            TestCDPSJSONWithCluster.verifyReplaceRowMapThroughReaderMcf(cdr, rec, opTime);
        } else {
            TestCDPSJSONWithCluster.verifyReplaceRowMapThroughReaderScf(cdr, rec, opTime);
        }
        TestCDPSJSONWithCluster.verifyReplaceRowMapThroughIter(cdr, rec, opTime);
    }

    private static String getPutMethodFieldName1(PutMethod pm) throws IOException {
        switch (pm) {
            case InsertMap: {
                return "fIns1";
            }
            case ReplaceMap: {
                return "fRep1";
            }
        }
        throw new IOException("No need to field name for PutMethod " + (Object)((Object)pm));
    }

    private static String getPutMethodFieldName2(PutMethod pm) throws IOException {
        switch (pm) {
            case InsertMap: {
                return "fIns2";
            }
            case ReplaceMap: {
                return "fRep2";
            }
        }
        throw new IOException("No need to field name for PutMethod " + (Object)((Object)pm));
    }

    public static void verifySimpleArrayThroughIter(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndVal = rec.getValue(fieldname);
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname, ndVal);
    }

    public static void verifyArrayInArrayThroughIterL1(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            Value ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterL4(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = (KeyValue)cdrItr.next();
        ChangeNode cn = (ChangeNode)tmpPair.getValue();
        String fname = ((FieldPath)tmpPair.getKey()).asPathString();
        TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
        ndPutVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[1][0]", ndPutVal);
        ndPutVal = rec.getValue("ArrayInArray[0][1]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[1][1]", ndPutVal);
        ndPutVal = rec.getValue("ArrayInArray[0][2]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[1][2]", ndPutVal);
        ndPutVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[2][0]", ndPutVal);
        ndPutVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[2][1]", ndPutVal);
        ndPutVal = rec.getValue("ArrayInArray[1][2]");
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "ArrayInArray[2][2]", ndPutVal);
    }

    public static void verifyArrayInArrayThroughIterL5(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("ArrayInArray[1][1]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            if (fname.equals("ArrayInArray[1][2]")) {
                ndPutVal = rec.getValue("ArrayInArray[1][1]");
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterL6(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("ArrayInArray[1][2]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterM1(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("mapB.mapC.SimpleArray[1]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            if (fname.equals("mapB.mapC.SimpleArray[2]")) {
                ndPutVal = rec.getValue("mapB.mapC.SimpleArray[1]");
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterM3(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("mapB.mapC.SimpleArray[0]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            if (fname.equals("mapB.mapC.SimpleArray[1]")) {
                ndPutVal = rec.getValue("mapB.mapC.SimpleArray[0]");
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterN4(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("mapE.NewArray[0]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            if (fname.equals("mapE.NewArray[1]")) {
                ndPutVal = rec.getValue("mapE.NewArray[0]");
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
                continue;
            }
            if (fname.equals("mapE.NewArray[2]")) {
                ndPutVal = rec.getValue("mapE.NewArray[1]");
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyArrayInArrayThroughIterN5(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndPutVal = null;
        KeyValue tmpPair = null;
        while (cdrItr.hasNext()) {
            tmpPair = (KeyValue)cdrItr.next();
            ChangeNode cn = (ChangeNode)tmpPair.getValue();
            String fname = ((FieldPath)tmpPair.getKey()).asPathString();
            if (fname.equals("mapE.NewArray[2]")) {
                TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, fname, null);
                continue;
            }
            ndPutVal = rec.getValue(fname);
            TestCDPSUtil.assertNodeEquals(cn, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, fname, ndPutVal);
        }
    }

    public static void verifyCFMapThroughIter(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname, (Value)rec);
    }

    public static void verifySimpleFieldThroughIter(ChangeDataRecord cdr, Document rec, long opTime, String fieldname) {
        Iterator cdrItr = cdr.iterator();
        Value ndVal = rec.getValue(fieldname);
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname, ndVal);
    }

    public static void verifyCFMapThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String[] fieldnames, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        int levelcount = fieldnames.length;
        Assert.assertEquals((Object)true, (Object)(levelcount >= 1 ? 1 : 0));
        for (int idx = 0; idx < levelcount; ++idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            ChangeOp tmpOp = idx == levelcount - 1 ? ChangeOp.SET : ChangeOp.MERGE;
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, tmpOp, opTime, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        String fname = TestCDPSJSONWithCluster.getPutMethodFieldName1(pMethod);
        ndVal = rec.getValue(fname);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        fname = TestCDPSJSONWithCluster.getPutMethodFieldName2(pMethod);
        ndVal = rec.getValue(fname);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        for (int idx = levelcount - 1; idx >= 0; --idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifySimpleArrayThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        String[] fieldnames = putname.split("\\.");
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        int levelcount = fieldnames.length;
        Assert.assertEquals((Object)true, (Object)(levelcount >= 1 ? 1 : 0));
        for (int idx = 0; idx < levelcount - 1; ++idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        String fname = fieldnames[levelcount - 1];
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, fname, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue(putname + "[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue(putname + "[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue(putname + "[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, fname, null);
        for (int idx = levelcount - 2; idx >= 0; --idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL1ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue(putname);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL2ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL3ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[2][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL4ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessThanGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL5ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL6ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldL7ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[0][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("ArrayInArray[1][2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "ArrayInArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM1ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM2ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM3ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM4ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM5ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldM6ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapB.mapC.SimpleArray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "SimpleArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapC", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapB", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldN1ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldN2ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldN3ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[2]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldN4ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyArrayInArrayFieldN5ThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[0]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        ndVal = rec.getValue("mapE.NewArray[1]");
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, ndVal);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.NULL, 0L, "NewArray", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, "mapE", null);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifySimpleFieldThroughReader(ChangeDataRecord cdr, Document rec, long opTime, String putname, PutMethod pMethod) throws IOException {
        String[] fieldnames = putname.split("\\.");
        int levelcount = fieldnames.length;
        Assert.assertEquals((Object)true, (Object)(levelcount >= 1 ? 1 : 0));
        ChangeDataReader reader = cdr.getReader();
        Value ndVal = null;
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, null);
        for (int idx = 0; idx < levelcount - 1; ++idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        String fname = fieldnames[levelcount - 1];
        ndVal = rec.getValue(putname);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fname, ndVal);
        for (int idx = levelcount - 2; idx >= 0; --idx) {
            String fieldname = fieldnames[idx];
            cd = TestCDPSUtil.moveToNextNodeReader(reader);
            TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, fieldname, null);
        }
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.NULL, 0L, null, null);
    }

    public static void verifyCFMap(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        String[] fields = putfield.split("\\.");
        TestCDPSJSONWithCluster.verifyCFMapThroughReader(cdr, rec, opTime, fields, pMethod);
        TestCDPSJSONWithCluster.verifyCFMapThroughIter(cdr, rec, opTime, putfield);
    }

    public static void verifySimpleMap(String strRowId, ChangeDataRecord cdr, Document rec, boolean isMcf) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        System.out.println("rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        if (isMcf) {
            TestCDPSJSONWithCluster.verifySimpleMapThroughReaderMcf(cdr, rec, opTime);
        } else {
            TestCDPSJSONWithCluster.verifySimpleMapThroughReaderScf(cdr, rec, opTime);
        }
        TestCDPSJSONWithCluster.verifySimpleMapThroughIter(cdr, rec, opTime);
    }

    public static void verifySimpleArray(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifySimpleArrayThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifySimpleArrayThroughIter(cdr, rec, opTime, putfield);
    }

    public static void verifySimpleField(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifySimpleFieldThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifySimpleFieldThroughIter(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL1(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL1ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL2(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL2ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL3(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL3ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL4(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL4ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL4(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL5(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL5ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL5(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL6(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL6ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL6(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldL7(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldL7ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM1(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM1ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterM1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM2(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM2ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM3(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM3ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterM3(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM4(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM4ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM5(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM5ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldM6(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldM6ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldN1(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldN1ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldN2(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldN2ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldN3(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldN3ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterL1(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldN4(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldN4ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterN4(cdr, rec, opTime, putfield);
    }

    public static void verifyArrayInArrayFieldN5(String strRowId, ChangeDataRecord cdr, Document rec, String putfield, PutMethod pMethod) throws IOException {
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        System.out.println("field:" + putfield + "rec: " + rec);
        long opTime = cdr.getOpTimestamp();
        TestCDPSJSONWithCluster.verifyArrayInArrayFieldN5ThroughReader(cdr, rec, opTime, putfield, pMethod);
        TestCDPSJSONWithCluster.verifyArrayInArrayThroughIterN5(cdr, rec, opTime, putfield);
    }

    public static void processOneNode(String strRowId, VerifyMethod vfMethod, PutMethod pMethod, ConsumerRecord<byte[], ChangeDataRecord> crec, int getCount, String msg, boolean isDebug, boolean isMcf, List<Document> presetValues, List<String> presetFieldNames) throws IOException {
        ChangeDataRecord cdr = (ChangeDataRecord)crec.value();
        Document putrec = presetValues.get(getCount);
        String putfield = presetFieldNames.get(getCount);
        if (isDebug) {
            System.out.println("\n------ " + strRowId + ":" + msg + "--------\n" + putrec + "\n");
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
        }
        switch (vfMethod) {
            case VerifySimpleMap: {
                TestCDPSJSONWithCluster.verifySimpleMap(strRowId, cdr, putrec, isMcf);
                break;
            }
            case VerifyReplaceRowMap: {
                TestCDPSJSONWithCluster.verifyReplaceRowMap(strRowId, cdr, putrec, isMcf);
                break;
            }
            case VerifyCFMap: {
                TestCDPSJSONWithCluster.verifyCFMap(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyRowDelete: {
                TestCDPSUtil.verifyRowDelete(strRowId, cdr);
                break;
            }
            case VerifyFieldDelete: {
                TestCDPSJSONWithCluster.verifyFieldDelete(strRowId, cdr, putrec, putfield);
                break;
            }
            case VerifySimpleArray: {
                TestCDPSJSONWithCluster.verifySimpleArray(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifySimpleField: {
                TestCDPSJSONWithCluster.verifySimpleField(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL1: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL1(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL2: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL2(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL3: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL3(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL4: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL4(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL5: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL5(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL6: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL6(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldL7: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldL7(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM1: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM1(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM2: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM2(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM3: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM3(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM4: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM4(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM5: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM5(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldM6: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldM6(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldN1: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldN1(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldN2: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldN2(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldN3: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldN3(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldN4: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldN4(strRowId, cdr, putrec, putfield, pMethod);
                break;
            }
            case VerifyArrayInArrayFieldN5: {
                TestCDPSJSONWithCluster.verifyArrayInArrayFieldN5(strRowId, cdr, putrec, putfield, pMethod);
            }
        }
    }

    @Test
    public void testJsonConsumer() throws Exception {
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListMcf = null;
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        ChangeDataRecord cdr = null;
        int getCount = 0;
        String strRowId = null;
        Document putrec = null;
        Document mutrecMcf = null;
        Document mutrecScf = null;
        boolean isDebug = false;
        consumerMcf = TestCDPSUtil.startConsumer(cdpsMcfDstTopicName);
        consumerScf = TestCDPSUtil.startConsumer(cdpsScfDstTopicName);
        getListMcf = TestCDPSUtil.fetchChangeData(initRowNum, consumerMcf);
        getListScf = TestCDPSUtil.fetchChangeData(initRowNum, consumerScf);
        strRowId = ROWID_PREFIX + getCount;
        crec = getListMcf.get(0);
        cdr = (ChangeDataRecord)crec.value();
        if (isDebug) {
            System.out.println("\n------ " + strRowId + "--------");
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
        }
        putrec = presetValuesMcf.get(getCount);
        TestCDPSJSONWithCluster.verifyDataWithAllTypes(strRowId, cdr, putrec);
        crec = getListScf.get(0);
        cdr = (ChangeDataRecord)crec.value();
        if (isDebug) {
            System.out.println("\n------ " + strRowId + "--------");
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
        }
        putrec = presetValuesScf.get(getCount);
        TestCDPSJSONWithCluster.verifyDataWithAllTypes(strRowId, cdr, putrec);
        ++getCount;
        while (getCount < initMapNum) {
            strRowId = ROWID_PREFIX + getCount;
            crec = getListMcf.get(getCount);
            cdr = (ChangeDataRecord)crec.value();
            putrec = presetValuesMcf.get(getCount);
            System.out.println("\n------ MCF " + strRowId + "--------");
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSJSONWithCluster.verifySimpleMap(strRowId, cdr, putrec, true);
            crec = getListScf.get(getCount);
            cdr = (ChangeDataRecord)crec.value();
            putrec = presetValuesScf.get(getCount);
            System.out.println("\n------ SCF " + strRowId + "--------");
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSJSONWithCluster.verifySimpleMap(strRowId, cdr, putrec, false);
            ++getCount;
        }
        while (getCount < initRowNum) {
            strRowId = ROWID_PREFIX + getCount;
            crec = getListMcf.get(getCount);
            cdr = (ChangeDataRecord)crec.value();
            putrec = presetValuesMcf.get(getCount);
            System.out.println("\n------ MCF " + strRowId + "--------");
            System.out.println("\nMCF rec:" + putrec);
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSJSONWithCluster.verifyArrayWithAllTypes(strRowId, cdr, putrec, true);
            crec = getListScf.get(getCount);
            cdr = (ChangeDataRecord)crec.value();
            putrec = presetValuesScf.get(getCount);
            System.out.println("\n------ SCF " + strRowId + "--------");
            System.out.println("\nSCF rec:" + putrec);
            TestCDPSUtil.printChangeRecHeader(cdr);
            TestCDPSUtil.printChangeDataThroughReader(cdr);
            TestCDPSUtil.printChangeDataThroughIter(cdr);
            TestCDPSJSONWithCluster.verifyArrayWithAllTypes(strRowId, cdr, putrec, false);
            ++getCount;
        }
        System.out.println("passed verify mutations from copyRegion");
        System.out.println("putCount " + putCount + ". Now generating mutations for bucket replication:");
        System.out.println("bucket row put");
        int rowOpId = 1;
        strRowId = ROWID_PREFIX + rowOpId;
        mutrecMcf = TestCDPSJSONWithCluster.replaceRow(strRowId, jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceRow(strRowId, jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("");
        presetFieldNamesScf.add("");
        ++putCount;
        TestCDPSJSONWithCluster.deleteRow(strRowId, jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteRow(strRowId, jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("");
        presetFieldNamesScf.add("");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertRow(strRowId, jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertRow(strRowId, jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("");
        presetFieldNamesScf.add("");
        ++putCount;
        System.out.println("bucket CF put");
        int cfOpId = rowOpId + 1;
        strRowId = ROWID_PREFIX + cfOpId;
        mutrecMcf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapD", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapD", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapD");
        presetFieldNamesScf.add("mapD");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mapC", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mapC", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapB.mapC");
        presetFieldNamesScf.add("mapB.mapC");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapB.mapC", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapB.mapC", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC");
        presetFieldNamesScf.add("mapB.mapC");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapE", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapE", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE");
        presetFieldNamesScf.add("mapE");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapE");
        presetFieldNamesScf.add("mapE");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapE", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapE", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE");
        presetFieldNamesScf.add("mapE");
        ++putCount;
        System.out.println("bucket map put");
        int mapOpId = cfOpId + 1;
        strRowId = ROWID_PREFIX + mapOpId;
        mutrecMcf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapA.mapAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapA.mapAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapA.mapAX");
        presetFieldNamesScf.add("mapA.mapAX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapA.mapAX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapA.mapAX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapA.mapAX");
        presetFieldNamesScf.add("mapA.mapAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapA.mapAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapA.mapAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapA.mapAX");
        presetFieldNamesScf.add("mapA.mapAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapD.mapDX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapD.mapDX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapD.mapDX");
        presetFieldNamesScf.add("mapD.mapDX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapD.mapDX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapD.mapDX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapD.mapDX");
        presetFieldNamesScf.add("mapD.mapDX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapD.mapDX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapD.mapDX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapD.mapDX");
        presetFieldNamesScf.add("mapD.mapDX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapE.mapEX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceMap(strRowId, "mapE.mapEX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.mapEX");
        presetFieldNamesScf.add("mapE.mapEX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.mapEX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.mapEX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapE.mapEX");
        presetFieldNamesScf.add("mapE.mapEX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapE.mapEX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertMap(strRowId, "mapE.mapEX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.mapEX");
        presetFieldNamesScf.add("mapE.mapEX");
        ++putCount;
        System.out.println("bucket array put");
        int aryOpId = mapOpId + 1;
        strRowId = ROWID_PREFIX + aryOpId;
        mutrecMcf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapA.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapA.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapA.arrayAX");
        presetFieldNamesScf.add("mapA.arrayAX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapA.arrayAX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapA.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapA.arrayAX");
        presetFieldNamesScf.add("mapA.arrayAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapA.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapA.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapA.arrayAX");
        presetFieldNamesScf.add("mapA.arrayAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapB.mapC.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapB.mapC.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.arrayAX");
        presetFieldNamesScf.add("mapB.mapC.arrayAX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mapC.arrayAX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mapC.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapB.mapC.arrayAX");
        presetFieldNamesScf.add("mapB.mapC.arrayAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapB.mapC.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapB.mapC.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.arrayAX");
        presetFieldNamesScf.add("mapB.mapC.arrayAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapE.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceArray(strRowId, "mapE.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.arrayAX");
        presetFieldNamesScf.add("mapE.arrayAX");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.arrayAX", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapE.arrayAX");
        presetFieldNamesScf.add("mapE.arrayAX");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapE.arrayAX", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertArray(strRowId, "mapE.arrayAX", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.arrayAX");
        presetFieldNamesScf.add("mapE.arrayAX");
        System.out.println("putCount " + ++putCount + ". bucket map field put");
        int mfOpId = aryOpId + 1;
        strRowId = ROWID_PREFIX + mfOpId;
        mutrecMcf = TestCDPSJSONWithCluster.replaceField(strRowId, "mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceField(strRowId, "mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mfield");
        presetFieldNamesScf.add("mfield");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mfield", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mfield", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mfield");
        presetFieldNamesScf.add("mfield");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertField(strRowId, "mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertField(strRowId, "mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mfield");
        presetFieldNamesScf.add("mfield");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceField(strRowId, "mapB.mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceField(strRowId, "mapB.mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mfield");
        presetFieldNamesScf.add("mapB.mfield");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mfield", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapB.mfield", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapB.mfield");
        presetFieldNamesScf.add("mapB.mfield");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertField(strRowId, "mapB.mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertField(strRowId, "mapB.mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mfield");
        presetFieldNamesScf.add("mapB.mfield");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.replaceField(strRowId, "mapE.mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.replaceField(strRowId, "mapE.mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.mfield");
        presetFieldNamesScf.add("mapE.mfield");
        ++putCount;
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.mfield", jsonMcfSrcTable);
        TestCDPSJSONWithCluster.deleteField(strRowId, "mapE.mfield", jsonScfSrcTable);
        presetValuesMcf.add(null);
        presetValuesScf.add(null);
        presetFieldNamesMcf.add("mapE.mfield");
        presetFieldNamesScf.add("mapE.mfield");
        ++putCount;
        mutrecMcf = TestCDPSJSONWithCluster.insertField(strRowId, "mapE.mfield", jsonMcfSrcTable);
        mutrecScf = TestCDPSJSONWithCluster.insertField(strRowId, "mapE.mfield", jsonScfSrcTable);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.mfield");
        presetFieldNamesScf.add("mapE.mfield");
        System.out.println("putCount " + ++putCount + "record, now go to bucket array field put");
        int afOpId = initMapNum + 1;
        strRowId = ROWID_PREFIX + afOpId;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[0]", "teacher1", jsonMcfSrcTable, arrayWithAllTypeRec);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[0]", "teacher1", jsonScfSrcTable, arrayWithAllTypeRec);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[0]");
        presetFieldNamesScf.add("ArrayInArray[0]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[1][1]", "K", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[1][1]", "K", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[1][1]");
        presetFieldNamesScf.add("ArrayInArray[1][1]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[1][3]", "G3", jsonMcfSrcTable, mutrecMcf, "ArrayInArray[1][2]");
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "ArrayInArray[1][3]", "G3", jsonScfSrcTable, mutrecScf, "ArrayInArray[1][2]");
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[1][3]");
        presetFieldNamesScf.add("ArrayInArray[1][3]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[0]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[0]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[0]");
        presetFieldNamesScf.add("ArrayInArray[0]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[1][1]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[1][1]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[1][1]");
        presetFieldNamesScf.add("ArrayInArray[1][1]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, true);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[1][5]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "ArrayInArray[1][5]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[1][5]");
        presetFieldNamesScf.add("ArrayInArray[1][5]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, true);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayInArray(strRowId, "ArrayInArray[1]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayInArray(strRowId, "ArrayInArray[1]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("ArrayInArray[1]");
        presetFieldNamesScf.add("ArrayInArray[1]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapB.mapC.SimpleArray[1]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapB.mapC.SimpleArray[1]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[1]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[1]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[1]", "summer", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[1]", "summer", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[1]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[1]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapB.mapC.SimpleArray[0]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapB.mapC.SimpleArray[0]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[0]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[0]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[2]", "winter", jsonMcfSrcTable, mutrecMcf, "mapB.mapC.SimpleArray[1]");
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[2]", "winter", jsonScfSrcTable, mutrecScf, "mapB.mapC.SimpleArray[1]");
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[2]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[2]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[4]", "nomoreseason", jsonMcfSrcTable, mutrecMcf, "mapB.mapC.SimpleArray[2]");
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[4]", "nomoreseason", jsonScfSrcTable, mutrecScf, "mapB.mapC.SimpleArray[2]");
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[4]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[4]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[0]", "spring", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapB.mapC.SimpleArray[0]", "spring", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapB.mapC.SimpleArray[0]");
        presetFieldNamesScf.add("mapB.mapC.SimpleArray[0]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[3]", "circle", jsonMcfSrcTable, mutrecMcf, "mapE.NewArray[0]");
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[3]", "circle", jsonScfSrcTable, mutrecScf, "mapE.NewArray[0]");
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.NewArray[3]");
        presetFieldNamesScf.add("mapE.NewArray[3]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[2]", "square", jsonMcfSrcTable, mutrecMcf, "mapE.NewArray[1]");
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[2]", "square", jsonScfSrcTable, mutrecScf, "mapE.NewArray[1]");
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.NewArray[2]");
        presetFieldNamesScf.add("mapE.NewArray[2]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[2]", "rectangle", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.replaceArrayItem(strRowId, "mapE.NewArray[2]", "rectangle", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.NewArray[2]");
        presetFieldNamesScf.add("mapE.NewArray[2]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapE.NewArray[0]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapE.NewArray[0]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.NewArraymapB.mapC.SimpleArray[0]");
        presetFieldNamesScf.add("mapE.NewArraymapB.mapC.SimpleArray[0]");
        ++putCount;
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        mutrecMcf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapE.NewArray[2]", jsonMcfSrcTable, mutrecMcf);
        mutrecScf = TestCDPSJSONWithCluster.deleteArrayField(strRowId, "mapE.NewArray[2]", jsonScfSrcTable, mutrecScf);
        presetValuesMcf.add(mutrecMcf);
        presetValuesScf.add(mutrecScf);
        presetFieldNamesMcf.add("mapE.NewArray[2]");
        presetFieldNamesScf.add("mapE.NewArray[2]");
        TestCDPSUtil.fetchTableRecAndPause(strRowId, jsonMcfSrcTable, false);
        System.out.println("Put " + ++putCount + "records. Please wait for bucket replcation to finish");
        boolean isMcf = true;
        boolean isScf = !isMcf;
        int idxInBucket = 0;
        int bucketPutCount = putCount - initRowNum;
        getListMcf = TestCDPSUtil.fetchChangeDataWithBreak(bucketPutCount, consumerMcf, 240);
        System.out.println("Done bucket fetch Mcf, get count" + getListMcf.size());
        getListScf = TestCDPSUtil.fetchChangeDataWithBreak(bucketPutCount, consumerScf, 240);
        System.out.println("Done bucket fetch Scf, get count" + getListScf.size());
        strRowId = ROWID_PREFIX + rowOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyReplaceRowMap, null, getListMcf.get(idxInBucket), getCount, "replace row", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyReplaceRowMap, null, getListScf.get(idxInBucket), getCount, "replace row", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyRowDelete, null, getListMcf.get(++idxInBucket), ++getCount, "delete row", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyRowDelete, null, getListScf.get(idxInBucket), getCount, "delete row", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyReplaceRowMap, null, getListMcf.get(++idxInBucket), ++getCount, "insert row", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyReplaceRowMap, null, getListScf.get(idxInBucket), getCount, "insert row", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        System.out.println("passed verify bucket row mutation");
        strRowId = ROWID_PREFIX + cfOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListMcf.get(++idxInBucket), ++getCount, "replace cf: mapD with data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListScf.get(idxInBucket), getCount, "replace cf: mapD with data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "delete cf: mapD with data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "delete cf: mapD with data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListMcf.get(++idxInBucket), ++getCount, "insert cf: mapD with data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListScf.get(idxInBucket), getCount, "insert cf: mapD with data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListMcf.get(++idxInBucket), ++getCount, "replace cf : mapE no data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListScf.get(idxInBucket), getCount, "replace cf : mapE no data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "delete cf : mapE no data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "delete cf : mapE no data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListMcf.get(++idxInBucket), ++getCount, "insert cf : mapE no data CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListScf.get(idxInBucket), getCount, "insert cf : mapE no data CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        System.out.println("passed verify bucket CF mutation");
        strRowId = ROWID_PREFIX + mapOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListMcf.get(++idxInBucket), ++getCount, "replace cf: mapA.mapAX in default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListScf.get(idxInBucket), getCount, "replace cf: mapA.mapAX in default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "delete cf: mapA.mapAX in default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "delete cf: mapA.mapAX in default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListMcf.get(++idxInBucket), ++getCount, "insert cf: mapA.mapAX in default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListScf.get(idxInBucket), getCount, "insert cf: mapA.mapAX in default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListMcf.get(++idxInBucket), ++getCount, "replace cf: mapD.mapDX in non-default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListScf.get(idxInBucket), getCount, "replace cf: mapD.mapDX in non-default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "delete cf: mapD.mapDX in non-default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "delete cf: mapD.mapDX in non-default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListMcf.get(++idxInBucket), ++getCount, "insert cf: mapD.mapDX in non-default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListScf.get(idxInBucket), getCount, "insert cf: mapD.mapDX in non-default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListMcf.get(++idxInBucket), ++getCount, "replace cf: mapD.mapDX in non-default CF", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.ReplaceMap, getListScf.get(idxInBucket), getCount, "replace cf: mapD.mapDX in non-default CF", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyCFMap, PutMethod.InsertMap, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        System.out.println("passed verify bucket map mutation");
        strRowId = ROWID_PREFIX + aryOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.ReplaceArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleArray, PutMethod.InsertArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        System.out.println("passed verify bucket array mutation");
        strRowId = ROWID_PREFIX + mfOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyFieldDelete, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifySimpleField, PutMethod.InsertField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        System.out.println("passed verify map field mutation");
        System.out.println("---arrayfield numbation starts at " + ++getCount);
        strRowId = ROWID_PREFIX + afOpId;
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL1, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL1, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL2, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL2, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL3, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL3, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL4, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL4, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL5, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL5, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL6, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL6, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL7, PutMethod.ReplaceArray, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldL7, PutMethod.ReplaceArray, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM1, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM1, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM2, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM2, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM3, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM3, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM4, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM4, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM5, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM5, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM6, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldM6, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN1, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN1, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN2, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN2, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN3, PutMethod.ReplaceField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN3, PutMethod.ReplaceField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN4, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN4, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN5, PutMethod.DeleteField, getListMcf.get(++idxInBucket), ++getCount, "", isDebug, isMcf, presetValuesMcf, presetFieldNamesMcf);
        TestCDPSJSONWithCluster.processOneNode(strRowId, VerifyMethod.VerifyArrayInArrayFieldN5, PutMethod.DeleteField, getListScf.get(idxInBucket), getCount, "", isDebug, isScf, presetValuesScf, presetFieldNamesScf);
        ++idxInBucket;
        ++getCount;
    }

    private static enum PutMethod {
        InsertMap,
        ReplaceMap,
        InsertArray,
        ReplaceArray,
        InsertField,
        ReplaceField,
        DeleteField;

    }

    private static enum VerifyMethod {
        VerifySimpleMap,
        VerifyReplaceRowMap,
        VerifyCFMap,
        VerifyRowDelete,
        VerifyFieldDelete,
        VerifySimpleArray,
        VerifySimpleField,
        VerifyArrayInArrayFieldL1,
        VerifyArrayInArrayFieldL2,
        VerifyArrayInArrayFieldL3,
        VerifyArrayInArrayFieldL4,
        VerifyArrayInArrayFieldL5,
        VerifyArrayInArrayFieldL6,
        VerifyArrayInArrayFieldL7,
        VerifyArrayInArrayFieldM1,
        VerifyArrayInArrayFieldM2,
        VerifyArrayInArrayFieldM3,
        VerifyArrayInArrayFieldM4,
        VerifyArrayInArrayFieldM5,
        VerifyArrayInArrayFieldM6,
        VerifyArrayInArrayFieldN1,
        VerifyArrayInArrayFieldN2,
        VerifyArrayInArrayFieldN3,
        VerifyArrayInArrayFieldN4,
        VerifyArrayInArrayFieldN5;

    }
}

