/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import java.io.InputStream;
import org.junit.Assert;

public class BaseTestClient {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String TEST_OJAI_URL_HOST = "TEST_OJAI_URL_HOST";
    protected static final String TEST_OJAI_BASE_CONN_STR;

    protected static String getString(String propName, String defaultVal) {
        String value = System.getProperty(propName, System.getenv(propName));
        return value == null ? defaultVal : value;
    }

    protected static long getLong(String propName, long defaultVal) {
        return Long.parseLong(BaseTestClient.getString(propName, String.valueOf(defaultVal)));
    }

    protected static InputStream getJsonStream(String resourceName) {
        return BaseTestClient.class.getClassLoader().getResourceAsStream(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expectException(Class<? extends Throwable> expectedException, OperationWithException function) {
        boolean exception = true;
        try {
            function.apply();
            exception = false;
        }
        catch (Throwable t) {
            if (!t.getClass().isAssignableFrom(expectedException)) {
                t.printStackTrace();
                Assert.fail((String)("An unexpected exception " + t.getClass().getTypeName() + " was thrown."));
            }
        }
        finally {
            if (!exception) {
                Assert.fail((String)("Expected the test to throw: " + expectedException.getTypeName()));
            }
        }
    }

    static {
        String hostname = BaseTestClient.getString(TEST_OJAI_URL_HOST, DEFAULT_HOSTNAME);
        long port = BaseTestClient.getLong(TEST_OJAI_URL_HOST, 5678L);
        TEST_OJAI_BASE_CONN_STR = new StringBuffer().append("ojai:mapr:thin:@").append(hostname).append(":").append(port).toString();
    }

    @FunctionalInterface
    public static interface OperationWithException {
        public void apply();
    }
}

