/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.google.common.base.Preconditions;
import com.mapr.db.ojai.BaseTestClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.IllegalMutationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientOperations
extends BaseTestClient {
    private static final Logger log = LoggerFactory.getLogger(TestClientOperations.class);
    private static final String HOURS_MAP_FIELD = "hours";
    private static final String NEW_FIELD = "new_field";
    private static final String NEW_BINARY_FIELD = "new_binary_field";
    private static final String ID_vcNA_ = "vcNAWiLM4dR7D2nwwJ7nCA";

    @Test
    public void testClientOperationsWithSSL() throws IOException {
        this.testClientOperations(TEST_OJAI_BASE_CONN_STR + "?ssl=true;user=mapr;password=mapr");
    }

    @Test
    public void testClientSSLConnectionWithoutSSL() throws IOException {
        this.testClientOperations(TEST_OJAI_BASE_CONN_STR + "?ssl=false;user=root;password=mapr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testClientOperations(String sslConnStr) throws IOException {
        String storeName = "/tmp/TestClient_testClient_business";
        Connection conn = DriverManager.getConnection((String)sslConnStr);
        conn.deleteStore("/tmp/TestClient_testClient_business");
        log.debug("test storeExists()");
        Assert.assertFalse((boolean)conn.storeExists("/tmp/TestClient_testClient_business"));
        log.debug("test createStore()");
        DocumentStore store = conn.createStore("/tmp/TestClient_testClient_business");
        Assert.assertTrue((boolean)conn.storeExists("/tmp/TestClient_testClient_business"));
        log.debug("test insertOrReplace()");
        try (InputStream in = TestClientOperations.getJsonStream("org/ojai/test/data/business.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)((InputStream)Preconditions.checkNotNull((Object)in)));){
            for (Document document : stream) {
                store.insertOrReplace(document.getString("business_id"), document);
            }
            log.debug("test findById()");
            Document doc1 = store.findById(ID_vcNA_);
            Assert.assertNotNull((Object)doc1);
            log.info(doc1.asJsonString());
            Assert.assertNull((Object)doc1.getValue(NEW_FIELD));
            Assert.assertEquals((long)16L, (long)doc1.size());
            log.debug("test replace()");
            store.replace(ID_vcNA_, doc1);
            log.debug("test replace() failed");
            this.expectException(DocumentNotFoundException.class, () -> store.replace("id_does_not_exist", doc1));
            log.debug("test insert()");
            store.insert("vcNAWiLM4dR7D2nwwJ7nCA_new", doc1);
            log.debug("test insert() failed");
            this.expectException(DocumentExistsException.class, () -> store.insert(ID_vcNA_, doc1));
            log.debug("test find()");
            int docCount = 0;
            try (DocumentStream results = store.find();){
                for (Object document : results) {
                    ++docCount;
                    log.debug(document.asJsonString());
                }
            }
            Assert.assertEquals((long)6L, (long)docCount);
            log.debug("test find() with condition");
            docCount = 0;
            Query query1 = conn.newQuery().where(conn.newCondition().is("stars", QueryCondition.Op.GREATER, 4).build()).build();
            try (QueryResult results = store.find(query1);){
                for (Document document : results) {
                    ++docCount;
                    log.debug(document.asJsonString());
                }
            }
            Assert.assertEquals((long)1L, (long)docCount);
            log.debug("test findById() with projection");
            Document docWithProjection = store.findById(ID_vcNA_, new String[]{"name", "city", "categories"});
            log.info(docWithProjection.asJsonString());
            Assert.assertEquals((long)3L, (long)docWithProjection.size());
            log.debug("test findById() with condition");
            QueryCondition condition = conn.newCondition().is("stars", QueryCondition.Op.GREATER_OR_EQUAL, 3.5).build();
            Document doc2 = store.findById(ID_vcNA_, condition, new String[]{"name", "city", "categories"});
            log.info(doc2.asJsonString());
            Assert.assertEquals((long)3L, (long)doc2.size());
            log.debug("test findById() with false condition");
            QueryCondition falseCondition = conn.newCondition().is("stars", QueryCondition.Op.GREATER, 3.5).build();
            Document docNull = store.findById(ID_vcNA_, falseCondition, new String[]{"name", "city", "categories"});
            Assert.assertNull((Object)docNull);
            log.debug("test update()");
            DocumentMutation mutation1 = conn.newMutation();
            mutation1.set(NEW_FIELD, 25);
            mutation1.set(NEW_BINARY_FIELD, ByteBuffer.wrap("abc".getBytes()));
            store.update(ID_vcNA_, mutation1);
            Document doc3 = store.findById(ID_vcNA_);
            log.info(doc3.asJsonString());
            Assert.assertNotNull((Object)doc3.getValue(NEW_FIELD));
            Assert.assertEquals((long)25L, (long)doc3.getInt(NEW_FIELD));
            log.debug("test increment()");
            store.increment(ID_vcNA_, NEW_FIELD, 10);
            Document doc4 = store.findById(ID_vcNA_);
            log.info(doc4.asJsonString());
            Assert.assertNotNull((Object)doc4.getValue(NEW_FIELD));
            Assert.assertEquals((long)35L, (long)doc4.getInt(NEW_FIELD));
            log.debug("test conditional update() - negative");
            DocumentMutation mutation2 = conn.newMutation();
            mutation2.set(NEW_FIELD, 50);
            QueryCondition condition1 = conn.newCondition().is(NEW_FIELD, QueryCondition.Op.EQUAL, 25).build();
            Assert.assertFalse((boolean)store.checkAndUpdate(ID_vcNA_, condition1, mutation2));
            Document doc5 = store.findById(ID_vcNA_);
            log.info(doc5.asJsonString());
            Assert.assertNotNull((Object)doc5.getValue(NEW_FIELD));
            Assert.assertEquals((long)35L, (long)doc5.getInt(NEW_FIELD));
            log.debug("test conditional update() - positive");
            DocumentMutation mutation3 = conn.newMutation();
            mutation3.set(NEW_FIELD, 50);
            QueryCondition condition2 = conn.newCondition().and().is(NEW_FIELD, QueryCondition.Op.EQUAL, 35).or().is("stars", QueryCondition.Op.GREATER, 2).is("state", QueryCondition.Op.EQUAL, "CA").close().is("type", QueryCondition.Op.EQUAL, "business").close().build();
            Assert.assertTrue((boolean)store.checkAndUpdate(ID_vcNA_, condition2, mutation3));
            Document doc6 = store.findById(ID_vcNA_);
            log.info(doc6.asJsonString());
            Assert.assertNotNull((Object)doc6.getValue(NEW_FIELD));
            Assert.assertEquals((long)50L, (long)doc6.getInt(NEW_FIELD));
            log.debug("test illegal update()");
            DocumentMutation mutation4 = conn.newMutation();
            mutation4.set(HOURS_MAP_FIELD, "scalar_value");
            this.expectException(IllegalMutationException.class, () -> store.update(ID_vcNA_, mutation4));
            log.debug("test invalid increment()");
            this.expectException(IllegalMutationException.class, () -> store.increment(ID_vcNA_, HOURS_MAP_FIELD, 100));
            log.debug("test delete()");
            store.delete(ID_vcNA_);
            Assert.assertNull((Object)store.findById(ID_vcNA_));
            try (DocumentStream results = store.find();){
                docCount = 0;
                for (Document document : results) {
                    ++docCount;
                    log.debug(document.asJsonString());
                }
                Assert.assertEquals((long)5L, (long)docCount);
            }
        }
        finally {
            conn.deleteStore("/tmp/TestClient_testClient_business");
            conn.close();
        }
    }
}

