/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mapr.db.ojai.impl.ThinDriver;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;
import org.ojai.store.MutationOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class DocumentMutationImpl
implements DocumentMutation {
    Map<OpType, Map<String, Object>> mutateVals = new HashMap<OpType, Map<String, Object>>();

    DocumentMutationImpl() {
    }

    public Iterator<MutationOp> iterator() {
        throw new UnsupportedOperationException("");
    }

    public DocumentMutation empty() {
        this.mutateVals.clear();
        return this;
    }

    private DocumentMutation addObject(OpType op, String path, Object value) {
        Map<String, Object> map = this.mutateVals.get((Object)op);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.mutateVals.put(op, map);
        }
        map.put(path, value);
        return this;
    }

    public DocumentMutation setNull(String path) {
        return this.addObject(OpType.SET, path, null);
    }

    public DocumentMutation setNull(FieldPath path) {
        return this.setNull(path.asPathString());
    }

    public DocumentMutation set(String path, Value value) {
        return this.addObject(OpType.SET, path, value);
    }

    public DocumentMutation set(FieldPath path, Value value) {
        return this.set(path.asPathString(), value);
    }

    public DocumentMutation set(String path, boolean b) {
        return this.addObject(OpType.SET, path, b);
    }

    public DocumentMutation set(FieldPath path, boolean b) {
        return this.set(path.asPathString(), b);
    }

    public DocumentMutation set(String path, byte b) {
        return this.addObject(OpType.SET, path, b);
    }

    public DocumentMutation set(FieldPath path, byte b) {
        return this.set(path.asPathString(), b);
    }

    public DocumentMutation set(String path, short s) {
        return this.addObject(OpType.SET, path, s);
    }

    public DocumentMutation set(FieldPath path, short s) {
        return this.set(path.asPathString(), s);
    }

    public DocumentMutation set(String path, int i) {
        return this.addObject(OpType.SET, path, i);
    }

    public DocumentMutation set(FieldPath path, int i) {
        return this.set(path.asPathString(), i);
    }

    public DocumentMutation set(String path, long l) {
        return this.addObject(OpType.SET, path, l);
    }

    public DocumentMutation set(FieldPath path, long l) {
        return this.set(path.asPathString(), l);
    }

    public DocumentMutation set(String path, float f) {
        return this.addObject(OpType.SET, path, Float.valueOf(f));
    }

    public DocumentMutation set(FieldPath path, float f) {
        return this.set(path.asPathString(), f);
    }

    public DocumentMutation set(String path, double d) {
        return this.addObject(OpType.SET, path, d);
    }

    public DocumentMutation set(FieldPath path, double d) {
        return this.set(path.asPathString(), d);
    }

    public DocumentMutation set(String path, String value) {
        return this.addObject(OpType.SET, path, value);
    }

    public DocumentMutation set(FieldPath path, String value) {
        return this.set(path.asPathString(), value);
    }

    public DocumentMutation set(String path, BigDecimal bd) {
        return this.addObject(OpType.SET, path, bd);
    }

    public DocumentMutation set(FieldPath path, BigDecimal bd) {
        return this.set(path.asPathString(), bd);
    }

    public DocumentMutation set(String path, ODate d) {
        return this.addObject(OpType.SET, path, d);
    }

    public DocumentMutation set(FieldPath path, ODate d) {
        return this.set(path.asPathString(), d);
    }

    public DocumentMutation set(String path, OTime t) {
        return this.addObject(OpType.SET, path, t);
    }

    public DocumentMutation set(FieldPath path, OTime t) {
        return this.set(path.asPathString(), t);
    }

    public DocumentMutation set(String path, OTimestamp ts) {
        return this.addObject(OpType.SET, path, ts);
    }

    public DocumentMutation set(FieldPath path, OTimestamp ts) {
        return this.set(path.asPathString(), ts);
    }

    public DocumentMutation set(String path, OInterval intv) {
        return this.addObject(OpType.SET, path, intv);
    }

    public DocumentMutation set(FieldPath path, OInterval intv) {
        return this.set(path.asPathString(), intv);
    }

    public DocumentMutation set(String path, ByteBuffer bb) {
        return this.addObject(OpType.SET, path, bb);
    }

    public DocumentMutation set(FieldPath path, ByteBuffer bb) {
        return this.set(path.asPathString(), bb);
    }

    public DocumentMutation set(String path, List<? extends Object> list) {
        return this.addObject(OpType.SET, path, list);
    }

    public DocumentMutation set(FieldPath path, List<? extends Object> list) {
        return this.set(path.asPathString(), list);
    }

    public DocumentMutation set(String path, Map<String, ? extends Object> map) {
        return this.addObject(OpType.SET, path, map);
    }

    public DocumentMutation set(FieldPath path, Map<String, ? extends Object> map) {
        return this.set(path.asPathString(), map);
    }

    public DocumentMutation set(String path, Document doc) {
        return this.addObject(OpType.SET, path, doc);
    }

    public DocumentMutation set(FieldPath path, Document doc) {
        return this.set(path.asPathString(), doc);
    }

    public DocumentMutation setOrReplaceNull(String path) {
        return this.addObject(OpType.SETORREPLACE, path, null);
    }

    public DocumentMutation setOrReplaceNull(FieldPath path) {
        return this.setOrReplaceNull(path.asPathString());
    }

    public DocumentMutation setOrReplace(String path, Value value) {
        return this.addObject(OpType.SETORREPLACE, path, value);
    }

    public DocumentMutation setOrReplace(FieldPath path, Value value) {
        return this.setOrReplace(path.asPathString(), value);
    }

    public DocumentMutation setOrReplace(String path, boolean b) {
        return this.addObject(OpType.SETORREPLACE, path, b);
    }

    public DocumentMutation setOrReplace(FieldPath path, boolean b) {
        return this.setOrReplace(path.asPathString(), b);
    }

    public DocumentMutation setOrReplace(String path, byte b) {
        return this.addObject(OpType.SETORREPLACE, path, b);
    }

    public DocumentMutation setOrReplace(FieldPath path, byte b) {
        return this.setOrReplace(path.asPathString(), b);
    }

    public DocumentMutation setOrReplace(String path, short s) {
        return this.addObject(OpType.SETORREPLACE, path, s);
    }

    public DocumentMutation setOrReplace(FieldPath path, short s) {
        return this.setOrReplace(path.asPathString(), s);
    }

    public DocumentMutation setOrReplace(String path, int i) {
        return this.addObject(OpType.SETORREPLACE, path, i);
    }

    public DocumentMutation setOrReplace(FieldPath path, int i) {
        return this.setOrReplace(path.asPathString(), i);
    }

    public DocumentMutation setOrReplace(String path, long l) {
        return this.addObject(OpType.SETORREPLACE, path, l);
    }

    public DocumentMutation setOrReplace(FieldPath path, long l) {
        return this.setOrReplace(path.asPathString(), l);
    }

    public DocumentMutation setOrReplace(String path, float f) {
        return this.addObject(OpType.SETORREPLACE, path, Float.valueOf(f));
    }

    public DocumentMutation setOrReplace(FieldPath path, float f) {
        return this.setOrReplace(path.asPathString(), f);
    }

    public DocumentMutation setOrReplace(String path, double d) {
        return this.addObject(OpType.SETORREPLACE, path, d);
    }

    public DocumentMutation setOrReplace(FieldPath path, double d) {
        return this.setOrReplace(path.asPathString(), d);
    }

    public DocumentMutation setOrReplace(String path, String string) {
        return this.addObject(OpType.SETORREPLACE, path, string);
    }

    public DocumentMutation setOrReplace(FieldPath path, String string) {
        return this.setOrReplace(path.asPathString(), string);
    }

    public DocumentMutation setOrReplace(String path, BigDecimal bd) {
        return this.addObject(OpType.SETORREPLACE, path, bd);
    }

    public DocumentMutation setOrReplace(FieldPath path, BigDecimal bd) {
        return this.setOrReplace(path.asPathString(), bd);
    }

    public DocumentMutation setOrReplace(String path, ODate d) {
        return this.addObject(OpType.SETORREPLACE, path, d);
    }

    public DocumentMutation setOrReplace(FieldPath path, ODate d) {
        return this.setOrReplace(path.asPathString(), d);
    }

    public DocumentMutation setOrReplace(String path, OTime t) {
        return this.addObject(OpType.SETORREPLACE, path, t);
    }

    public DocumentMutation setOrReplace(FieldPath path, OTime t) {
        return this.setOrReplace(path.asPathString(), t);
    }

    public DocumentMutation setOrReplace(String path, OTimestamp ts) {
        return this.addObject(OpType.SETORREPLACE, path, ts);
    }

    public DocumentMutation setOrReplace(FieldPath path, OTimestamp ts) {
        return this.setOrReplace(path.asPathString(), ts);
    }

    public DocumentMutation setOrReplace(String path, OInterval intv) {
        return this.addObject(OpType.SETORREPLACE, path, intv);
    }

    public DocumentMutation setOrReplace(FieldPath path, OInterval intv) {
        return this.setOrReplace(path.asPathString(), intv);
    }

    public DocumentMutation setOrReplace(String path, ByteBuffer bb) {
        return this.addObject(OpType.SETORREPLACE, path, bb);
    }

    public DocumentMutation setOrReplace(FieldPath path, ByteBuffer bb) {
        return this.setOrReplace(path.asPathString(), bb);
    }

    public DocumentMutation setOrReplace(String path, List<? extends Object> list) {
        return this.addObject(OpType.SETORREPLACE, path, list);
    }

    public DocumentMutation setOrReplace(FieldPath path, List<? extends Object> list) {
        return this.setOrReplace(path.asPathString(), list);
    }

    public DocumentMutation setOrReplace(String path, Map<String, ? extends Object> map) {
        return this.addObject(OpType.SETORREPLACE, path, map);
    }

    public DocumentMutation setOrReplace(FieldPath path, Map<String, ? extends Object> map) {
        return this.setOrReplace(path.asPathString(), map);
    }

    public DocumentMutation setOrReplace(String path, Document doc) {
        return this.addObject(OpType.SETORREPLACE, path, doc);
    }

    public DocumentMutation setOrReplace(FieldPath path, Document doc) {
        return this.setOrReplace(path.asPathString(), doc);
    }

    public DocumentMutation append(String path, List<? extends Object> list) {
        return this.addObject(OpType.APPEND, path, list);
    }

    public DocumentMutation append(FieldPath path, List<? extends Object> list) {
        return this.append(path.asPathString(), list);
    }

    public DocumentMutation append(String path, String string) {
        return this.addObject(OpType.APPEND, path, string);
    }

    public DocumentMutation append(FieldPath path, String string) {
        return this.append(path.asPathString(), string);
    }

    public DocumentMutation append(String path, byte[] value, int offset, int len) {
        throw new UnsupportedOperationException("Not supported");
    }

    public DocumentMutation append(FieldPath path, byte[] value, int offset, int len) {
        return this.append(path.asPathString(), value, offset, len);
    }

    public DocumentMutation append(String path, byte[] value) {
        return this.addObject(OpType.APPEND, path, value);
    }

    public DocumentMutation append(FieldPath path, byte[] value) {
        return this.append(path.asPathString(), value);
    }

    public DocumentMutation append(String path, ByteBuffer value) {
        return this.addObject(OpType.APPEND, path, value);
    }

    public DocumentMutation append(FieldPath path, ByteBuffer value) {
        return this.append(path.asPathString(), value);
    }

    public DocumentMutation merge(String path, Document doc) {
        return this.addObject(OpType.MERGE, path, doc);
    }

    public DocumentMutation merge(FieldPath path, Document doc) {
        return this.merge(path.asPathString(), doc);
    }

    public DocumentMutation merge(String path, Map<String, Object> map) {
        return this.addObject(OpType.MERGE, path, map);
    }

    public DocumentMutation merge(FieldPath path, Map<String, Object> map) {
        return this.merge(path.asPathString(), map);
    }

    public DocumentMutation increment(FieldPath path, byte inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(String path, byte inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(FieldPath path, short inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(String path, short inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(String path, int inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(FieldPath path, int inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(FieldPath path, long inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(String path, long inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(String path, float inc) {
        return this.addObject(OpType.INCREMENT, path, Float.valueOf(inc));
    }

    public DocumentMutation increment(FieldPath path, float inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(String path, double inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(FieldPath path, double inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation increment(String path, BigDecimal inc) {
        return this.addObject(OpType.INCREMENT, path, inc);
    }

    public DocumentMutation increment(FieldPath path, BigDecimal inc) {
        return this.increment(path.asPathString(), inc);
    }

    public DocumentMutation decrement(FieldPath path, byte dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(String path, byte dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(FieldPath path, short dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(String path, short dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(String path, int dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(FieldPath path, int dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(FieldPath path, long dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(String path, long dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(String path, float dec) {
        return this.addObject(OpType.DECREMENT, path, Float.valueOf(dec));
    }

    public DocumentMutation decrement(FieldPath path, float dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(String path, double dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(FieldPath path, double dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation decrement(String path, BigDecimal dec) {
        return this.addObject(OpType.DECREMENT, path, dec);
    }

    public DocumentMutation decrement(FieldPath path, BigDecimal dec) {
        return this.decrement(path.asPathString(), dec);
    }

    public DocumentMutation delete(String path) {
        return this.addObject(OpType.DELETE, path, path);
    }

    public DocumentMutation delete(FieldPath path) {
        return this.delete(path.asPathString());
    }

    public String asJsonString() {
        String json = null;
        ObjectMapper mapper = ThinDriver.getMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        try {
            block11: for (Map.Entry<OpType, Map<String, Object>> entry : this.mutateVals.entrySet()) {
                ArrayNode opNode = mapper.createArrayNode();
                Map<String, Object> values = entry.getValue();
                this.addObjectsToNode(opNode, values);
                switch (entry.getKey()) {
                    case APPEND: {
                        rootNode.set("$append", (JsonNode)opNode);
                        continue block11;
                    }
                    case DECREMENT: {
                        rootNode.set("$decrement", (JsonNode)opNode);
                        continue block11;
                    }
                    case DELETE: {
                        opNode.removeAll();
                        for (Object fld : values.values()) {
                            opNode.add((String)fld);
                        }
                        rootNode.set("$delete", (JsonNode)opNode);
                        continue block11;
                    }
                    case INCREMENT: {
                        rootNode.set("$increment", (JsonNode)opNode);
                        continue block11;
                    }
                    case MERGE: {
                        rootNode.set("$merge", (JsonNode)opNode);
                        continue block11;
                    }
                    case SET: {
                        rootNode.set("$set", (JsonNode)opNode);
                        continue block11;
                    }
                    case SETORREPLACE: {
                        rootNode.set("$put", (JsonNode)opNode);
                        continue block11;
                    }
                }
                throw new IllegalStateException("Not a known mutation type");
            }
            json = mapper.writeValueAsString((Object)rootNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    private void addObjectsToNode(ArrayNode opNode, Map<String, Object> values) {
        ObjectMapper mapper = ThinDriver.getMapper();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            ObjectNode node = mapper.createObjectNode();
            String path = entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                node.putNull(path);
            } else if (v instanceof String) {
                node.put(path, (String)v);
            } else if (v instanceof Integer) {
                node.put(path, ((Integer)v).intValue());
            } else if (v instanceof Short) {
                node.put(path, ((Short)v).shortValue());
            } else if (v instanceof Double) {
                node.put(path, ((Double)v).doubleValue());
            } else if (v instanceof Float) {
                node.put(path, ((Float)v).floatValue());
            } else if (v instanceof Long) {
                node.put(path, ((Long)v).longValue());
            } else if (v instanceof Byte) {
                node.put(path, (short)((Byte)v).byteValue());
            } else if (v instanceof Boolean) {
                node.put(path, ((Boolean)v).booleanValue());
            } else if (v instanceof BigDecimal) {
                node.put(path, (BigDecimal)v);
            } else if (v instanceof Map) {
                node.set(path, mapper.valueToTree(v));
            } else if (v instanceof List) {
                node.set(path, mapper.valueToTree(v));
            } else if (v instanceof ODate) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$dateDay", ((ODate)v).toDateStr()));
            } else if (v instanceof OTime) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$time", ((OTime)v).toTimeStr()));
            } else if (v instanceof OTimestamp) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$date", ((OTimestamp)v).toString()));
            } else if (v instanceof OInterval) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$interval", ((OInterval)v).toString()));
            } else if (v instanceof ByteBuffer) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$binary", Base64.getEncoder().encodeToString(((ByteBuffer)v).array())));
            } else if (v instanceof byte[]) {
                node.set(path, (JsonNode)mapper.createObjectNode().put("$binary", Base64.getEncoder().encodeToString((byte[])v)));
            } else {
                throw new IllegalStateException("Not a known type");
            }
            opNode.add((JsonNode)node);
        }
    }

    public String toString() {
        return Json.newDocument(this.mutateVals).asJsonString();
    }

    static enum OpType {
        SET,
        SETORREPLACE,
        INCREMENT,
        DECREMENT,
        MERGE,
        APPEND,
        DELETE;

    }
}

