/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.google.common.io.BaseEncoding;
import com.mapr.data.ProtoConstants;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthInterceptor.class);
    private static final BaseEncoding BASE64_CODEC = BaseEncoding.base64();
    private String basicAuthHeader;
    private String jwtAuthHeader;

    public ClientAuthInterceptor(String user, String password) {
        String basicAuth = user + ":";
        if (password != null) {
            basicAuth = basicAuth + password;
        }
        this.basicAuthHeader = this.getAuthHeader("basic", BASE64_CODEC.encode(basicAuth.getBytes()));
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (ClientAuthInterceptor.this.jwtAuthHeader != null) {
                    headers.put(ProtoConstants.REQ_HEADER_AUTH, (Object)ClientAuthInterceptor.this.jwtAuthHeader);
                } else if (ClientAuthInterceptor.this.basicAuthHeader != null) {
                    headers.put(ProtoConstants.REQ_HEADER_AUTH, (Object)ClientAuthInterceptor.this.basicAuthHeader);
                }
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        String jwtToken = (String)headers.get(ProtoConstants.RSP_HEADER_JWT_TOKEN);
                        if (jwtToken != null) {
                            ClientAuthInterceptor.this.jwtAuthHeader = ClientAuthInterceptor.this.getAuthHeader("bearer", jwtToken);
                        }
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        if (!status.isOk()) {
                            switch (status.getCode()) {
                                case UNAUTHENTICATED: {
                                    if (!"STATUS_TOKEN_EXPIRED".equalsIgnoreCase(status.getDescription())) break;
                                    log.error("Authentication token expired!");
                                    break;
                                }
                            }
                        }
                        super.onClose(status, trailers);
                    }
                }, headers);
            }
        };
    }

    private String getAuthHeader(String authScheme, String authToken) {
        return authScheme + " " + authToken;
    }
}

