/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBValueBuilder;
import com.mapr.db.ojai.impl.ConnectionImpl;
import com.mapr.db.ojai.impl.DocumentMutationImpl;
import com.mapr.db.ojai.impl.QueryConditionImpl;
import com.mapr.db.ojai.impl.QueryImpl;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinDriver
implements Driver {
    private static final Logger logger = LoggerFactory.getLogger(ThinDriver.class);
    private static final Driver DRIVER_INSTANCE = new ThinDriver();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Document newDocument() {
        return MapRDBImpl.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return MapRDBImpl.newDocument((String)documentJson);
    }

    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return MapRDBImpl.newDocument(map);
    }

    public Document newDocument(Object bean) throws DecodingException {
        return MapRDBImpl.newDocument((Object)bean);
    }

    public DocumentBuilder newDocumentBuilder() {
        return MapRDBImpl.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return new DocumentMutationImpl();
    }

    public QueryCondition newCondition() {
        return new QueryConditionImpl();
    }

    public ValueBuilder getValueBuilder() {
        return DBValueBuilder.INSTANCE;
    }

    public boolean accepts(String url) {
        return url.startsWith("ojai:mapr:thin:@");
    }

    public Connection connect(String url, Document options) throws OjaiException {
        Preconditions.checkArgument((boolean)this.accepts(url), (String)"Invalid OJAI URL! URL must start with %s.", (Object)"ojai:mapr:thin:@");
        String connectionParams = url.substring(url.indexOf(64) + 1);
        return new ConnectionImpl(this, connectionParams, options);
    }

    public String getName() {
        return "MapR OJAI Thin Driver";
    }

    public String toString() {
        return this.getName();
    }

    public Query newQuery() {
        return new QueryImpl();
    }

    public Query newQuery(String queryJson) {
        throw new UnsupportedOperationException();
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    static {
        DriverManager.registerDriver((Driver)DRIVER_INSTANCE);
    }
}

