/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.google.common.base.Preconditions;
import com.mapr.data.db.proto.RpcError;
import com.mapr.db.ojai.impl.RemoteStoreException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.IllegalMutationException;
import org.ojai.store.exceptions.StoreExistsException;
import org.ojai.store.exceptions.StoreNotFoundException;

public final class RpcErrorHandler {
    private static final String CAUSED_BY = "Caused by: ";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s+at\\s+([\\w\\.$_]+)\\.([\\w$_]+)\\((.*java)?:(\\d+)\\)");

    public static OjaiException handleRpcError(RpcError rpcError) {
        StoreNotFoundException ojaiException;
        switch (rpcError.getErrCode()) {
            case TABLE_NOT_FOUND: {
                ojaiException = new StoreNotFoundException(rpcError.getErrorMessage());
                break;
            }
            case TABLE_ALREADY_EXISTS: {
                ojaiException = new StoreExistsException(rpcError.getErrorMessage());
                break;
            }
            case DOCUMENT_NOT_FOUND: {
                ojaiException = new DocumentNotFoundException(rpcError.getErrorMessage());
                break;
            }
            case DOCUMENT_ALREADY_EXISTS: {
                ojaiException = new DocumentExistsException(rpcError.getErrorMessage());
                break;
            }
            case ILLEGAL_MUTATION: {
                ojaiException = new IllegalMutationException(rpcError.getErrorMessage());
                break;
            }
            case DECODING_ERROR: {
                ojaiException = new DecodingException(rpcError.getErrorMessage());
                break;
            }
            case ENCODING_ERROR: {
                ojaiException = new EncodingException(rpcError.getErrorMessage());
                break;
            }
            default: {
                ojaiException = new OjaiException(rpcError.getErrorMessage());
            }
        }
        return RpcErrorHandler.createRemoteStoreException((OjaiException)ojaiException, rpcError);
    }

    private static OjaiException createRemoteStoreException(OjaiException ojaiException, RpcError rpcError) {
        String javaStackTrace = rpcError.getJavaStackTrace();
        String[] stackTraceLines = javaStackTrace.split("\\v+");
        StackLinesIterator stackTraceItr = new StackLinesIterator(stackTraceLines);
        Object parentException = ojaiException;
        while (stackTraceItr.hasNext()) {
            RemoteStoreException cause = RpcErrorHandler.newRemoteStoreException(stackTraceItr);
            if (cause == null) continue;
            parentException.initCause((Throwable)((Object)cause));
            parentException = cause;
        }
        return ojaiException;
    }

    private static RemoteStoreException newRemoteStoreException(StackLinesIterator stackLinesItr) {
        Preconditions.checkState((boolean)stackLinesItr.hasNext());
        String msgLine = stackLinesItr.next().trim();
        if (msgLine.startsWith(CAUSED_BY)) {
            msgLine = msgLine.substring(CAUSED_BY.length());
        }
        String[] exceptionClassAndMsg = msgLine.split(":", 2);
        String exceptionMsg = "[" + exceptionClassAndMsg[0].trim() + ": " + exceptionClassAndMsg[1].trim() + "]";
        RemoteStoreException remoteException = new RemoteStoreException(exceptionMsg);
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        while (stackLinesItr.hasNext()) {
            String nextLine = stackLinesItr.next();
            Matcher stackTraceMatcher = STACK_TRACE_PATTERN.matcher(nextLine);
            if (stackTraceMatcher.matches()) {
                String declaringClass = stackTraceMatcher.group(1);
                String methodName = stackTraceMatcher.group(2);
                String fileName = stackTraceMatcher.group(3);
                int lineNumber = Integer.parseInt(stackTraceMatcher.group(4));
                stackTrace.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
                continue;
            }
            if (nextLine.trim().startsWith("...")) break;
            stackLinesItr.moveBack();
            break;
        }
        remoteException.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return remoteException;
    }

    private static class StackLinesIterator
    implements Iterator<String> {
        private final String[] lines;
        private int curIdx = 0;

        private StackLinesIterator(String[] lines) {
            Preconditions.checkNotNull((Object)lines);
            this.lines = lines;
        }

        @Override
        public boolean hasNext() {
            return this.curIdx < this.lines.length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.lines[this.curIdx++];
        }

        public void moveBack() {
            if (this.curIdx == 0) {
                throw new NoSuchElementException();
            }
            --this.curIdx;
        }
    }
}

