/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.mapr.db.ojai.impl.ThinDriver;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.util.Fields;

public class QueryImpl
implements Query {
    static Query EMPTY_QUERY = new QueryImpl().build();
    private boolean built = false;
    private final HashSet<FieldPath> selectFields = new HashSet();
    private QueryCondition queryCondition = null;
    private List<Pair<FieldPath, SortOrder>> sortKeys = null;
    private long limit = -1L;
    private long offset = -1L;
    private String jsonString;

    QueryImpl() {
    }

    public Query setOption(String optionName, Object value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Object getOption(String optionName) {
        throw new UnsupportedOperationException();
    }

    public Query setOptions(Document options) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query setTimeout(long timeoutInMilliseconds) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query waitForTrackedWrites(String writesContext) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query select(String ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        return this.select(Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Query select(FieldPath ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        for (FieldPath fieldPath : fieldPaths) {
            this.selectFields.add(fieldPath);
        }
        return this;
    }

    public Query where(String conditionJson) throws OjaiException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query where(QueryCondition condition) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        if (!condition.isEmpty()) {
            this.queryCondition = condition;
        }
        return this;
    }

    public Query orderBy(String ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        return this.orderBy(Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Query orderBy(FieldPath ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        for (FieldPath fieldPath : fieldPaths) {
            this.orderBy(fieldPath, SortOrder.ASC);
        }
        return this;
    }

    public Query orderBy(String field, String order) throws IllegalArgumentException {
        this.checkNotBuilt();
        return this.orderBy(FieldPath.parseFrom((String)field), SortOrder.valueOf((String)order));
    }

    public Query orderBy(String field, SortOrder order) throws IllegalArgumentException {
        this.checkNotBuilt();
        return this.orderBy(FieldPath.parseFrom((String)field), order);
    }

    public Query orderBy(FieldPath field, SortOrder order) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"fieldPath must be non-null");
        Preconditions.checkArgument((order != null ? 1 : 0) != 0, (Object)"sortOrder must be non-null");
        if (this.sortKeys == null) {
            this.sortKeys = new LinkedList<Pair<FieldPath, SortOrder>>();
        }
        this.sortKeys.add((Pair<FieldPath, SortOrder>)new Pair((Object)field, (Object)order));
        return this;
    }

    public Query offset(long offset) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be non-negative");
        this.offset = offset;
        return this;
    }

    public Query limit(long limit) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be non-negative");
        this.limit = limit;
        return this;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public Query build() {
        this.checkNotBuilt();
        if (this.queryCondition != null && !this.queryCondition.isBuilt()) {
            this.queryCondition.build();
        }
        ObjectMapper mapper = ThinDriver.getMapper();
        ObjectNode queryNode = mapper.createObjectNode();
        try {
            ArrayNode arrayNode;
            if (this.selectFields.size() > 0) {
                arrayNode = mapper.createArrayNode();
                for (FieldPath fieldPath : this.selectFields) {
                    arrayNode.add(fieldPath.asPathString());
                }
                queryNode.set("$select", (JsonNode)arrayNode);
            }
            if (this.queryCondition != null) {
                JsonNode whereNode = null;
                whereNode = mapper.readTree(this.queryCondition.asJsonString());
                queryNode.set("$where", whereNode);
            }
            if (this.sortKeys != null) {
                arrayNode = mapper.createArrayNode();
                for (Pair pair : this.sortKeys) {
                    ObjectNode sortNode = mapper.createObjectNode();
                    sortNode.put(((FieldPath)pair.getFirst()).asPathString(), ((SortOrder)pair.getSecond()).toString());
                    arrayNode.add((JsonNode)sortNode);
                }
                queryNode.set("$orderby", (JsonNode)arrayNode);
            }
            if (this.limit != -1L) {
                queryNode.put("$limit", this.limit);
            }
            if (this.offset != -1L) {
                queryNode.put("$offset", this.offset);
            }
            this.jsonString = mapper.writeValueAsString((Object)queryNode);
            this.built = true;
            return this;
        }
        catch (IOException e) {
            throw new OjaiException((Throwable)e);
        }
    }

    public String asJsonString() {
        Preconditions.checkState((boolean)this.built, (Object)"Query is not built!");
        return this.jsonString;
    }

    private void checkNotBuilt() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The OJAI Query is already built!");
    }

    public String toString() {
        return this.jsonString;
    }
}

