/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.mapr.data.db.proto.FindResponse;
import com.mapr.data.db.proto.FindResponseType;
import com.mapr.db.ojai.impl.RpcErrorHandler;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.base.QueryResultBase;
import org.ojai.json.Json;
import org.ojai.store.Query;

public class GrpcQueryResult
extends QueryResultBase {
    private final Iterator<FindResponse> responses;
    private final Query query;
    private Document plan;
    private Document next = null;

    public GrpcQueryResult(Query query, Iterator<FindResponse> responses) {
        this.query = query;
        this.responses = responses;
        if (responses.hasNext()) {
            FindResponse response = responses.next();
            Document doc = this.parseResponse(response);
            if (response.getType() == FindResponseType.QUERY_PLAN) {
                this.plan = doc;
            } else {
                this.plan = super.getQueryPlan();
                this.next = doc;
            }
        }
    }

    private Document parseResponse(FindResponse response) {
        switch (response.getError().getErrCode()) {
            case NO_ERROR: {
                Document doc = Json.newDocument((String)response.getJsonResponse());
                return doc;
            }
        }
        throw RpcErrorHandler.handleRpcError(response.getError());
    }

    protected Iterator<Document> iteratorDerived() {
        return new FindResponseIterator();
    }

    public Document getQueryPlan() {
        return this.plan;
    }

    private class FindResponseIterator
    implements Iterator<Document> {
        private FindResponseIterator() {
        }

        @Override
        public boolean hasNext() {
            if (GrpcQueryResult.this.next == null && GrpcQueryResult.this.responses.hasNext()) {
                GrpcQueryResult.this.next = GrpcQueryResult.this.parseResponse((FindResponse)GrpcQueryResult.this.responses.next());
            }
            return GrpcQueryResult.this.next != null;
        }

        @Override
        public Document next() {
            if (this.hasNext()) {
                Document result = GrpcQueryResult.this.next;
                GrpcQueryResult.this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

