/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBValueBuilder;
import com.mapr.db.ojai.impl.SimulatedConnection;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;

public class SimulatedMapRDriver
implements Driver {
    private static final Driver DRIVER_INSTANCE = new SimulatedMapRDriver();

    public Document newDocument() {
        return MapRDBImpl.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return MapRDBImpl.newDocument((String)documentJson);
    }

    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return MapRDBImpl.newDocument(map);
    }

    public Document newDocument(Object bean) throws DecodingException {
        return MapRDBImpl.newDocument((Object)bean);
    }

    public DocumentBuilder newDocumentBuilder() {
        return MapRDBImpl.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return MapRDBImpl.newMutation();
    }

    public QueryCondition newCondition() {
        return MapRDBImpl.newCondition();
    }

    public ValueBuilder getValueBuilder() {
        return DBValueBuilder.INSTANCE;
    }

    public boolean accepts(String url) {
        return url.startsWith("ojai:mapr:simulated:@");
    }

    public Connection connect(String url, Document options) throws OjaiException {
        Preconditions.checkArgument((boolean)this.accepts(url), (String)"Invalid OJAI URL! URL must start with %s.", (Object)"ojai:mapr:simulated:@");
        return new SimulatedConnection(this, options);
    }

    public String getName() {
        return "Simulated MapRDB OJAI Driver";
    }

    public String toString() {
        return this.getName();
    }

    public Query newQuery() {
        throw new UnsupportedOperationException();
    }

    public Query newQuery(String queryJson) {
        throw new UnsupportedOperationException();
    }

    static {
        DriverManager.registerDriver((Driver)DRIVER_INSTANCE);
    }
}

