/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.mapr.db.ojai.impl.IdValueComparator;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentSkipListMap;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.ValueBuilder;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;

public class SimulatedDocumentStore
implements DocumentStore {
    private final ConcurrentSkipListMap<Value, Document> store = new ConcurrentSkipListMap(IdValueComparator.INSTANCE);
    private final Connection connection;
    private final ValueBuilder valueBuilder;

    public SimulatedDocumentStore(Connection connection, Document options) {
        this.connection = connection;
        this.valueBuilder = connection.getValueBuilder();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void flush() throws StoreException {
    }

    public void beginTrackingWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void beginTrackingWrites(String previousWritesContext) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public String endTrackingWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void clearTrackedWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id) throws StoreException {
        return this.findById(this.valueBuilder.newValue(_id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document findById(Value _id) throws StoreException {
        ConcurrentSkipListMap<Value, Document> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            return this.store.get(_id);
        }
    }

    public Document findById(String _id, String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id, FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(Value _id, String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(Value _id, FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id, QueryCondition condition) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(Value _id, QueryCondition condition) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(Value _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(Value _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public QueryResult find(Query query) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream findQuery(Query query) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream findQuery(String queryJSON) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find(String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find(FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find(QueryCondition condition) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find(QueryCondition condition, String ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public DocumentStream find(QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrReplace(Document doc) throws StoreException {
        ConcurrentSkipListMap<Value, Document> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Value id = doc.getId();
            if (this.store.containsKey(id)) {
                this.store.remove(id);
            }
            this.store.put(id, doc);
        }
    }

    public void insertOrReplace(String _id, Document r) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(Value _id, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(DocumentStream stream) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void update(String _id, DocumentMutation mutation) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void update(Value _id, DocumentMutation mutation) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(String _id) throws StoreException {
        this.delete(this.connection.newDocument().setId(_id));
    }

    public void delete(Value _id) throws StoreException {
        this.delete(this.connection.newDocument().setId(_id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Document doc) throws StoreException {
        ConcurrentSkipListMap<Value, Document> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Value id = doc.getId();
            if (this.store.containsKey(id)) {
                this.store.remove(id);
            }
        }
    }

    public void delete(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(DocumentStream stream) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void delete(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void delete(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insert(String _id, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insert(Value _id, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Document doc) throws StoreException {
        ConcurrentSkipListMap<Value, Document> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Value id = doc.getId();
            if (this.store.containsKey(id)) {
                throw new DocumentExistsException();
            }
            this.store.put(id, doc);
        }
    }

    public void insert(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insert(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insert(DocumentStream stream) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insert(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insert(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void replace(String _id, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void replace(Value _id, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Document doc) throws StoreException {
        ConcurrentSkipListMap<Value, Document> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Value id = doc.getId();
            if (!this.store.containsKey(id)) {
                throw new DocumentNotFoundException();
            }
            this.store.put(id, doc);
        }
    }

    public void replace(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void replace(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void replace(DocumentStream stream) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void replace(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void replace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, byte inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, short inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, int inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, long inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, float inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, double inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, BigDecimal inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, byte inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, short inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, int inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, long inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, float inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, double inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void increment(Value _id, String field, BigDecimal inc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndMutate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndMutate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndDelete(String _id, QueryCondition condition) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndDelete(Value _id, QueryCondition condition) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndReplace(String _id, QueryCondition condition, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndReplace(Value _id, QueryCondition condition, Document doc) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void close() throws StoreException {
        throw new UnsupportedOperationException();
    }
}

