/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.mapr.data.gateway.ojai.store.CloseableLoader;
import com.mapr.data.gateway.ojai.store.DocumentStoreHolder;
import com.mapr.data.gateway.ojai.store.UserAndThread;
import com.mapr.utils.Pair;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.ojai.store.Connection;

public class DocumentStoreLoader
extends CloseableLoader<Pair<UserAndThread, String>, DocumentStoreHolder> {
    private final Connection connection;

    public DocumentStoreLoader(Connection connection) {
        this.connection = connection;
    }

    public DocumentStoreHolder load(Pair<UserAndThread, String> pairKey) throws Exception {
        String userName = ((UserAndThread)((Object)pairKey.getFirst())).getUserName();
        if (userName == "") {
            return new DocumentStoreHolder(this.connection, (String)pairKey.getSecond());
        }
        return this.loadAsUser(userName, (String)pairKey.getSecond());
    }

    protected DocumentStoreHolder loadAsUser(String userName, final String storeName) throws Exception {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)currentUser);
        return (DocumentStoreHolder)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DocumentStoreHolder>(){

            @Override
            public DocumentStoreHolder run() throws Exception {
                return new DocumentStoreHolder(DocumentStoreLoader.this.connection, storeName);
            }
        });
    }
}

