/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.Constant;
import com.mapr.data.gateway.ojai.store.AdminHolder;
import com.mapr.data.gateway.ojai.store.AdminLoader;
import com.mapr.data.gateway.ojai.store.DocumentStoreHolder;
import com.mapr.data.gateway.ojai.store.DocumentStoreLoader;
import com.mapr.data.gateway.ojai.store.StoreManager;
import com.mapr.data.gateway.ojai.store.UserAndThread;
import com.mapr.db.Admin;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.utils.Pair;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.ojai.Document;
import org.ojai.annotation.API;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.exceptions.AuthenticationException;

public class CachingStoreManager
implements StoreManager {
    private final LoadingCache<Pair<UserAndThread, String>, DocumentStoreHolder> storeCache;
    private final DocumentStoreLoader storeLoader;
    private final LoadingCache<UserAndThread, AdminHolder> adminCache;
    private final AdminLoader adminLoader;
    private final boolean authRequired;
    private final long cacheExpirationMs;

    public CachingStoreManager(Document config, Connection connection) {
        this.authRequired = Configs.getBoolean(config, "grpc.service.auth.required", true);
        this.cacheExpirationMs = Configs.getLong(config, "grpc.service.store.cache.expiration.millis", 300000L);
        this.adminLoader = new AdminLoader();
        this.adminCache = CacheBuilder.newBuilder().expireAfterWrite(this.cacheExpirationMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)this.adminLoader).build((CacheLoader)this.adminLoader);
        this.storeLoader = new DocumentStoreLoader(connection);
        this.storeCache = CacheBuilder.newBuilder().expireAfterWrite(this.cacheExpirationMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)this.storeLoader).build((CacheLoader)this.storeLoader);
    }

    private String getUserName() {
        Authentication auth = (Authentication)Constant.AUTH_CTX_KEY.get();
        if (this.authRequired && (auth == null || auth.getUserName() == null)) {
            throw new AuthenticationException("No user information was provided. This server requires authentication.");
        }
        return this.authRequired ? auth.getUserName() : "";
    }

    @Override
    public DocumentStore getStore(@API.NonNullable String tablePath) {
        Preconditions.checkNotNull((Object)tablePath);
        try {
            String userName = this.getUserName();
            UserAndThread userAndThread = new UserAndThread(userName, Thread.currentThread().getName());
            Pair lookupKey = new Pair((Object)userAndThread, (Object)tablePath);
            return (DocumentStore)((DocumentStoreHolder)this.storeCache.get((Object)lookupKey)).get();
        }
        catch (ExecutionException e) {
            throw ExceptionHandler.handle((Throwable)e.getCause(), (String)"CachingStoreManager.getStore(String)");
        }
    }

    @Override
    public void putStore(@API.NonNullable DocumentStore store) {
        Preconditions.checkNotNull((Object)store);
        store.close();
    }

    @Override
    public Admin getAdmin() {
        try {
            String userName = this.getUserName();
            UserAndThread lookupKey = new UserAndThread(userName, Thread.currentThread().getName());
            return (Admin)((AdminHolder)this.adminCache.get((Object)lookupKey)).get();
        }
        catch (ExecutionException e) {
            throw ExceptionHandler.handle((Throwable)e.getCause(), (String)"CachingStoreManager.getStore(String)");
        }
    }

    @Override
    public void putAdmin(Admin admin) {
        Preconditions.checkNotNull((Object)admin);
        admin.close();
    }
}

