/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.google.common.collect.ImmutableList;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.BaseAuthenticator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.ojai.Document;
import org.ojai.store.exceptions.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PamAuthenticator
extends BaseAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(PamAuthenticator.class);
    public static final String SCHEME = "basic";
    private static final String PAM_DIR = "/etc/pam.d/";
    private List<String> pamFiles = new ArrayList<String>();

    @Override
    public void init(Document config) throws AuthenticationException {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        String serviceFile = Configs.getString(config, "authentication.pam.service", null);
        String configFilesStr = Configs.getString(config, "auth.pam.config.files", null);
        if (serviceFile == null && configFilesStr == null) {
            throw new AuthenticationException("No PAM Service has been configured!");
        }
        if (serviceFile == null) {
            String[] configFiles;
            for (String configFile : configFiles = configFilesStr.split(",")) {
                if (!this.checkFile(configFile, false)) continue;
                listBuilder.add((Object)configFile);
            }
        } else if (this.checkFile(serviceFile, true)) {
            listBuilder.add((Object)serviceFile);
        }
        this.pamFiles = listBuilder.build();
        log.info("PAM authentication configured with {}", this.pamFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String[] tokens = this.parseBasicAuthToken(authentication);
        String userName = tokens[0];
        String password = tokens[1];
        for (String file : this.pamFiles) {
            PAM pam = null;
            try {
                pam = new PAM(file);
                UnixUser unixUser = pam.authenticate(userName, password);
                Authentication authentication2 = this.createAuthentication(unixUser.getUserName());
                return authentication2;
            }
            catch (PAMException pAMException) {}
            continue;
            finally {
                if (pam == null) continue;
                pam.dispose();
            }
        }
        throw new AuthenticationException("PAM auth failed for user " + userName);
    }

    private boolean checkFile(String pamConfigFileName, boolean fail) {
        String pamConfigFile = PAM_DIR + pamConfigFileName;
        if (new File(pamConfigFile).canRead()) {
            return true;
        }
        if (fail) {
            throw new AuthenticationException("PAM config file '" + pamConfigFile + "' not found or isn't readable!");
        }
        return false;
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }
}

