/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway;

import com.mapr.web.security.WebSecurityConfig;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configs {
    private static final Logger log = LoggerFactory.getLogger(Configs.class);
    public static final String MAPR_DAG_AUTH_REQUIRED = "grpc.service.auth.required";
    public static final String MAPR_DAG_AUTH_SPOOF_AUTHENTICATOR = "auth.spoof.authenticator";
    public static final String MAPR_DAG_AUTH_SPOOF_USER = "auth.spoof.user";
    public static final String MAPR_DAG_AUTH_SPOOF_PASSWORD = "auth.spoof.password";
    public static final String MAPR_DAG_AUTH_TOKEN_SECRET = WebSecurityConfig.CONFIG.getAuthTokenPropSuffix();
    public static final String MAPR_DAG_AUTH_TOKEN_EXPIRATION = WebSecurityConfig.CONFIG.getAuthExprPropSuffix();
    public static final String MAPR_DAG_AUTH_PAM_CONFIG_FILES = "auth.pam.config.files";
    public static final String MAPR_DAG_PAM_SERVICE = "authentication.pam.service";
    public static final String MAPR_DAG_GRPC_PORT_OPTION = "grpc.service.port";
    public static final String MAPR_DAG_SSL_ENABLED = "grpc.service.ssl.enabled";
    public static final String MAPR_DAG_SSL_PROVIDER = "grpc.service.ssl.provider";
    public static final String MAPR_DAG_SSL_KEYSTORE = "grpc.service.ssl.keystore";
    public static final String MAPR_DAG_SSL_KEYSTORE_TYPE = "grpc.service.ssl.keystore.type";
    public static final String MAPR_DAG_SSL_KEYSTORE_ALGO = "grpc.service.ssl.keystore.algo";
    public static final String MAPR_DAG_SSL_KEYSTORE_PASSPHRASE = "grpc.service.ssl.keystore.passphrase";
    public static final String MAPR_DAG_STORE_CACHE_EXPIRATION_MS = "grpc.service.store.cache.expiration.millis";
    public static final String MAPR_DAG_RPC_INC_STK_TRC = "grpc.service.rpc.include-stack-trace";
    public static final String MAPR_DAG_OJAI_CONN_STR = "grpc.service.ojai.connection.string";
    public static final String MAPR_DAG_MAX_THREAD_POOL_SIZE = "grpc.service.executor.thread-pool-limit";
    public static final String MAPR_DAG_QUERY_RESULT_LIMIT = "grpc.service.ojai.query.result-limit";
    public static final String MAPR_DAG_MAX_MESSAGE_SIZE = "grpc.service.max-message-size";
    static final String PROCESS_SCOPE = WebSecurityConfig.CONFIG.getProcessName() + ".";

    public static String getString(@API.NonNullable Document doc, @API.NonNullable String fieldPath, @API.NonNullable String defaultValue) {
        Object key = fieldPath;
        String retVal = null;
        Value docValue = doc.getValue((String)key);
        if (docValue != null) {
            retVal = Values.asString((Value)docValue);
        } else {
            key = PROCESS_SCOPE + fieldPath;
            retVal = System.getProperty((String)key, defaultValue);
        }
        log.trace("Configuration property '{}', default '{}', value '{}'.", new Object[]{key, defaultValue, retVal});
        return retVal;
    }

    public static boolean getBoolean(@API.NonNullable Document document, @API.NonNullable String fieldPath, boolean defaultValue) {
        Object key = fieldPath;
        boolean retVal = defaultValue;
        Value docValue = document.getValue((String)key);
        if (docValue != null) {
            retVal = Values.asBoolean((Value)docValue);
        } else {
            key = PROCESS_SCOPE + fieldPath;
            String sysPropVal = System.getProperty((String)key);
            if (sysPropVal != null) {
                retVal = Boolean.valueOf(sysPropVal);
            }
        }
        log.trace("Configuration property '{}', default '{}', value '{}'.", new Object[]{key, defaultValue, retVal});
        return retVal;
    }

    public static int getInt(@API.NonNullable Document document, @API.NonNullable String fieldPath, int defaultValue) {
        Object key = fieldPath;
        int retVal = defaultValue;
        Value docValue = document.getValue((String)key);
        if (docValue != null) {
            retVal = Values.asInt((Value)docValue);
        } else {
            key = PROCESS_SCOPE + fieldPath;
            String sysPropVal = System.getProperty((String)key);
            if (sysPropVal != null) {
                retVal = Integer.valueOf(sysPropVal);
            }
        }
        log.trace("Configuration property '{}', default '{}', value '{}'.", new Object[]{key, defaultValue, retVal});
        return retVal;
    }

    public static long getLong(@API.NonNullable Document document, @API.NonNullable String fieldPath, long defaultValue) {
        Object key = fieldPath;
        long retVal = defaultValue;
        Value docValue = document.getValue((String)key);
        if (docValue != null) {
            retVal = Values.asLong((Value)docValue);
        } else {
            key = PROCESS_SCOPE + fieldPath;
            String sysPropVal = System.getProperty((String)key);
            if (sysPropVal != null) {
                retVal = Long.valueOf(sysPropVal);
            }
        }
        log.trace("Configuration property '{}', default '{}', value '{}'.", new Object[]{key, defaultValue, retVal});
        return retVal;
    }
}

