/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.google.common.base.Preconditions;
import com.mapr.data.gateway.Constants;
import com.mapr.data.gateway.ojai.store.CloseableHolder;
import org.ojai.Document;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.base.ForwardingStore;
import org.ojai.store.exceptions.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreHolder
extends CloseableHolder<DocumentStore> {
    private static final Logger log = LoggerFactory.getLogger(DocumentStoreHolder.class);
    private static final Document storeOptions = Constants.MAPR_OJAI_DRIVER.newDocument().set("ojai.mapr.documentstore.buffer-writes", false);
    private final DocumentStore store;

    DocumentStoreHolder(Connection connection, String storePath) {
        super(DocumentStoreHolder.createDocumentStore(connection, storePath));
        this.store = (DocumentStore)this.closeable;
        log.debug("Created DocumentStore instance {} for `{}`.", (Object)this.closeableId, (Object)storePath);
    }

    private static DocumentStore createDocumentStore(Connection connection, String storePath) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)storePath);
        return connection.getStore(storePath, storeOptions);
    }

    @Override
    DocumentStore getT() {
        Preconditions.checkState((this.refCount.get() != 0L ? 1 : 0) != 0, (Object)"Attempt to acquire a DocumentStore handle after it was closed!");
        this.maxRef.incrementAndGet();
        this.refCount.incrementAndGet();
        return new ForwardingStore(this.store){

            public void close() throws StoreException {
                DocumentStoreHolder.this.release();
            }
        };
    }
}

