/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CloseableHolder<T extends AutoCloseable> {
    private static final Logger log = LoggerFactory.getLogger(CloseableHolder.class);
    protected final String closeableId;
    protected final AtomicLong refCount;
    protected final AtomicLong maxRef = new AtomicLong(0L);
    protected final AutoCloseable closeable;

    CloseableHolder(T closeable) {
        this.refCount = new AtomicLong(1L);
        this.closeable = closeable;
        this.closeableId = Long.toHexString(System.identityHashCode(closeable));
    }

    void release() {
        if (this.refCount.decrementAndGet() == 0L) {
            log.debug("Closing {} instance {}, max ref count: {}.", new Object[]{this.closeable.getClass().getName(), this.closeableId, this.maxRef.get()});
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    T get() {
        Preconditions.checkState((this.refCount.get() != 0L ? 1 : 0) != 0, (Object)"Attempt to acquire a DocumentStore handle after it was closed!");
        this.maxRef.incrementAndGet();
        this.refCount.incrementAndGet();
        return this.getT();
    }

    abstract T getT();
}

