/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway;

import com.google.common.base.Preconditions;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.Lifecycle;
import com.mapr.data.gateway.ProjectInfo;
import com.mapr.data.gateway.SecurityProvider;
import com.mapr.data.gateway.auth.Authenticators;
import com.mapr.data.gateway.auth.ServerAuthInterceptor;
import com.mapr.data.gateway.ojai.grpc.MapRDbServerGrpcImpl;
import com.mapr.data.gateway.threads.GrpcThreadPoolExecutor;
import com.mapr.db.impl.MapRDBImpl;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDataGrpcService
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(MapRDataGrpcService.class);
    private final ExecutorService executorService;
    private final int port;
    private Server server;
    private boolean isRunning;
    private final Document config;
    private final boolean sslEnabled;

    public MapRDataGrpcService(String[] args) {
        this(MapRDataGrpcService.parse(args));
    }

    public MapRDataGrpcService(Document config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
        this.executorService = new GrpcThreadPoolExecutor(config);
        this.port = Configs.getInt(config, "grpc.service.port", 5678);
        this.sslEnabled = SecurityProvider.isSslEnabled(config);
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((!this.isRunning ? 1 : 0) != 0, (Object)"The service is already running!");
        SecurityProvider.init(this.config);
        if (Configs.getBoolean(this.config, "grpc.service.auth.required", true)) {
            Authenticators.init(this.config);
        } else {
            log.info("Authentication is disabled!!!");
        }
        ServerServiceDefinition serviceDfn = ServerInterceptors.intercept((BindableService)new MapRDbServerGrpcImpl(this.config), (ServerInterceptor[])new ServerInterceptor[]{new ServerAuthInterceptor(this.config)});
        NettyServerBuilder serverBuilder = (NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService(serviceDfn)).executor((Executor)this.executorService);
        if (this.sslEnabled) {
            log.info("Configuring SSL/TLS options for MapR gRPC Service.");
            serverBuilder.sslContext(SecurityProvider.getSslContext(this.config));
        } else {
            log.info("SSL/TLS is disabled, MapR gRPC Service will listen on plain socket.");
        }
        this.server = serverBuilder.build().start();
        log.info(ProjectInfo.getGitBuildInfo());
        log.info("MapR gRPC Service started, listening on {}.", (Object)this.port);
        this.isRunning = true;
    }

    @Override
    public void stop() {
        Preconditions.checkState((boolean)this.isRunning, (Object)"The service is not running!");
        this.server.shutdown();
        this.isRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.server.awaitTermination();
    }

    private static Document parse(String[] args) {
        Document doc = MapRDBImpl.newDocument();
        return Documents.readOnly((Document)doc);
    }
}

