/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.google.common.base.Preconditions;
import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.FamilyNotFoundException;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.index.IndexDesc;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;

public abstract class ForwardingAdmin
implements Admin {
    private final AdminImpl admin;

    public ForwardingAdmin(Admin admin) {
        this.admin = (AdminImpl)Preconditions.checkNotNull((Object)admin);
    }

    public List<Path> listTables() throws DBException {
        return this.admin.listTables();
    }

    public List<Path> listTables(String folderOrPattern) throws DBException {
        return this.admin.listTables(folderOrPattern);
    }

    public List<Path> listTables(Path folderOrPattern) throws DBException {
        throw this.unsupportedException();
    }

    public Table createTable(String tablePath) throws TableExistsException, DBException {
        return this.admin.createTable(tablePath, false);
    }

    public Table createTable(Path tablePath) throws TableExistsException, DBException {
        throw this.unsupportedException();
    }

    public Table createTable(TableDescriptor tableDesc) throws TableExistsException, DBException {
        throw this.unsupportedException();
    }

    public Table createTable(TableDescriptor tableDesc, String[] splitPoints) throws TableExistsException, DBException {
        throw this.unsupportedException();
    }

    public Table createTable(TableDescriptor tableDesc, ByteBuffer[] splitPoints) throws TableExistsException, DBException {
        throw this.unsupportedException();
    }

    public void alterTable(TableDescriptor tableDesc) throws TableNotFoundException, OpNotPermittedException, DBException {
        throw this.unsupportedException();
    }

    public boolean deleteFamily(String tablePath, String familyName) throws TableNotFoundException, FamilyNotFoundException, DBException {
        throw this.unsupportedException();
    }

    public boolean deleteFamily(Path tablePath, String familyName) throws TableNotFoundException, FamilyNotFoundException, DBException {
        throw this.unsupportedException();
    }

    public void alterFamily(String tablePath, String familyName, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyNotFoundException, OpNotPermittedException, DBException {
        throw this.unsupportedException();
    }

    public void alterFamily(Path tablePath, String familyName, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyNotFoundException, OpNotPermittedException, DBException {
        throw this.unsupportedException();
    }

    public boolean tableExists(String tablePath) throws DBException {
        return this.admin.tableExists(tablePath);
    }

    public boolean tableExists(Path tablePath) throws DBException {
        throw this.unsupportedException();
    }

    public TableDescriptor getTableDescriptor(String tablePath) throws DBException {
        throw this.unsupportedException();
    }

    public TableDescriptor getTableDescriptor(Path tablePath) throws DBException {
        throw this.unsupportedException();
    }

    public Collection<IndexDesc> getTableIndexes(String tablePath) throws DBException {
        throw this.unsupportedException();
    }

    public Collection<IndexDesc> getTableIndexes(Path tablePath) throws DBException {
        throw this.unsupportedException();
    }

    public boolean deleteTable(String tablePath) throws DBException {
        return this.admin.deleteTable(tablePath);
    }

    public boolean deleteTable(Path tablePath) throws DBException {
        throw this.unsupportedException();
    }

    private UnsupportedOperationException unsupportedException() {
        return new UnsupportedOperationException();
    }
}

