/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.store;

import com.google.common.base.Preconditions;
import com.mapr.data.gateway.ojai.store.CloseableHolder;
import com.mapr.data.gateway.ojai.store.ForwardingAdmin;
import com.mapr.db.Admin;
import com.mapr.db.impl.MapRDBImpl;
import org.ojai.store.exceptions.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminHolder
extends CloseableHolder<Admin> {
    private static final Logger log = LoggerFactory.getLogger(AdminHolder.class);
    private final Admin admin;

    AdminHolder() {
        super(MapRDBImpl.newAdmin());
        this.admin = (Admin)this.closeable;
        log.debug("Created Admin instance {}.", (Object)this.closeableId);
    }

    @Override
    Admin getT() {
        Preconditions.checkState((this.refCount.get() != 0L ? 1 : 0) != 0, (Object)"Attempt to acquire a Admin handle after it was closed!");
        this.maxRef.incrementAndGet();
        this.refCount.incrementAndGet();
        return new ForwardingAdmin(this.admin){

            public void close() throws StoreException {
                AdminHolder.this.release();
            }
        };
    }
}

