/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.codec;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.OjaiCodec;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;
import org.ojai.proto.OjaiDocument;
import org.ojai.proto.OjaiKeyValue;
import org.ojai.proto.OjaiList;
import org.ojai.proto.OjaiListItem;
import org.ojai.proto.OjaiValue;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import v3.com.google.protobuf.ByteString;
import v3.com.google.protobuf.Message;

public class ProtobufCodec
implements OjaiCodec<Message> {
    private final ValueBuilder valueBuilder;
    private final Driver driver;

    public ProtobufCodec(@API.NonNullable Driver driver) {
        this.driver = driver;
        this.valueBuilder = driver.getValueBuilder();
    }

    public OjaiDocument encodeDocument(@API.NonNullable Document ojaiDocument) throws EncodingException {
        Preconditions.checkNotNull((Object)ojaiDocument);
        OjaiDocument.Builder docBuilder = OjaiDocument.newBuilder();
        for (Map.Entry keyValue : ojaiDocument) {
            OjaiKeyValue.Builder kvBuilder = OjaiKeyValue.newBuilder();
            kvBuilder.setKey((String)keyValue.getKey());
            kvBuilder.setValue(this.toProtoValue((Value)keyValue.getValue()));
            docBuilder.addKeyValue(kvBuilder);
        }
        return docBuilder.build();
    }

    private OjaiValue.Builder toProtoValue(Value ojaiValue) {
        OjaiValue.Builder valueBuilder = OjaiValue.newBuilder();
        switch (ojaiValue.getType()) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                valueBuilder.setBoolValue(ojaiValue.getBoolean());
                break;
            }
            case STRING: {
                valueBuilder.setStringValue(ojaiValue.getString());
                break;
            }
            case BYTE: {
                valueBuilder.setByteValue((int)ojaiValue.getByte());
                break;
            }
            case SHORT: {
                valueBuilder.setShortValue((int)ojaiValue.getShort());
                break;
            }
            case INT: {
                valueBuilder.setIntValue(ojaiValue.getInt());
                break;
            }
            case LONG: {
                valueBuilder.setLongValue(ojaiValue.getLong());
                break;
            }
            case FLOAT: {
                valueBuilder.setFloatValue(ojaiValue.getFloat());
                break;
            }
            case DOUBLE: {
                valueBuilder.setDoubleValue(ojaiValue.getDouble());
                break;
            }
            case DECIMAL: {
                valueBuilder.setDecimalValue(ojaiValue.getDecimal().toString());
                break;
            }
            case DATE: {
                valueBuilder.setDateValue(ojaiValue.getDateAsInt());
                break;
            }
            case TIME: {
                valueBuilder.setTimeValue(ojaiValue.getTimeAsInt());
                break;
            }
            case TIMESTAMP: {
                valueBuilder.setTimestampValue(ojaiValue.getTimestampAsLong());
                break;
            }
            case INTERVAL: {
                valueBuilder.setIntervalValue(ojaiValue.getIntervalAsLong());
                break;
            }
            case BINARY: {
                valueBuilder.setBinaryValue(ByteString.copyFrom((ByteBuffer)ojaiValue.getBinary()));
                break;
            }
            case MAP: {
                OjaiDocument.Builder docBuilder = this.toProtoDocument(ojaiValue.getMap());
                valueBuilder.setMapValue(docBuilder);
                break;
            }
            case ARRAY: {
                OjaiList.Builder listBuilder = this.toProtoList(ojaiValue.getList());
                valueBuilder.setListValue(listBuilder);
                break;
            }
            default: {
                throw new EncodingException("Unknown Value type: " + ojaiValue.getType());
            }
        }
        return valueBuilder;
    }

    private OjaiDocument.Builder toProtoDocument(Map<String, Object> ojaiMap) {
        OjaiDocument.Builder docBuilder = OjaiDocument.newBuilder();
        for (Map.Entry<String, Object> keyValue : ojaiMap.entrySet()) {
            OjaiKeyValue.Builder kvBuilder = OjaiKeyValue.newBuilder();
            kvBuilder.setKey(keyValue.getKey());
            kvBuilder.setValue(this.toProtoValue(keyValue.getValue()));
            docBuilder.addKeyValue(kvBuilder);
        }
        return docBuilder;
    }

    private OjaiList.Builder toProtoList(List<Object> ojaiList) {
        OjaiList.Builder listBuilder = OjaiList.newBuilder();
        int i = 0;
        for (Object item : ojaiList) {
            listBuilder.addValue(this.toProtoListItem(i++, item));
        }
        return listBuilder;
    }

    private OjaiListItem.Builder toProtoListItem(int index, Object ojaiObject) {
        OjaiListItem.Builder listItemBuilder = OjaiListItem.newBuilder();
        listItemBuilder.setIndex(index);
        listItemBuilder.setValue(this.toProtoValue(ojaiObject));
        return listItemBuilder;
    }

    private OjaiValue.Builder toProtoValue(Object ojaiObject) {
        OjaiValue.Builder valueBuilder = OjaiValue.newBuilder();
        if (ojaiObject instanceof Byte) {
            return valueBuilder.setByteValue((int)((Byte)ojaiObject).byteValue());
        }
        if (ojaiObject instanceof Boolean) {
            return valueBuilder.setBoolValue(((Boolean)ojaiObject).booleanValue());
        }
        if (ojaiObject instanceof String) {
            return valueBuilder.setStringValue((String)ojaiObject);
        }
        if (ojaiObject instanceof Short) {
            return valueBuilder.setShortValue((int)((Short)ojaiObject).shortValue());
        }
        if (ojaiObject instanceof Integer) {
            return valueBuilder.setIntValue(((Integer)ojaiObject).intValue());
        }
        if (ojaiObject instanceof Long) {
            return valueBuilder.setLongValue(((Long)ojaiObject).longValue());
        }
        if (ojaiObject instanceof Float) {
            return valueBuilder.setFloatValue(((Float)ojaiObject).floatValue());
        }
        if (ojaiObject instanceof Double) {
            return valueBuilder.setDoubleValue(((Double)ojaiObject).doubleValue());
        }
        if (ojaiObject instanceof OTime) {
            return valueBuilder.setTimeValue(((OTime)ojaiObject).toTimeInMillis());
        }
        if (ojaiObject instanceof ODate) {
            return valueBuilder.setDateValue(((ODate)ojaiObject).toDaysSinceEpoch());
        }
        if (ojaiObject instanceof OTimestamp) {
            return valueBuilder.setTimestampValue(((OTimestamp)ojaiObject).getMillis());
        }
        if (ojaiObject instanceof BigDecimal) {
            return valueBuilder.setDecimalValue(((BigDecimal)ojaiObject).toString());
        }
        if (ojaiObject instanceof ByteBuffer) {
            return valueBuilder.setBinaryValue(ByteString.copyFrom((ByteBuffer)((ByteBuffer)ojaiObject)));
        }
        if (ojaiObject instanceof OInterval) {
            return valueBuilder.setIntervalValue(((OInterval)ojaiObject).getTimeInMillis());
        }
        if (ojaiObject instanceof Map) {
            return valueBuilder.setMapValue(this.toProtoDocument((Map)ojaiObject));
        }
        if (ojaiObject instanceof List) {
            return valueBuilder.setListValue(this.toProtoList((List)ojaiObject));
        }
        throw new EncodingException("Unexpected object type of class: " + ojaiObject.getClass());
    }

    public Document decodeDocument(@API.NonNullable Message encoded) throws DecodingException {
        Preconditions.checkNotNull((Object)encoded);
        if (!(encoded instanceof OjaiDocument)) {
            throw new DecodingException("Invalid Protobuf message type: " + encoded.getClass().getCanonicalName());
        }
        OjaiDocument protoDoc = (OjaiDocument)encoded;
        Document doc = this.driver.newDocument();
        int numFields = protoDoc.getKeyValueCount();
        for (int i = 0; i < numFields; ++i) {
            OjaiKeyValue protoKV = protoDoc.getKeyValue(i);
            doc.set(protoKV.getKey(), this.toOjaiValue(protoKV.getValue()));
        }
        return doc;
    }

    private Value toOjaiValue(OjaiValue value) {
        switch (value.getDataCase()) {
            case NULL_VALUE: {
                return this.valueBuilder.newNullValue();
            }
            case BOOL_VALUE: {
                return this.valueBuilder.newValue(value.getBoolValue());
            }
            case STRING_VALUE: {
                return this.valueBuilder.newValue(value.getStringValue());
            }
            case BYTE_VALUE: {
                return this.valueBuilder.newValue(value.getByteValue());
            }
            case SHORT_VALUE: {
                return this.valueBuilder.newValue(value.getShortValue());
            }
            case INT_VALUE: {
                return this.valueBuilder.newValue(value.getIntValue());
            }
            case LONG_VALUE: {
                return this.valueBuilder.newValue(value.getLongValue());
            }
            case FLOAT_VALUE: {
                return this.valueBuilder.newValue(value.getFloatValue());
            }
            case DOUBLE_VALUE: {
                return this.valueBuilder.newValue(value.getDoubleValue());
            }
            case DECIMAL_VALUE: {
                return this.valueBuilder.newValue(new BigDecimal(value.getDecimalValue()));
            }
            case DATE_VALUE: {
                return this.valueBuilder.newValue(ODate.fromDaysSinceEpoch((int)value.getDateValue()));
            }
            case TIME_VALUE: {
                return this.valueBuilder.newValue(OTime.fromMillisOfDay((int)value.getTimeValue()));
            }
            case TIMESTAMP_VALUE: {
                return this.valueBuilder.newValue(new OTimestamp(value.getTimestampValue()));
            }
            case INTERVAL_VALUE: {
                return this.valueBuilder.newValue(new OInterval(value.getIntervalValue()));
            }
            case BINARY_VALUE: {
                return this.valueBuilder.newValue(value.getBinaryValue().asReadOnlyByteBuffer());
            }
            case MAP_VALUE: 
            case LIST_VALUE: {
                throw new UnsupportedOperationException("Decoding of MAP and LIST is not implemented yet.");
            }
        }
        throw new DecodingException("Unknown Value type: " + value.getDataCase());
    }

    public Message encodeQuery(@API.NonNullable Query query) throws EncodingException {
        throw new UnsupportedOperationException();
    }

    public Query decodeQuery(Message encodedQuery, Document options) throws DecodingException {
        throw new UnsupportedOperationException();
    }

    public Message encodeCondition(QueryCondition condition) throws EncodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public QueryCondition decodeCondition(Message encodedCondition) throws DecodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Message encodeMutation(DocumentMutation mutation) throws EncodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DocumentMutation decodeMutation(Message encodedMutation) throws DecodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

