/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.google.common.io.BaseEncoding;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.Authenticator;
import com.mapr.data.gateway.auth.JwtAuthenticator;
import com.mapr.data.gateway.auth.UserInfo;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import org.ojai.store.exceptions.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthenticator.class);
    private static final BaseEncoding BASE64_CODEC = BaseEncoding.base64();

    protected Authentication createAuthentication(String userName) {
        return UserInfo.builder().userName(userName).token(JwtAuthenticator.generateToken(userName)).authenticated(true).build();
    }

    protected String[] parseBasicAuthToken(Authentication authentication) throws AuthenticationException {
        String token = authentication.getToken();
        if (token == null) {
            throw new AuthenticationException("An auth token was not part of the authentication object.");
        }
        try {
            String decodedToken = Bytes.toString((byte[])BASE64_CODEC.decode((CharSequence)token));
            String[] tokens = decodedToken.split(":", 2);
            return tokens;
        }
        catch (IllegalArgumentException e) {
            log.trace("Unable to decode the authentication token `{}`.", (Object)token);
            throw new AuthenticationException("Unable to decode the authentication token.", (Throwable)e);
        }
    }
}

