/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.grpc;

import com.mapr.data.db.proto.ErrorCode;
import com.mapr.data.db.proto.RpcError;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RpcErrorManager {
    private static boolean includeStackTrace = true;

    static RpcError.Builder noError() {
        return RpcError.newBuilder().setErrCode(ErrorCode.NO_ERROR);
    }

    static RpcError.Builder newError(ErrorCode err) {
        return RpcError.newBuilder().setErrCode(err);
    }

    static RpcError.Builder newError(ErrorCode err, String errMsg) {
        return RpcError.newBuilder().setErrCode(err).setErrorMessage(errMsg);
    }

    static RpcError.Builder newError(ErrorCode err, Throwable t) {
        RpcError.Builder builder = RpcError.newBuilder().setErrCode(err).setErrorMessage(t.getMessage());
        if (includeStackTrace) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            builder.setJavaStackTrace(writer.toString());
        }
        return builder;
    }

    static void setIncludeStackTrace(boolean includeStackTrace) {
        RpcErrorManager.includeStackTrace = includeStackTrace;
    }
}

