/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.BaseAuthenticator;
import com.mapr.data.gateway.auth.UserInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.function.Function;
import org.ojai.Document;
import org.ojai.store.exceptions.AuthenticationException;
import org.ojai.store.exceptions.ExpiredTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtAuthenticator
extends BaseAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticator.class);
    private static final int NUM_SECS_IN_THIRTY_MINUTES = 1800;
    public static final String SCHEME = "bearer";
    private static final String DEFAULT_SIGNING_KEY = "bad_jwt_signing_key";
    private static String signingKey;
    private static Long tokenExpirationMillis;

    JwtAuthenticator() {
    }

    @Override
    public void init(Document config) throws AuthenticationException {
        signingKey = Configs.getString(config, "auth.token.secret", DEFAULT_SIGNING_KEY);
        if (signingKey == DEFAULT_SIGNING_KEY) {
            log.warn("A signing key was not configured for JWT authenticator!!!! Using default!!!");
        }
        tokenExpirationMillis = Configs.getLong(config, "auth.token.expiration", 1800L) * 1000L;
        log.info("JWT token expiration duration set to {}ms.", (Object)tokenExpirationMillis);
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String token = authentication.getToken();
        if (token == null) {
            throw new AuthenticationException("A JWT token was not part of the authentication object.");
        }
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(signingKey).parseClaimsJws(token).getBody();
            String userName = this.getClaim(claims, Claims::getSubject);
            return UserInfo.builder().userName(userName).authenticated(true).build();
        }
        catch (ExpiredJwtException e) {
            throw new ExpiredTokenException("Expired JWT token!", (Throwable)e);
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            throw new AuthenticationException("JWT verification failed! " + e.getMessage(), e);
        }
    }

    private <T> T getClaim(Claims claims, Function<Claims, T> claimsResolver) {
        return claimsResolver.apply(claims);
    }

    static String generateToken(String subject) {
        long currentTimeMillis = System.currentTimeMillis();
        Date createdDate = new Date(currentTimeMillis);
        Date expirationDate = new Date(currentTimeMillis + tokenExpirationMillis);
        return Jwts.builder().setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, signingKey).compact();
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }
}

