/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.google.common.collect.ImmutableList;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authenticator;
import com.mapr.data.gateway.auth.JwtAuthenticator;
import com.mapr.data.gateway.auth.PamAuthenticator;
import com.mapr.data.gateway.auth.SpoofPamAuthenticator;
import java.util.ArrayList;
import java.util.List;
import jersey.repackaged.com.google.common.collect.Lists;
import org.apache.commons.lang3.SystemUtils;
import org.ojai.Document;
import org.ojai.store.exceptions.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Authenticators {
    private static final Logger log = LoggerFactory.getLogger(Authenticators.class);
    public static Authenticator PAM_AUTHENTICATOR;
    public static Authenticator JWT_AUTHENTICATOR;
    public static List<Authenticator> authenticators;
    private static volatile boolean intialized;

    public static void init(Document config) throws AuthenticationException {
        if (!intialized) {
            boolean spoofAuth = Configs.getBoolean(config, "auth.spoof.authenticator", SystemUtils.IS_OS_WINDOWS);
            if (spoofAuth) {
                log.warn("Using spoofed authenticator, should not be used in production deployments");
            }
            PAM_AUTHENTICATOR = spoofAuth ? new SpoofPamAuthenticator() : new PamAuthenticator();
            JWT_AUTHENTICATOR = new JwtAuthenticator();
            authenticators = new ImmutableList.Builder().add((Object)JWT_AUTHENTICATOR).add((Object)PAM_AUTHENTICATOR).build();
            ArrayList authSchemes = Lists.newArrayList();
            for (Authenticator authenticator : authenticators) {
                authenticator.init(config);
                authSchemes.add(authenticator.getScheme());
            }
            intialized = true;
            log.info("Supported authenticators: {}", (Object)authSchemes);
        }
    }

    public static Authenticator getAuthenticator(String authScheme) {
        switch (authScheme) {
            case "bearer": {
                return JWT_AUTHENTICATOR;
            }
            case "basic": {
                return PAM_AUTHENTICATOR;
            }
        }
        throw new AuthenticationException("Unsupported authentication scheme: " + authScheme);
    }

    static {
        intialized = false;
    }
}

