

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/IntervalNumericArithmetic.java template.
 */

public class IntervalYearBigIntFunctions {


    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalYearBigIntMultiplyFunction implements DrillSimpleFunc {
    @Param IntervalYearHolder left;
    @Param BigIntHolder right;
    @Output IntervalHolder out;

        public void setup() {
        }

        public void eval() {
    out.months = (int) (left.value * right.value);
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class BigIntIntervalYearMultiplyFunction implements DrillSimpleFunc {
    @Param BigIntHolder right;
    @Param IntervalYearHolder left;
    @Output IntervalHolder out;

        public void setup() {
        }

        public void eval() {
    out.months = (int) (left.value * right.value);
        }
    }

  @SuppressWarnings("unused")
  @FunctionTemplate(names = {"divide", "div"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class IntervalYearBigIntDivideFunction implements DrillSimpleFunc {
    @Param IntervalYearHolder left;
    @Param BigIntHolder right;
    @Output IntervalHolder out;

    public void setup() {
    }

    public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalMonths = (left.value / (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.vector.DateUtilities.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
    }
  }
}

