/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.codec;

import com.google.common.base.Preconditions;
import com.mapr.db.util.ConditionParser;
import com.mapr.db.util.MutationParser;
import com.mapr.ojai.store.impl.QueryParser;
import org.ojai.Document;
import org.ojai.OjaiCodec;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;
import org.ojai.json.JsonOptions;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

public class JsonCodec
implements OjaiCodec<String> {
    private final Driver driver;

    public JsonCodec(Driver driver) {
        this.driver = driver;
    }

    public String encodeDocument(Document ojaiDocument) throws EncodingException {
        Preconditions.checkNotNull((Object)ojaiDocument);
        return ojaiDocument.asJsonString(JsonOptions.WITH_TAGS);
    }

    public Document decodeDocument(String encodedDocument) throws DecodingException {
        Preconditions.checkNotNull((Object)encodedDocument);
        return this.driver.newDocument(encodedDocument);
    }

    public String encodeQuery(Query query) throws EncodingException {
        Preconditions.checkNotNull((Object)query);
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Query decodeQuery(String encodedQuery, Document options) throws DecodingException {
        Preconditions.checkNotNull((Object)encodedQuery);
        return new QueryParser().withOptions(options).parseQuery(encodedQuery);
    }

    public QueryCondition decodeCondition(String encodedCondition) throws DecodingException {
        Preconditions.checkNotNull((Object)encodedCondition);
        return new ConditionParser().parseCondition(encodedCondition);
    }

    public String encodeCondition(QueryCondition condition) throws EncodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DocumentMutation decodeMutation(String encodedMutation) throws DecodingException {
        return new MutationParser().parseMutation(encodedMutation);
    }

    public String encodeMutation(DocumentMutation mutation) throws EncodingException {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

