/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.BaseAuthenticator;
import com.mapr.data.gateway.auth.UserInfo;
import com.mapr.web.security.TokenUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.util.Date;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.ojai.Document;
import org.ojai.store.exceptions.AuthenticationException;
import org.ojai.store.exceptions.ExpiredTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtAuthenticator
extends BaseAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticator.class);
    private static final int NUM_SECS_IN_THIRTY_MINUTES = 1800;
    public static final String SCHEME = "bearer";
    private SecretKey signingKey;
    private Long tokenExpirationMillis;

    JwtAuthenticator() {
    }

    @Override
    public void init(Document config) throws AuthenticationException {
        String authTokenSecret = Configs.getString(config, Configs.MAPR_DAG_AUTH_TOKEN_SECRET, null);
        if (authTokenSecret == null) {
            throw new SecurityException("A signing key was not configured for JWT authenticator");
        }
        this.signingKey = TokenUtil.hmacShaKeyFor((String)authTokenSecret);
        this.tokenExpirationMillis = Configs.getLong(config, Configs.MAPR_DAG_AUTH_TOKEN_EXPIRATION, 1800L) * 1000L;
        log.info("JWT token expiration duration set to {}ms.", (Object)this.tokenExpirationMillis);
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String token = authentication.getToken();
        if (token == null) {
            throw new AuthenticationException("A JWT token was not part of the authentication object.");
        }
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)this.signingKey).parseClaimsJws(token).getBody();
            String userName = this.getClaim(claims, Claims::getSubject);
            return UserInfo.builder().userName(userName).authenticated(true).build();
        }
        catch (ExpiredJwtException e) {
            throw new ExpiredTokenException("Expired JWT token!", (Throwable)e);
        }
        catch (MalformedJwtException | UnsupportedJwtException | IllegalArgumentException | SecurityException e) {
            throw new AuthenticationException("JWT verification failed! " + e.getMessage(), e);
        }
    }

    private <T> T getClaim(Claims claims, Function<Claims, T> claimsResolver) {
        return claimsResolver.apply(claims);
    }

    String generateToken(String subject) {
        long currentTimeMillis = System.currentTimeMillis();
        Date createdDate = new Date(currentTimeMillis);
        Date expirationDate = new Date(currentTimeMillis + this.tokenExpirationMillis);
        return Jwts.builder().setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith((Key)this.signingKey, SignatureAlgorithm.HS512).compact();
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }
}

