/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadminImpl;
import org.apache.kerby.kerberos.kerb.client.Krb5Conf;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbPkinitClient;
import org.apache.kerby.kerberos.kerb.client.KrbTokenClient;
import org.apache.kerby.kerberos.kerb.server.KdcServer;
import org.apache.kerby.util.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKdcServer
extends KdcServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKdcServer.class);
    private final KrbClient krbClnt;
    private LocalKadmin kadmin;
    private Krb5Conf krb5Conf;
    private File workDir;
    private KrbPkinitClient pkinitClient;
    private KrbTokenClient tokenClient;

    public SimpleKdcServer() throws KrbException {
        this.krbClnt = new KrbClient(new KrbConfig());
        this.setKdcRealm("EXAMPLE.COM");
        this.setKdcHost("localhost");
        this.setKdcPort(NetworkUtil.getServerPort());
    }

    public SimpleKdcServer(KrbConfig krbConfig) {
        this.krbClnt = new KrbClient(krbConfig);
    }

    public SimpleKdcServer(File confDir, KrbConfig krbConfig) throws KrbException {
        super(confDir);
        this.krbClnt = new KrbClient(krbConfig);
    }

    public synchronized void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public synchronized File getWorkDir() {
        return this.workDir;
    }

    public synchronized void setKdcRealm(String realm) {
        super.setKdcRealm(realm);
        this.krbClnt.setKdcRealm(realm);
    }

    public synchronized void setKdcHost(String kdcHost) {
        super.setKdcHost(kdcHost);
        this.krbClnt.setKdcHost(kdcHost);
    }

    public synchronized void setKdcTcpPort(int kdcTcpPort) {
        super.setKdcTcpPort(kdcTcpPort);
        this.krbClnt.setKdcTcpPort(kdcTcpPort);
        this.setAllowTcp(true);
    }

    public synchronized void setAllowUdp(boolean allowUdp) {
        super.setAllowUdp(allowUdp);
        this.krbClnt.setAllowUdp(allowUdp);
    }

    public synchronized void setAllowTcp(boolean allowTcp) {
        super.setAllowTcp(allowTcp);
        this.krbClnt.setAllowTcp(allowTcp);
    }

    public synchronized void setKdcUdpPort(int kdcUdpPort) {
        super.setKdcUdpPort(kdcUdpPort);
        this.krbClnt.setKdcUdpPort(kdcUdpPort);
        this.setAllowUdp(true);
    }

    public synchronized void init() throws KrbException {
        super.init();
        this.kadmin = new LocalKadminImpl(this.getKdcSetting(), this.getIdentityService());
        this.kadmin.createBuiltinPrincipals();
        try {
            this.krb5Conf = new Krb5Conf(this);
            this.krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
    }

    public synchronized void start() throws KrbException {
        super.start();
        this.krbClnt.init();
    }

    public synchronized KrbClient getKrbClient() {
        return this.krbClnt;
    }

    public synchronized KrbPkinitClient getPkinitClient() {
        if (this.pkinitClient == null) {
            this.pkinitClient = new KrbPkinitClient(this.krbClnt);
        }
        return this.pkinitClient;
    }

    public synchronized KrbTokenClient getTokenClient() {
        if (this.tokenClient == null) {
            this.tokenClient = new KrbTokenClient(this.krbClnt);
        }
        return this.tokenClient;
    }

    public synchronized LocalKadmin getKadmin() {
        return this.kadmin;
    }

    public synchronized void createPrincipal(String principal) throws KrbException {
        this.kadmin.addPrincipal(principal);
    }

    public synchronized void createPrincipal(String principal, String password) throws KrbException {
        this.kadmin.addPrincipal(principal, password);
    }

    public synchronized void createPrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.kadmin.addPrincipal(principal);
        }
    }

    public synchronized void createAndExportPrincipals(File keytabFile, String ... principals) throws KrbException {
        this.createPrincipals(principals);
        this.exportPrincipals(keytabFile);
    }

    public synchronized void deletePrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.deletePrincipal(principal);
        }
    }

    public synchronized void deletePrincipal(String principal) throws KrbException {
        this.kadmin.deletePrincipal(principal);
    }

    public synchronized void exportPrincipals(File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile);
    }

    public synchronized void exportPrincipal(String principal, File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile, principal);
    }

    public synchronized void stop() throws KrbException {
        super.stop();
        try {
            this.krb5Conf.deleteKrb5conf();
        }
        catch (IOException e) {
            LOG.info("Fail to delete krb5 conf. " + e);
        }
    }
}

