/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.BitSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jline.reader.LineReader;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.WCWidth;
import sqlline.CommandHandler;
import sqlline.Dialect;
import sqlline.HighlightStyle;
import sqlline.SqlLine;

public class SqlLineHighlighter
extends DefaultHighlighter {
    private final SqlLine sqlLine;

    public SqlLineHighlighter(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        try {
            boolean isSql;
            boolean skipSyntaxHighlighter = "default".equals(this.sqlLine.getOpts().getColorScheme());
            if (skipSyntaxHighlighter) {
                return super.highlight(reader, buffer);
            }
            int underlineStart = -1;
            int underlineEnd = -1;
            int negativeStart = -1;
            int negativeEnd = -1;
            boolean command = false;
            BitSet keywordBitSet = new BitSet(buffer.length());
            BitSet quoteBitSet = new BitSet(buffer.length());
            BitSet sqlIdentifierQuotesBitSet = new BitSet(buffer.length());
            BitSet commentBitSet = new BitSet(buffer.length());
            BitSet numberBitSet = new BitSet(buffer.length());
            String trimmed = buffer.trim();
            int startingPoint = this.getStartingPoint(buffer);
            boolean isCommandPresent = trimmed.startsWith("!");
            boolean isComment = !isCommandPresent && this.sqlLine.isComment(trimmed, false);
            boolean bl = isSql = !isComment && this.isSqlQuery(trimmed, isCommandPresent);
            if (trimmed.length() > 1 && isCommandPresent) {
                int end = trimmed.indexOf(32);
                String possibleCommand = end == -1 ? trimmed.substring(1) : trimmed.substring(1, end);
                for (CommandHandler ch : this.sqlLine.getCommandHandlers()) {
                    if (!Objects.equals(possibleCommand, ch.getName()) && !ch.getNames().contains(possibleCommand)) continue;
                    command = true;
                    break;
                }
            }
            if (isSql) {
                this.handleSqlSyntax(buffer, keywordBitSet, quoteBitSet, sqlIdentifierQuotesBitSet, commentBitSet, numberBitSet, isCommandPresent);
            } else if (isCommandPresent) {
                this.handleQuotesInCommands(buffer, quoteBitSet, sqlIdentifierQuotesBitSet);
            } else {
                this.handleComments(buffer, commentBitSet, startingPoint, false);
            }
            String search = reader.getSearchTerm();
            if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
                underlineEnd = underlineStart + search.length() - 1;
            }
            if (reader.getRegionActive() != LineReader.RegionType.NONE) {
                negativeStart = reader.getRegionMark();
                if (negativeStart > (negativeEnd = reader.getBuffer().cursor())) {
                    int x = negativeEnd;
                    negativeEnd = negativeStart;
                    negativeStart = x;
                }
                if (reader.getRegionActive() == LineReader.RegionType.LINE) {
                    while (negativeStart > 0 && reader.getBuffer().atChar(negativeStart - 1) != 10) {
                        --negativeStart;
                    }
                    while (negativeEnd < reader.getBuffer().length() - 1 && reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                        ++negativeEnd;
                    }
                }
            }
            AttributedStringBuilder sb = new AttributedStringBuilder();
            int commandStart = command ? buffer.indexOf("!") : -1;
            int commandEnd = command ? buffer.indexOf(32, commandStart) : -1;
            HighlightStyle highlightStyle = this.sqlLine.getHighlightStyle();
            for (int i = 0; i < buffer.length(); ++i) {
                char c;
                if (i < startingPoint) {
                    sb.style(highlightStyle.getDefaultStyle());
                } else if (isSql) {
                    if (keywordBitSet.get(i)) {
                        sb.style(highlightStyle.getKeywordStyle());
                    } else if (quoteBitSet.get(i)) {
                        sb.style(highlightStyle.getQuotedStyle());
                    } else if (sqlIdentifierQuotesBitSet.get(i)) {
                        sb.style(highlightStyle.getIdentifierStyle());
                    } else if (commentBitSet.get(i)) {
                        sb.style(highlightStyle.getCommentStyle());
                    } else if (numberBitSet.get(i)) {
                        sb.style(highlightStyle.getNumberStyle());
                    } else if (i == 0 || i > commandEnd && (i < underlineStart || i > underlineEnd) && (i < negativeStart || i > negativeEnd)) {
                        sb.style(highlightStyle.getDefaultStyle());
                    }
                } else if (quoteBitSet != null && quoteBitSet.get(i)) {
                    sb.style(highlightStyle.getQuotedStyle());
                } else if (sqlIdentifierQuotesBitSet != null && sqlIdentifierQuotesBitSet.get(i)) {
                    sb.style(highlightStyle.getIdentifierStyle());
                } else if (commentBitSet.get(i)) {
                    sb.style(highlightStyle.getCommentStyle());
                }
                if (i == commandStart && command) {
                    sb.style(highlightStyle.getCommandStyle());
                }
                if (i == commandEnd) {
                    sb.style(highlightStyle.getDefaultStyle());
                }
                if (i >= underlineStart && i <= underlineEnd) {
                    sb.style(sb.style().underline());
                }
                if (i >= negativeStart && i <= negativeEnd) {
                    sb.style(sb.style().inverse());
                }
                if ((c = buffer.charAt(i)) == '\t' || c == '\n') {
                    sb.append(c);
                } else if (c < ' ') {
                    sb.style(AttributedStyle::inverseNeg).append('^').append((char)(c + 64)).style(AttributedStyle::inverseNeg);
                } else {
                    int w = WCWidth.wcwidth((int)c);
                    if (w > 0) {
                        sb.append(c);
                    }
                }
                if (i == underlineEnd) {
                    sb.style(sb.style().underlineOff());
                }
                if (i != negativeEnd) continue;
                sb.style(sb.style().inverseOff());
            }
            return sb.toAttributedString();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
            AttributedStringBuilder sb = new AttributedStringBuilder();
            return sb.append((CharSequence)buffer).toAttributedString();
        }
    }

    private int getStartingPoint(String buffer) {
        for (int i = 0; i < buffer.length(); ++i) {
            if (Character.isWhitespace(buffer.charAt(i))) continue;
            return i;
        }
        return buffer.length();
    }

    private void handleSqlSyntax(String buffer, BitSet keywordBitSet, BitSet quoteBitSet, BitSet sqlIdentifierQuotesBitSet, BitSet commentBitSet, BitSet numberBitSet, boolean isCommandPresent) {
        int wordStart = -1;
        int start = 0;
        if (isCommandPresent) {
            for (start = buffer.indexOf("!") + "!".length(); start < buffer.length() && !Character.isWhitespace(buffer.charAt(start)); ++start) {
            }
        }
        Dialect dialect = this.sqlLine.getDialect();
        for (int pos = start; pos < buffer.length(); ++pos) {
            char ch = buffer.charAt(pos);
            if (wordStart > -1) {
                if (pos != buffer.length() - 1 && (Character.isLetterOrDigit(ch) || ch == '_')) continue;
                String word = !Character.isLetterOrDigit(ch) ? buffer.substring(wordStart, pos) : buffer.substring(wordStart);
                String upperWord = word.toUpperCase(Locale.ROOT);
                if (dialect.containsKeyword(upperWord)) {
                    keywordBitSet.set(wordStart, wordStart + word.length());
                }
                wordStart = -1;
            }
            if (ch == dialect.getOpenQuote()) {
                pos = this.handleSqlIdentifierQuotes(buffer, String.valueOf(dialect.getOpenQuote()), String.valueOf(dialect.getCloseQuote()), sqlIdentifierQuotesBitSet, pos);
            }
            if (ch == '\'') {
                pos = this.handleSqlSingleQuotes(buffer, quoteBitSet, pos);
            }
            if (pos <= buffer.length() - 1) {
                pos = this.handleComments(buffer, commentBitSet, pos, true);
            }
            if (!(wordStart != -1 || !Character.isLetter(ch) && ch != '@' && ch != '#' && ch != '_' || pos != 0 && buffer.charAt(pos - 1) == '.')) {
                wordStart = pos;
                continue;
            }
            if (wordStart != -1 || !Character.isDigit(ch) || pos != 0 && (Character.isLetterOrDigit(buffer.charAt(pos - 1)) || buffer.charAt(pos - 1) == '_')) continue;
            pos = this.handleNumbers(buffer, numberBitSet, pos);
        }
    }

    void handleQuotesInCommands(String line, BitSet quoteBitSet, BitSet doubleQuoteBitSet) {
        int doubleQuoteStart = -1;
        int quoteStart = -1;
        for (int pos = 0; pos < line.length(); ++pos) {
            char ch = line.charAt(pos);
            if (doubleQuoteStart > -1) {
                doubleQuoteBitSet.set(pos);
                if (ch != '\"') continue;
                doubleQuoteStart = -1;
                continue;
            }
            if (quoteStart > -1) {
                quoteBitSet.set(pos);
                if (ch != '\'') continue;
                quoteStart = -1;
                continue;
            }
            if (ch == '\"') {
                doubleQuoteBitSet.set(pos);
                doubleQuoteStart = pos;
            }
            if (doubleQuoteStart != -1 || ch != '\'') continue;
            quoteBitSet.set(pos);
            quoteStart = pos;
        }
    }

    private boolean isSqlQuery(String trimmed, boolean isCommandPresent) {
        return !isCommandPresent || trimmed.startsWith("!all") || trimmed.startsWith("!call") || trimmed.startsWith("!sql");
    }

    int handleSqlIdentifierQuotes(String line, String openSqlIdentifier, String closeSqlIdentifier, BitSet sqlIdentifierQuotesBitSet, int startingPoint) {
        if (!openSqlIdentifier.regionMatches(0, line, startingPoint, openSqlIdentifier.length())) {
            return startingPoint;
        }
        int backslashCounter = 0;
        for (int i = startingPoint + openSqlIdentifier.length(); i < line.length(); ++i) {
            if (line.charAt(i) == '\\') {
                ++backslashCounter;
                continue;
            }
            if (closeSqlIdentifier.regionMatches(0, line, i, closeSqlIdentifier.length())) {
                if (backslashCounter % 2 != 0) continue;
                sqlIdentifierQuotesBitSet.set(startingPoint, i + closeSqlIdentifier.length());
                return i + closeSqlIdentifier.length() - 1;
            }
            backslashCounter = 0;
        }
        sqlIdentifierQuotesBitSet.set(startingPoint, line.length());
        return line.length() - 1;
    }

    int handleNumbers(String line, BitSet numberBitSet, int startingPoint) {
        int end;
        for (end = startingPoint + 1; end < line.length() && Character.isDigit(line.charAt(end)); ++end) {
        }
        if (end == line.length()) {
            if (Character.isDigit(line.charAt(line.length() - 1))) {
                numberBitSet.set(startingPoint, end);
            }
        } else if (Character.isWhitespace(line.charAt(end)) || line.charAt(end) == ';' || line.charAt(end) == ',' || line.charAt(end) == '=' || line.charAt(end) == '<' || line.charAt(end) == '>' || line.charAt(end) == '-' || line.charAt(end) == '+' || line.charAt(end) == '/' || line.charAt(end) == ')' || line.charAt(end) == '%' || line.charAt(end) == '*' || line.charAt(end) == '!' || line.charAt(end) == '^' || line.charAt(end) == '|' || line.charAt(end) == '&' || line.charAt(end) == ']') {
            numberBitSet.set(startingPoint, end);
        }
        startingPoint = end - 1;
        return startingPoint;
    }

    int handleComments(String line, BitSet commentBitSet, int startingPoint, boolean isSql) {
        Set<String> oneLineComments = isSql ? this.sqlLine.getDialect().getOneLineComments() : this.sqlLine.getDialect().getSqlLineOneLineComments();
        char ch = line.charAt(startingPoint);
        if (startingPoint + 1 < line.length() && ch == '/' && line.charAt(startingPoint + 1) == '*') {
            int end = line.indexOf("*/", startingPoint);
            end = end == -1 ? line.length() - 1 : end + 1;
            commentBitSet.set(startingPoint, end + 1);
            startingPoint = end;
        } else {
            for (String oneLineComment : oneLineComments) {
                if (startingPoint > line.length() - oneLineComment.length() || !oneLineComment.regionMatches(0, line, startingPoint, oneLineComment.length())) continue;
                int end = line.indexOf(10, startingPoint);
                end = end == -1 ? line.length() - 1 : end;
                commentBitSet.set(startingPoint, end + 1);
                startingPoint = end;
            }
        }
        return startingPoint;
    }

    int handleSqlSingleQuotes(String line, BitSet quoteBitSet, int startingPoint) {
        int end;
        int quoteCounter = 1;
        boolean quotationEnded = false;
        do {
            if ((end = line.indexOf(39, startingPoint + 1)) > -1) {
                ++quoteCounter;
            }
            if (end == -1 || end == line.length() - 1) {
                quoteBitSet.set(startingPoint, line.length());
                quotationEnded = true;
            } else if (line.charAt(end + 1) != '\'' && quoteCounter % 2 == 0) {
                quotationEnded = true;
            }
            end = end == -1 ? line.length() - 1 : end;
            quoteBitSet.set(startingPoint, end + 1);
            startingPoint = end;
        } while (!quotationEnded && end < line.length());
        return startingPoint;
    }
}

