/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import sqlline.DatabaseMetaDataWrapper;
import sqlline.Dialect;
import sqlline.DialectImpl;
import sqlline.DispatchCallback;
import sqlline.SqlCompleter;
import sqlline.SqlLine;

class DatabaseConnection {
    private final SqlLine sqlLine;
    Connection connection;
    DatabaseMetaDataWrapper meta;
    private final String driver;
    private final String url;
    private final Properties info;
    private String nickname;
    private Schema schema = null;
    private Completer sqlCompleter = null;
    private Dialect dialect;

    DatabaseConnection(SqlLine sqlLine, String driver, String url, String username, String password, Properties properties) {
        this.sqlLine = sqlLine;
        this.driver = driver;
        this.url = url;
        this.info = properties == null ? new Properties() : properties;
        this.info.put("user", username);
        this.info.put("password", password);
    }

    public String toString() {
        return this.getUrl() + "";
    }

    void setCompletions(boolean skipmeta) {
        this.sqlCompleter = new ArgumentCompleter(new Completer[]{new SqlCompleter(this.sqlLine, skipmeta)});
        ((ArgumentCompleter)this.sqlCompleter).setStrict(false);
    }

    private void initSyntaxRule() throws SQLException {
        String identifierQuoteString = this.meta.getIdentifierQuoteString();
        if (identifierQuoteString.length() > 1) {
            this.sqlLine.error("Identifier quote string is '" + identifierQuoteString + "'; quote strings longer than 1 char are not supported");
            identifierQuoteString = null;
        }
        String productName = this.meta.getDatabaseProductName();
        Set<String> keywords = Stream.of(this.meta.getSQLKeywords().split(",")).collect(Collectors.toSet());
        this.dialect = DialectImpl.create(keywords, identifierQuoteString, productName, this.meta.storesUpperCaseIdentifiers());
    }

    boolean connect() throws SQLException {
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.sqlLine.error(cnfe);
        }
        boolean foundDriver = false;
        Driver theDriver = null;
        try {
            theDriver = DriverManager.getDriver(this.url);
            foundDriver = theDriver != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!foundDriver) {
            this.sqlLine.output(this.sqlLine.loc("autoloading-known-drivers", this.url));
            this.sqlLine.registerKnownDrivers();
            theDriver = DriverManager.getDriver(this.url);
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.sqlLine.error(e);
        }
        this.connection = theDriver.connect(this.url, this.info);
        this.meta = new DatabaseMetaDataWrapper(this.sqlLine, this.connection.getMetaData());
        try {
            this.sqlLine.debug(this.sqlLine.loc("connected", this.meta.getDatabaseProductName(), this.meta.getDatabaseProductVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.debug(this.sqlLine.loc("driver", this.meta.getDriverName(), this.meta.getDriverVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.connection.setAutoCommit(this.sqlLine.getOpts().getAutoCommit());
            this.sqlLine.autocommitStatus(this.connection);
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.getCommands().isolation("isolation: " + this.sqlLine.getOpts().getIsolation(), new DispatchCallback());
            this.initSyntaxRule();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.showWarnings();
        return true;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        return this.connection;
    }

    public void reconnect() throws Exception {
        this.close();
        this.getConnection();
    }

    public void close() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.sqlLine.output(this.sqlLine.loc("closing", this.connection.getClass().getName()));
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.sqlLine.handleException(e);
            }
        }
        finally {
            this.connection = null;
            this.meta = null;
        }
    }

    public Collection<String> getTableNames(boolean force) {
        TreeSet<String> names = new TreeSet<String>();
        for (Schema.Table table : this.getSchema().getTables()) {
            names.add(table.getName());
        }
        return names;
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    DatabaseMetaDataWrapper getDatabaseMetaData() {
        return this.meta;
    }

    String getUrl() {
        return this.url;
    }

    String getNickname() {
        return this.nickname;
    }

    void setNickname(String nickname) {
        this.nickname = nickname;
    }

    Completer getSqlCompleter() {
        return this.sqlCompleter;
    }

    Dialect getDialect() {
        return this.dialect;
    }

    String getCurrentSchema() {
        try {
            return this.connection.getSchema();
        }
        catch (Exception e) {
            return null;
        }
    }

    class Schema {
        private List<Table> tables;

        Schema() {
        }

        List<Table> getTables() {
            if (this.tables != null) {
                return this.tables;
            }
            this.tables = new LinkedList<Table>();
            try {
                ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
                try {
                    while (rs.next()) {
                        this.tables.add(new Table(rs.getString("TABLE_NAME")));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.tables;
        }

        Table getTable(String name) {
            for (Table table : this.getTables()) {
                if (!name.equalsIgnoreCase(table.getName())) continue;
                return table;
            }
            return null;
        }

        class Table {
            final String name;
            Column[] columns;

            Table(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            class Column {
                final String name;
                boolean isPrimaryKey;

                Column(String name) {
                    this.name = name;
                }
            }
        }
    }
}

