
package org.apache.drill.exec.store;

import com.google.common.collect.Lists;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.EventBasedRecordWriter.FieldConverter;
import org.apache.drill.exec.vector.*;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

import java.io.IOException;
import java.lang.UnsupportedOperationException;
import java.util.List;
import java.util.Map;

/**
 * Abstract implementation of RecordWriter interface which exposes interface:
 *    {@link #writeHeader(List)}
 *    {@link #addField(int,String)}
 * to output the data in string format instead of implementing addField for each type holder.
 *
 * This is useful for text format writers such as CSV, TSV etc.
 *
 * NB: Source code generated using FreeMarker template StringOutputRecordWriter.java
 */
public abstract class StringOutputRecordWriter extends AbstractRecordWriter {

  private final BufferAllocator allocator;
  protected StringOutputRecordWriter(BufferAllocator allocator){
    this.allocator = allocator;
  }

  @Override
  public void updateSchema(VectorAccessible batch) throws IOException {
    BatchSchema schema = batch.getSchema();
    List<String> columnNames = Lists.newArrayList();
    for (int i=0; i < schema.getFieldCount(); i++) {
      columnNames.add(schema.getColumn(i).getName());
    }

    startNewSchema(columnNames);
  }

  @Override
  public FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException();
  }
  public FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException();
  }
  public FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException();
  }

  @Override
  public FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableTinyIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableTinyIntStringFieldConverter extends FieldConverter {
    private NullableTinyIntHolder holder = new NullableTinyIntHolder();

    public NullableTinyIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new TinyIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class TinyIntStringFieldConverter extends FieldConverter {
    private NullableTinyIntHolder holder = new NullableTinyIntHolder();

    public TinyIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedTinyIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedTinyIntStringFieldConverter extends FieldConverter {
    private RepeatedTinyIntHolder holder = new RepeatedTinyIntHolder();

    public RepeatedTinyIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableUInt1StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableUInt1StringFieldConverter extends FieldConverter {
    private NullableUInt1Holder holder = new NullableUInt1Holder();

    public NullableUInt1StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    return new UInt1StringFieldConverter(fieldId, fieldName, reader);
  }

  public class UInt1StringFieldConverter extends FieldConverter {
    private NullableUInt1Holder holder = new NullableUInt1Holder();

    public UInt1StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedUInt1StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedUInt1StringFieldConverter extends FieldConverter {
    private RepeatedUInt1Holder holder = new RepeatedUInt1Holder();

    public RepeatedUInt1StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableUInt2StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableUInt2StringFieldConverter extends FieldConverter {
    private NullableUInt2Holder holder = new NullableUInt2Holder();

    public NullableUInt2StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    return new UInt2StringFieldConverter(fieldId, fieldName, reader);
  }

  public class UInt2StringFieldConverter extends FieldConverter {
    private NullableUInt2Holder holder = new NullableUInt2Holder();

    public UInt2StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedUInt2StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedUInt2StringFieldConverter extends FieldConverter {
    private RepeatedUInt2Holder holder = new RepeatedUInt2Holder();

    public RepeatedUInt2StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableSmallIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableSmallIntStringFieldConverter extends FieldConverter {
    private NullableSmallIntHolder holder = new NullableSmallIntHolder();

    public NullableSmallIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new SmallIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class SmallIntStringFieldConverter extends FieldConverter {
    private NullableSmallIntHolder holder = new NullableSmallIntHolder();

    public SmallIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedSmallIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedSmallIntStringFieldConverter extends FieldConverter {
    private RepeatedSmallIntHolder holder = new RepeatedSmallIntHolder();

    public RepeatedSmallIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableIntStringFieldConverter extends FieldConverter {
    private NullableIntHolder holder = new NullableIntHolder();

    public NullableIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new IntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class IntStringFieldConverter extends FieldConverter {
    private NullableIntHolder holder = new NullableIntHolder();

    public IntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedIntStringFieldConverter extends FieldConverter {
    private RepeatedIntHolder holder = new RepeatedIntHolder();

    public RepeatedIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableUInt4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableUInt4StringFieldConverter extends FieldConverter {
    private NullableUInt4Holder holder = new NullableUInt4Holder();

    public NullableUInt4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new UInt4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class UInt4StringFieldConverter extends FieldConverter {
    private NullableUInt4Holder holder = new NullableUInt4Holder();

    public UInt4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedUInt4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedUInt4StringFieldConverter extends FieldConverter {
    private RepeatedUInt4Holder holder = new RepeatedUInt4Holder();

    public RepeatedUInt4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableFloat4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableFloat4StringFieldConverter extends FieldConverter {
    private NullableFloat4Holder holder = new NullableFloat4Holder();

    public NullableFloat4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new Float4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class Float4StringFieldConverter extends FieldConverter {
    private NullableFloat4Holder holder = new NullableFloat4Holder();

    public Float4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedFloat4StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedFloat4StringFieldConverter extends FieldConverter {
    private RepeatedFloat4Holder holder = new RepeatedFloat4Holder();

    public RepeatedFloat4StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableTimeStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableTimeStringFieldConverter extends FieldConverter {
    private NullableTimeHolder holder = new NullableTimeHolder();

    public NullableTimeStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    return new TimeStringFieldConverter(fieldId, fieldName, reader);
  }

  public class TimeStringFieldConverter extends FieldConverter {
    private NullableTimeHolder holder = new NullableTimeHolder();

    public TimeStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedTimeStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedTimeStringFieldConverter extends FieldConverter {
    private RepeatedTimeHolder holder = new RepeatedTimeHolder();

    public RepeatedTimeStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableIntervalYearStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableIntervalYearStringFieldConverter extends FieldConverter {
    private NullableIntervalYearHolder holder = new NullableIntervalYearHolder();

    public NullableIntervalYearStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    return new IntervalYearStringFieldConverter(fieldId, fieldName, reader);
  }

  public class IntervalYearStringFieldConverter extends FieldConverter {
    private NullableIntervalYearHolder holder = new NullableIntervalYearHolder();

    public IntervalYearStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedIntervalYearStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedIntervalYearStringFieldConverter extends FieldConverter {
    private RepeatedIntervalYearHolder holder = new RepeatedIntervalYearHolder();

    public RepeatedIntervalYearStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal9StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal9StringFieldConverter extends FieldConverter {
    private NullableDecimal9Holder holder = new NullableDecimal9Holder();

    public NullableDecimal9StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal9StringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal9StringFieldConverter extends FieldConverter {
    private NullableDecimal9Holder holder = new NullableDecimal9Holder();

    public Decimal9StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal9StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal9StringFieldConverter extends FieldConverter {
    private RepeatedDecimal9Holder holder = new RepeatedDecimal9Holder();

    public RepeatedDecimal9StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableBigIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableBigIntStringFieldConverter extends FieldConverter {
    private NullableBigIntHolder holder = new NullableBigIntHolder();

    public NullableBigIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new BigIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class BigIntStringFieldConverter extends FieldConverter {
    private NullableBigIntHolder holder = new NullableBigIntHolder();

    public BigIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedBigIntStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedBigIntStringFieldConverter extends FieldConverter {
    private RepeatedBigIntHolder holder = new RepeatedBigIntHolder();

    public RepeatedBigIntStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableUInt8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableUInt8StringFieldConverter extends FieldConverter {
    private NullableUInt8Holder holder = new NullableUInt8Holder();

    public NullableUInt8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new UInt8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class UInt8StringFieldConverter extends FieldConverter {
    private NullableUInt8Holder holder = new NullableUInt8Holder();

    public UInt8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedUInt8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedUInt8StringFieldConverter extends FieldConverter {
    private RepeatedUInt8Holder holder = new RepeatedUInt8Holder();

    public RepeatedUInt8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableFloat8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableFloat8StringFieldConverter extends FieldConverter {
    private NullableFloat8Holder holder = new NullableFloat8Holder();

    public NullableFloat8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new Float8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class Float8StringFieldConverter extends FieldConverter {
    private NullableFloat8Holder holder = new NullableFloat8Holder();

    public Float8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, String.valueOf(holder.value));
    }
  }
  @Override
  public FieldConverter getNewRepeatedFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedFloat8StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedFloat8StringFieldConverter extends FieldConverter {
    private RepeatedFloat8Holder holder = new RepeatedFloat8Holder();

    public RepeatedFloat8StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDateStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDateStringFieldConverter extends FieldConverter {
    private NullableDateHolder holder = new NullableDateHolder();

    public NullableDateStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
    return new DateStringFieldConverter(fieldId, fieldName, reader);
  }

  public class DateStringFieldConverter extends FieldConverter {
    private NullableDateHolder holder = new NullableDateHolder();

    public DateStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDateConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDateStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDateStringFieldConverter extends FieldConverter {
    private RepeatedDateHolder holder = new RepeatedDateHolder();

    public RepeatedDateStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableTimeStampStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableTimeStampStringFieldConverter extends FieldConverter {
    private NullableTimeStampHolder holder = new NullableTimeStampHolder();

    public NullableTimeStampStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    return new TimeStampStringFieldConverter(fieldId, fieldName, reader);
  }

  public class TimeStampStringFieldConverter extends FieldConverter {
    private NullableTimeStampHolder holder = new NullableTimeStampHolder();

    public TimeStampStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedTimeStampStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedTimeStampStringFieldConverter extends FieldConverter {
    private RepeatedTimeStampHolder holder = new RepeatedTimeStampHolder();

    public RepeatedTimeStampStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal18StringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal18StringFieldConverter extends FieldConverter {
    private NullableDecimal18Holder holder = new NullableDecimal18Holder();

    public NullableDecimal18StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal18StringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal18StringFieldConverter extends FieldConverter {
    private NullableDecimal18Holder holder = new NullableDecimal18Holder();

    public Decimal18StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal18StringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal18StringFieldConverter extends FieldConverter {
    private RepeatedDecimal18Holder holder = new RepeatedDecimal18Holder();

    public RepeatedDecimal18StringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableIntervalDayStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableIntervalDayStringFieldConverter extends FieldConverter {
    private NullableIntervalDayHolder holder = new NullableIntervalDayHolder();

    public NullableIntervalDayStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    return new IntervalDayStringFieldConverter(fieldId, fieldName, reader);
  }

  public class IntervalDayStringFieldConverter extends FieldConverter {
    private NullableIntervalDayHolder holder = new NullableIntervalDayHolder();

    public IntervalDayStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedIntervalDayStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedIntervalDayStringFieldConverter extends FieldConverter {
    private RepeatedIntervalDayHolder holder = new RepeatedIntervalDayHolder();

    public RepeatedIntervalDayStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableIntervalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableIntervalStringFieldConverter extends FieldConverter {
    private NullableIntervalHolder holder = new NullableIntervalHolder();

    public NullableIntervalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new IntervalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class IntervalStringFieldConverter extends FieldConverter {
    private NullableIntervalHolder holder = new NullableIntervalHolder();

    public IntervalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedIntervalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedIntervalStringFieldConverter extends FieldConverter {
    private RepeatedIntervalHolder holder = new RepeatedIntervalHolder();

    public RepeatedIntervalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal28DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal28DenseStringFieldConverter extends FieldConverter {
    private NullableDecimal28DenseHolder holder = new NullableDecimal28DenseHolder();

    public NullableDecimal28DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal28DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal28DenseStringFieldConverter extends FieldConverter {
    private NullableDecimal28DenseHolder holder = new NullableDecimal28DenseHolder();

    public Decimal28DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal28DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal28DenseStringFieldConverter extends FieldConverter {
    private RepeatedDecimal28DenseHolder holder = new RepeatedDecimal28DenseHolder();

    public RepeatedDecimal28DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal38DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal38DenseStringFieldConverter extends FieldConverter {
    private NullableDecimal38DenseHolder holder = new NullableDecimal38DenseHolder();

    public NullableDecimal38DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal38DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal38DenseStringFieldConverter extends FieldConverter {
    private NullableDecimal38DenseHolder holder = new NullableDecimal38DenseHolder();

    public Decimal38DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal38DenseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal38DenseStringFieldConverter extends FieldConverter {
    private RepeatedDecimal38DenseHolder holder = new RepeatedDecimal38DenseHolder();

    public RepeatedDecimal38DenseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal38SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal38SparseStringFieldConverter extends FieldConverter {
    private NullableDecimal38SparseHolder holder = new NullableDecimal38SparseHolder();

    public NullableDecimal38SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal38SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal38SparseStringFieldConverter extends FieldConverter {
    private NullableDecimal38SparseHolder holder = new NullableDecimal38SparseHolder();

    public Decimal38SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal38SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal38SparseStringFieldConverter extends FieldConverter {
    private RepeatedDecimal38SparseHolder holder = new RepeatedDecimal38SparseHolder();

    public RepeatedDecimal38SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableDecimal28SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableDecimal28SparseStringFieldConverter extends FieldConverter {
    private NullableDecimal28SparseHolder holder = new NullableDecimal28SparseHolder();

    public NullableDecimal28SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new Decimal28SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class Decimal28SparseStringFieldConverter extends FieldConverter {
    private NullableDecimal28SparseHolder holder = new NullableDecimal28SparseHolder();

    public Decimal28SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedDecimal28SparseStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedDecimal28SparseStringFieldConverter extends FieldConverter {
    private RepeatedDecimal28SparseHolder holder = new RepeatedDecimal28SparseHolder();

    public RepeatedDecimal28SparseStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableVarBinaryStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableVarBinaryStringFieldConverter extends FieldConverter {
    private NullableVarBinaryHolder holder = new NullableVarBinaryHolder();

    public NullableVarBinaryStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    return new VarBinaryStringFieldConverter(fieldId, fieldName, reader);
  }

  public class VarBinaryStringFieldConverter extends FieldConverter {
    private NullableVarBinaryHolder holder = new NullableVarBinaryHolder();

    public VarBinaryStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedVarBinaryStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedVarBinaryStringFieldConverter extends FieldConverter {
    private RepeatedVarBinaryHolder holder = new RepeatedVarBinaryHolder();

    public RepeatedVarBinaryStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableVarCharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableVarCharStringFieldConverter extends FieldConverter {
    private NullableVarCharHolder holder = new NullableVarCharHolder();

    public NullableVarCharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new VarCharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class VarCharStringFieldConverter extends FieldConverter {
    private NullableVarCharHolder holder = new NullableVarCharHolder();

    public VarCharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedVarCharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedVarCharStringFieldConverter extends FieldConverter {
    private RepeatedVarCharHolder holder = new RepeatedVarCharHolder();

    public RepeatedVarCharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableVar16CharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableVar16CharStringFieldConverter extends FieldConverter {
    private NullableVar16CharHolder holder = new NullableVar16CharHolder();

    public NullableVar16CharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new Var16CharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class Var16CharStringFieldConverter extends FieldConverter {
    private NullableVar16CharHolder holder = new NullableVar16CharHolder();

    public Var16CharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedVar16CharStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedVar16CharStringFieldConverter extends FieldConverter {
    private RepeatedVar16CharHolder holder = new RepeatedVar16CharHolder();

    public RepeatedVar16CharStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableVarDecimalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableVarDecimalStringFieldConverter extends FieldConverter {
    private NullableVarDecimalHolder holder = new NullableVarDecimalHolder();

    public NullableVarDecimalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new VarDecimalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class VarDecimalStringFieldConverter extends FieldConverter {
    private NullableVarDecimalHolder holder = new NullableVarDecimalHolder();

    public VarDecimalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    // TODO: error check
    addField(fieldId, reader.readObject().toString());
    }
  }
  @Override
  public FieldConverter getNewRepeatedVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedVarDecimalStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedVarDecimalStringFieldConverter extends FieldConverter {
    private RepeatedVarDecimalHolder holder = new RepeatedVarDecimalHolder();

    public RepeatedVarDecimalStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }
  @Override
  public FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
    return new NullableBitStringFieldConverter(fieldId, fieldName, reader);
  }

  public class NullableBitStringFieldConverter extends FieldConverter {
    private NullableBitHolder holder = new NullableBitHolder();

    public NullableBitStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    if (!reader.isSet()) {
      addField(fieldId, null);
      return;
    }

    reader.read(holder);
    addField(fieldId, holder.value == 0 ? "false" : "true");
    }
  }
  @Override
  public FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
    return new BitStringFieldConverter(fieldId, fieldName, reader);
  }

  public class BitStringFieldConverter extends FieldConverter {
    private NullableBitHolder holder = new NullableBitHolder();

    public BitStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {

    reader.read(holder);
    addField(fieldId, holder.value == 0 ? "false" : "true");
    }
  }
  @Override
  public FieldConverter getNewRepeatedBitConverter(int fieldId, String fieldName, FieldReader reader) {
    return new RepeatedBitStringFieldConverter(fieldId, fieldName, reader);
  }

  public class RepeatedBitStringFieldConverter extends FieldConverter {
    private RepeatedBitHolder holder = new RepeatedBitHolder();

    public RepeatedBitStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
      super(fieldId, fieldName, reader);
    }

    @Override
    public void writeField() throws IOException {
    throw new UnsupportedOperationException("Repeated types are not supported.");
    }
  }

  public void cleanup() throws IOException {
  }

  public abstract void startNewSchema(List<String> columnNames) throws IOException;
  public abstract void addField(int fieldId, String value) throws IOException;
}
