

/*
 * This class is generated using freemarker and the AggrTypeFunctions1.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class AnyValueFunctions {


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class BitAnyValue implements DrillAggFunc {
    @Param BitHolder in;
    @Workspace BitHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableBitHolder out;

    public void setup() {
      value = new BitHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class IntAnyValue implements DrillAggFunc {
    @Param IntHolder in;
    @Workspace IntHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableIntHolder out;

    public void setup() {
      value = new IntHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class BigIntAnyValue implements DrillAggFunc {
    @Param BigIntHolder in;
    @Workspace BigIntHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableBigIntHolder out;

    public void setup() {
      value = new BigIntHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableBitAnyValue implements DrillAggFunc {
    @Param NullableBitHolder in;
    @Workspace BitHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableBitHolder out;

    public void setup() {
      value = new BitHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableIntAnyValue implements DrillAggFunc {
    @Param NullableIntHolder in;
    @Workspace IntHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableIntHolder out;

    public void setup() {
      value = new IntHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableBigIntAnyValue implements DrillAggFunc {
    @Param NullableBigIntHolder in;
    @Workspace BigIntHolder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableBigIntHolder out;

    public void setup() {
      value = new BigIntHolder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Float4AnyValue implements DrillAggFunc {
    @Param Float4Holder in;
    @Workspace Float4Holder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableFloat4Holder out;

    public void setup() {
      value = new Float4Holder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Float8AnyValue implements DrillAggFunc {
    @Param Float8Holder in;
    @Workspace Float8Holder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableFloat8Holder out;

    public void setup() {
      value = new Float8Holder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableFloat4AnyValue implements DrillAggFunc {
    @Param NullableFloat4Holder in;
    @Workspace Float4Holder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableFloat4Holder out;

    public void setup() {
      value = new Float4Holder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }


  @FunctionTemplate(name = "any_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableFloat8AnyValue implements DrillAggFunc {
    @Param NullableFloat8Holder in;
    @Workspace Float8Holder value;
    @Workspace BigIntHolder nonNullCount;
    @Output NullableFloat8Holder out;

    public void setup() {
      value = new Float8Holder();
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
      value.value = 0;
    }

    @Override
    public void add() {
        sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
        nonNullCount.value = 1;
        // For min/max functions: NaN is the biggest value,
        // Infinity is the second biggest value
        // -Infinity is the smallest value
        value.value = in.value;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
      value.value = 0;
    }
  }

}
