

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/SqlToDateTypeFunctions.java template.
 */

@FunctionTemplate(name = "sql_to_time",
                  scope = FunctionTemplate.FunctionScope.SIMPLE,
                  nulls = NullHandling.NULL_IF_NULL)
public class SqlToTime implements DrillSimpleFunc {

  @Param  VarCharHolder left;
  @Param  VarCharHolder right;
  @Workspace org.joda.time.format.DateTimeFormatter format;
  @Output TimeHolder out;

  public void setup() {
    // Get the desired output format
    String formatString = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(right);
    String pattern = org.apache.drill.common.expression.fn.JodaDateValidator.toJodaFormat(formatString);
    try {
      format = org.joda.time.format.DateTimeFormat.forPattern(pattern);
    } catch (IllegalArgumentException e) {
      throw org.apache.drill.common.exceptions.UserException.functionError(e)
        .message("Error parsing formatter %s in %s function", formatString, "sql_to_time")
        .build();
    }
  }

  public void eval() {
    // Get the input
    String input = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(left);
    try {
      out.value = (int) format.parseDateTime(input).withZoneRetainFields(org.joda.time.DateTimeZone.UTC).getMillis();
    } catch (IllegalArgumentException e) {
      throw org.apache.drill.common.exceptions.UserException.functionError(e)
        .message("Error parsing date-time %s in %s function", input, "sql_to_time")
        .build();
    }
  }
}
