

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
/*
 * This class is generated using freemarker and the ConvertToNullableHolder.java template.
 */

@FunctionTemplate(name = "convertToNullableDECIMAL28SPARSE",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
    nulls = FunctionTemplate.NullHandling.INTERNAL)
public class GConvertToNullableDecimal28SparseHolder implements DrillSimpleFunc {

  @Param Decimal28SparseHolder input;
  @Output NullableDecimal28SparseHolder output;

  public void setup() { }

  public void eval() {
    output.isSet = 1;
    output.scale = input.scale;
    output.precision = input.precision;
    output.setSign(input.getSign(input.start, input.buffer), output.start, output.buffer);
    output.start = input.start;
    output.buffer = input.buffer;
  }
}


