

package org.apache.drill.exec.expr;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;





import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos.DataMode;
import org.apache.drill.common.types.TypeProtos.MinorType;
import org.apache.drill.common.types.TypeProtos.MajorType;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.accessor.*;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.util.CallBack;

/*
 * This class is generated using freemarker and the TypeHelper.java template.
 */
public class TypeHelper extends BasicTypeHelper {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(TypeHelper.class);

  public static SqlAccessor getSqlAccessor(ValueVector vector){
    final MajorType type = vector.getField().getType();
    switch(type.getMinorType()){
    case UNION:
      return new UnionSqlAccessor((UnionVector) vector);
    case TINYINT:
      switch (type.getMode()) {
        case REQUIRED:
          return new TinyIntAccessor((TinyIntVector) vector);
        case OPTIONAL:
          return new NullableTinyIntAccessor((NullableTinyIntVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case UINT1:
      switch (type.getMode()) {
        case REQUIRED:
          return new UInt1Accessor((UInt1Vector) vector);
        case OPTIONAL:
          return new NullableUInt1Accessor((NullableUInt1Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case UINT2:
      switch (type.getMode()) {
        case REQUIRED:
          return new UInt2Accessor((UInt2Vector) vector);
        case OPTIONAL:
          return new NullableUInt2Accessor((NullableUInt2Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case SMALLINT:
      switch (type.getMode()) {
        case REQUIRED:
          return new SmallIntAccessor((SmallIntVector) vector);
        case OPTIONAL:
          return new NullableSmallIntAccessor((NullableSmallIntVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case INT:
      switch (type.getMode()) {
        case REQUIRED:
          return new IntAccessor((IntVector) vector);
        case OPTIONAL:
          return new NullableIntAccessor((NullableIntVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case UINT4:
      switch (type.getMode()) {
        case REQUIRED:
          return new UInt4Accessor((UInt4Vector) vector);
        case OPTIONAL:
          return new NullableUInt4Accessor((NullableUInt4Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case FLOAT4:
      switch (type.getMode()) {
        case REQUIRED:
          return new Float4Accessor((Float4Vector) vector);
        case OPTIONAL:
          return new NullableFloat4Accessor((NullableFloat4Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case TIME:
      switch (type.getMode()) {
        case REQUIRED:
          return new TimeAccessor((TimeVector) vector);
        case OPTIONAL:
          return new NullableTimeAccessor((NullableTimeVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case INTERVALYEAR:
      switch (type.getMode()) {
        case REQUIRED:
          return new IntervalYearAccessor((IntervalYearVector) vector);
        case OPTIONAL:
          return new NullableIntervalYearAccessor((NullableIntervalYearVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL9:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal9Accessor((Decimal9Vector) vector);
        case OPTIONAL:
          return new NullableDecimal9Accessor((NullableDecimal9Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case BIGINT:
      switch (type.getMode()) {
        case REQUIRED:
          return new BigIntAccessor((BigIntVector) vector);
        case OPTIONAL:
          return new NullableBigIntAccessor((NullableBigIntVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case UINT8:
      switch (type.getMode()) {
        case REQUIRED:
          return new UInt8Accessor((UInt8Vector) vector);
        case OPTIONAL:
          return new NullableUInt8Accessor((NullableUInt8Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case FLOAT8:
      switch (type.getMode()) {
        case REQUIRED:
          return new Float8Accessor((Float8Vector) vector);
        case OPTIONAL:
          return new NullableFloat8Accessor((NullableFloat8Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DATE:
      switch (type.getMode()) {
        case REQUIRED:
          return new DateAccessor((DateVector) vector);
        case OPTIONAL:
          return new NullableDateAccessor((NullableDateVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case TIMESTAMP:
      switch (type.getMode()) {
        case REQUIRED:
          return new TimeStampAccessor((TimeStampVector) vector);
        case OPTIONAL:
          return new NullableTimeStampAccessor((NullableTimeStampVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL18:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal18Accessor((Decimal18Vector) vector);
        case OPTIONAL:
          return new NullableDecimal18Accessor((NullableDecimal18Vector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case INTERVALDAY:
      switch (type.getMode()) {
        case REQUIRED:
          return new IntervalDayAccessor((IntervalDayVector) vector);
        case OPTIONAL:
          return new NullableIntervalDayAccessor((NullableIntervalDayVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case INTERVAL:
      switch (type.getMode()) {
        case REQUIRED:
          return new IntervalAccessor((IntervalVector) vector);
        case OPTIONAL:
          return new NullableIntervalAccessor((NullableIntervalVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL28DENSE:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal28DenseAccessor((Decimal28DenseVector) vector);
        case OPTIONAL:
          return new NullableDecimal28DenseAccessor((NullableDecimal28DenseVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL38DENSE:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal38DenseAccessor((Decimal38DenseVector) vector);
        case OPTIONAL:
          return new NullableDecimal38DenseAccessor((NullableDecimal38DenseVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL38SPARSE:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal38SparseAccessor((Decimal38SparseVector) vector);
        case OPTIONAL:
          return new NullableDecimal38SparseAccessor((NullableDecimal38SparseVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case DECIMAL28SPARSE:
      switch (type.getMode()) {
        case REQUIRED:
          return new Decimal28SparseAccessor((Decimal28SparseVector) vector);
        case OPTIONAL:
          return new NullableDecimal28SparseAccessor((NullableDecimal28SparseVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case VARBINARY:
      switch (type.getMode()) {
        case REQUIRED:
          return new VarBinaryAccessor((VarBinaryVector) vector);
        case OPTIONAL:
          return new NullableVarBinaryAccessor((NullableVarBinaryVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case VARCHAR:
      switch (type.getMode()) {
        case REQUIRED:
          return new VarCharAccessor((VarCharVector) vector);
        case OPTIONAL:
          return new NullableVarCharAccessor((NullableVarCharVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case VAR16CHAR:
      switch (type.getMode()) {
        case REQUIRED:
          return new Var16CharAccessor((Var16CharVector) vector);
        case OPTIONAL:
          return new NullableVar16CharAccessor((NullableVar16CharVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case VARDECIMAL:
      switch (type.getMode()) {
        case REQUIRED:
          return new VarDecimalAccessor((VarDecimalVector) vector);
        case OPTIONAL:
          return new NullableVarDecimalAccessor((NullableVarDecimalVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case BIT:
      switch (type.getMode()) {
        case REQUIRED:
          return new BitAccessor((BitVector) vector);
        case OPTIONAL:
          return new NullableBitAccessor((NullableBitVector) vector);
        case REPEATED:
          return new GenericAccessor(vector);
      }
    case MAP:
    case LIST:
    case NULL:
      return new GenericAccessor(vector);
    }
    throw new UnsupportedOperationException(buildErrorMessage("find sql accessor", type));
  }
  
  public static JType getHolderType(JCodeModel model, MinorType type, DataMode mode){
    switch (type) {
    case UNION:
      return model._ref(UnionHolder.class);
    case MAP:
    case LIST:
      return model._ref(ComplexHolder.class);
      
      case TINYINT:
        switch (mode) {
          case REQUIRED:
            return model._ref(TinyIntHolder.class);
          case OPTIONAL:
            return model._ref(NullableTinyIntHolder.class);
          case REPEATED:
            return model._ref(RepeatedTinyIntHolder.class);
        }
      case UINT1:
        switch (mode) {
          case REQUIRED:
            return model._ref(UInt1Holder.class);
          case OPTIONAL:
            return model._ref(NullableUInt1Holder.class);
          case REPEATED:
            return model._ref(RepeatedUInt1Holder.class);
        }
      case UINT2:
        switch (mode) {
          case REQUIRED:
            return model._ref(UInt2Holder.class);
          case OPTIONAL:
            return model._ref(NullableUInt2Holder.class);
          case REPEATED:
            return model._ref(RepeatedUInt2Holder.class);
        }
      case SMALLINT:
        switch (mode) {
          case REQUIRED:
            return model._ref(SmallIntHolder.class);
          case OPTIONAL:
            return model._ref(NullableSmallIntHolder.class);
          case REPEATED:
            return model._ref(RepeatedSmallIntHolder.class);
        }
      case INT:
        switch (mode) {
          case REQUIRED:
            return model._ref(IntHolder.class);
          case OPTIONAL:
            return model._ref(NullableIntHolder.class);
          case REPEATED:
            return model._ref(RepeatedIntHolder.class);
        }
      case UINT4:
        switch (mode) {
          case REQUIRED:
            return model._ref(UInt4Holder.class);
          case OPTIONAL:
            return model._ref(NullableUInt4Holder.class);
          case REPEATED:
            return model._ref(RepeatedUInt4Holder.class);
        }
      case FLOAT4:
        switch (mode) {
          case REQUIRED:
            return model._ref(Float4Holder.class);
          case OPTIONAL:
            return model._ref(NullableFloat4Holder.class);
          case REPEATED:
            return model._ref(RepeatedFloat4Holder.class);
        }
      case TIME:
        switch (mode) {
          case REQUIRED:
            return model._ref(TimeHolder.class);
          case OPTIONAL:
            return model._ref(NullableTimeHolder.class);
          case REPEATED:
            return model._ref(RepeatedTimeHolder.class);
        }
      case INTERVALYEAR:
        switch (mode) {
          case REQUIRED:
            return model._ref(IntervalYearHolder.class);
          case OPTIONAL:
            return model._ref(NullableIntervalYearHolder.class);
          case REPEATED:
            return model._ref(RepeatedIntervalYearHolder.class);
        }
      case DECIMAL9:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal9Holder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal9Holder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal9Holder.class);
        }
      case BIGINT:
        switch (mode) {
          case REQUIRED:
            return model._ref(BigIntHolder.class);
          case OPTIONAL:
            return model._ref(NullableBigIntHolder.class);
          case REPEATED:
            return model._ref(RepeatedBigIntHolder.class);
        }
      case UINT8:
        switch (mode) {
          case REQUIRED:
            return model._ref(UInt8Holder.class);
          case OPTIONAL:
            return model._ref(NullableUInt8Holder.class);
          case REPEATED:
            return model._ref(RepeatedUInt8Holder.class);
        }
      case FLOAT8:
        switch (mode) {
          case REQUIRED:
            return model._ref(Float8Holder.class);
          case OPTIONAL:
            return model._ref(NullableFloat8Holder.class);
          case REPEATED:
            return model._ref(RepeatedFloat8Holder.class);
        }
      case DATE:
        switch (mode) {
          case REQUIRED:
            return model._ref(DateHolder.class);
          case OPTIONAL:
            return model._ref(NullableDateHolder.class);
          case REPEATED:
            return model._ref(RepeatedDateHolder.class);
        }
      case TIMESTAMP:
        switch (mode) {
          case REQUIRED:
            return model._ref(TimeStampHolder.class);
          case OPTIONAL:
            return model._ref(NullableTimeStampHolder.class);
          case REPEATED:
            return model._ref(RepeatedTimeStampHolder.class);
        }
      case DECIMAL18:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal18Holder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal18Holder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal18Holder.class);
        }
      case INTERVALDAY:
        switch (mode) {
          case REQUIRED:
            return model._ref(IntervalDayHolder.class);
          case OPTIONAL:
            return model._ref(NullableIntervalDayHolder.class);
          case REPEATED:
            return model._ref(RepeatedIntervalDayHolder.class);
        }
      case INTERVAL:
        switch (mode) {
          case REQUIRED:
            return model._ref(IntervalHolder.class);
          case OPTIONAL:
            return model._ref(NullableIntervalHolder.class);
          case REPEATED:
            return model._ref(RepeatedIntervalHolder.class);
        }
      case DECIMAL28DENSE:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal28DenseHolder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal28DenseHolder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal28DenseHolder.class);
        }
      case DECIMAL38DENSE:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal38DenseHolder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal38DenseHolder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal38DenseHolder.class);
        }
      case DECIMAL38SPARSE:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal38SparseHolder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal38SparseHolder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal38SparseHolder.class);
        }
      case DECIMAL28SPARSE:
        switch (mode) {
          case REQUIRED:
            return model._ref(Decimal28SparseHolder.class);
          case OPTIONAL:
            return model._ref(NullableDecimal28SparseHolder.class);
          case REPEATED:
            return model._ref(RepeatedDecimal28SparseHolder.class);
        }
      case VARBINARY:
        switch (mode) {
          case REQUIRED:
            return model._ref(VarBinaryHolder.class);
          case OPTIONAL:
            return model._ref(NullableVarBinaryHolder.class);
          case REPEATED:
            return model._ref(RepeatedVarBinaryHolder.class);
        }
      case VARCHAR:
        switch (mode) {
          case REQUIRED:
            return model._ref(VarCharHolder.class);
          case OPTIONAL:
            return model._ref(NullableVarCharHolder.class);
          case REPEATED:
            return model._ref(RepeatedVarCharHolder.class);
        }
      case VAR16CHAR:
        switch (mode) {
          case REQUIRED:
            return model._ref(Var16CharHolder.class);
          case OPTIONAL:
            return model._ref(NullableVar16CharHolder.class);
          case REPEATED:
            return model._ref(RepeatedVar16CharHolder.class);
        }
      case VARDECIMAL:
        switch (mode) {
          case REQUIRED:
            return model._ref(VarDecimalHolder.class);
          case OPTIONAL:
            return model._ref(NullableVarDecimalHolder.class);
          case REPEATED:
            return model._ref(RepeatedVarDecimalHolder.class);
        }
      case BIT:
        switch (mode) {
          case REQUIRED:
            return model._ref(BitHolder.class);
          case OPTIONAL:
            return model._ref(NullableBitHolder.class);
          case REPEATED:
            return model._ref(RepeatedBitHolder.class);
        }
      case GENERIC_OBJECT:
        return model._ref(ObjectHolder.class);
    case NULL:
      return model._ref(UntypedNullHolder.class);
      default:
        break;
      }
      throw new UnsupportedOperationException(buildErrorMessage("get holder type", type, mode));
  }

}
