/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.beans.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.beans.jackson.JacksonHelper;
import org.ojai.util.impl.ContainerContext;

@API.Internal
public class DocumentParser
extends ParserMinimalBase {
    protected final DocumentReader r;
    protected DocumentReader.EventType _currEventType;
    protected ObjectCodec _objectCodec;
    protected boolean _closed = false;
    protected LinkedList<JsonToken> tokens;
    protected Stack<ContainerContext> containerStack;

    public DocumentParser(DocumentReader dr) {
        this.r = dr;
        this.tokens = new LinkedList();
        this.containerStack = new Stack();
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public Version version() {
        return JacksonHelper.VERSION;
    }

    public void close() throws IOException {
        this._closed = true;
    }

    private void setCurrentArrayIndex() {
        ContainerContext currentContainer = this.containerStack.peek();
        int nullCount = this.r.getArrayIndex() - currentContainer.getIndex();
        for (int i = 1; i < nullCount; ++i) {
            this.tokens.add(JsonToken.VALUE_NULL);
        }
        currentContainer.incrementIndex();
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this.tokens.isEmpty() && (this._currEventType = this.r.next()) != null) {
            if (this._currEventType != DocumentReader.EventType.END_MAP && this._currEventType != DocumentReader.EventType.END_ARRAY) {
                if (this.r.inMap() && this.r.getFieldName() != null) {
                    this.tokens.add(JsonToken.FIELD_NAME);
                } else if (!this.r.inMap()) {
                    this.setCurrentArrayIndex();
                }
            }
            switch (this._currEventType) {
                case START_ARRAY: {
                    this.containerStack.push(new ContainerContext(Value.Type.ARRAY));
                    this.tokens.add(JsonToken.START_ARRAY);
                    break;
                }
                case END_ARRAY: {
                    if (!this.containerStack.empty()) {
                        this.containerStack.pop();
                    }
                    this.tokens.add(JsonToken.END_ARRAY);
                    break;
                }
                case START_MAP: {
                    this.containerStack.push(new ContainerContext(Value.Type.MAP));
                    this.tokens.add(JsonToken.START_OBJECT);
                    break;
                }
                case END_MAP: {
                    if (!this.containerStack.empty()) {
                        this.containerStack.pop();
                    }
                    this.tokens.add(JsonToken.END_OBJECT);
                    break;
                }
                case NULL: {
                    this.tokens.add(JsonToken.VALUE_NULL);
                    break;
                }
                case STRING: {
                    this.tokens.add(JsonToken.VALUE_STRING);
                    break;
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    this.tokens.add(JsonToken.VALUE_NUMBER_INT);
                    break;
                }
                case DECIMAL: 
                case DOUBLE: 
                case FLOAT: {
                    this.tokens.add(JsonToken.VALUE_NUMBER_FLOAT);
                    break;
                }
                case BOOLEAN: {
                    this.tokens.add(this.r.getBoolean() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
                    break;
                }
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case INTERVAL: 
                case BINARY: {
                    this.tokens.add(JsonToken.VALUE_EMBEDDED_OBJECT);
                }
            }
        }
        this._currToken = this.tokens.isEmpty() ? JsonToken.NOT_AVAILABLE : this.tokens.remove();
        return this._currToken;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public String getCurrentName() throws IOException {
        return this.r.getFieldName();
    }

    public JsonStreamContext getParsingContext() {
        return null;
    }

    public String getText() throws IOException {
        return this._currToken == JsonToken.FIELD_NAME ? this.r.getFieldName() : this.r.getString();
    }

    public Number getNumberValue() throws IOException {
        switch (this._currEventType) {
            case BYTE: {
                return this.r.getByte();
            }
            case SHORT: {
                return this.r.getShort();
            }
            case INT: {
                return this.r.getInt();
            }
            case LONG: {
                return this.r.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.r.getFloat());
            }
            case DOUBLE: {
                return this.r.getDouble();
            }
            case DECIMAL: {
                return this.r.getDecimal();
            }
        }
        throw new IllegalStateException("getNumberValue() called for event " + (Object)((Object)this._currEventType));
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        switch (this._currEventType) {
            case BYTE: 
            case SHORT: 
            case INT: {
                return JsonParser.NumberType.INT;
            }
            case LONG: {
                return JsonParser.NumberType.LONG;
            }
            case FLOAT: {
                return JsonParser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return JsonParser.NumberType.DOUBLE;
            }
            case DECIMAL: {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
        }
        throw new IllegalStateException("getNumberType() called for event " + (Object)((Object)this._currEventType));
    }

    public int getIntValue() throws IOException {
        return (int)this.getLongValue();
    }

    public long getLongValue() throws IOException {
        switch (this._currEventType) {
            case BYTE: {
                return this.r.getByte();
            }
            case SHORT: {
                return this.r.getShort();
            }
            case INT: {
                return this.r.getInt();
            }
            case LONG: {
                return this.r.getLong();
            }
            case FLOAT: {
                return (long)this.r.getFloat();
            }
            case DOUBLE: {
                return (long)this.r.getDouble();
            }
            case DECIMAL: {
                return this.r.getDecimal().longValue();
            }
        }
        throw new IllegalStateException("getLongValue() called for event " + (Object)((Object)this._currEventType));
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this.getDecimalValue().toBigInteger();
    }

    public float getFloatValue() throws IOException {
        return (float)this.getDoubleValue();
    }

    public double getDoubleValue() throws IOException {
        switch (this._currEventType) {
            case BYTE: {
                return this.r.getByte();
            }
            case SHORT: {
                return this.r.getShort();
            }
            case INT: {
                return this.r.getInt();
            }
            case LONG: {
                return this.r.getLong();
            }
            case FLOAT: {
                return this.r.getFloat();
            }
            case DOUBLE: {
                return this.r.getDouble();
            }
            case DECIMAL: {
                return this.r.getDecimal().doubleValue();
            }
        }
        throw new IllegalStateException("getDoubleValue() called for event " + (Object)((Object)this._currEventType));
    }

    public BigDecimal getDecimalValue() throws IOException {
        switch (this._currEventType) {
            case BYTE: {
                return new BigDecimal(this.r.getByte());
            }
            case SHORT: {
                return new BigDecimal(this.r.getShort());
            }
            case INT: {
                return new BigDecimal(this.r.getInt());
            }
            case LONG: {
                return new BigDecimal(this.r.getLong());
            }
            case FLOAT: {
                return new BigDecimal(this.r.getFloat());
            }
            case DOUBLE: {
                return new BigDecimal(this.r.getDouble());
            }
            case DECIMAL: {
                return this.r.getDecimal();
            }
        }
        throw new IllegalStateException("getDecimalValue() called for event " + (Object)((Object)this._currEventType));
    }

    public Object getEmbeddedObject() throws IOException {
        switch (this._currEventType) {
            case BINARY: {
                return this.r.getBinary();
            }
            case DATE: {
                return this.r.getDate();
            }
            case TIME: {
                return this.r.getTime();
            }
            case TIMESTAMP: {
                return this.r.getTimestamp();
            }
            case INTERVAL: {
                return this.r.getInterval();
            }
        }
        throw new IllegalStateException("getEmbeddedObject() called for event " + (Object)((Object)this._currEventType));
    }

    public byte[] getBinaryValue(Base64Variant bv) throws IOException {
        ByteBuffer buf = this.r.getBinary();
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        return result;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public char[] getTextCharacters() throws IOException {
        this.notImplemented();
        return null;
    }

    public int getTextLength() throws IOException {
        this.notImplemented();
        return 0;
    }

    public int getTextOffset() throws IOException {
        this.notImplemented();
        return 0;
    }

    public JsonLocation getTokenLocation() {
        this.notImplemented();
        return null;
    }

    public JsonLocation getCurrentLocation() {
        this.notImplemented();
        return null;
    }

    public void overrideCurrentName(String name) {
        this.notImplemented();
    }

    protected void _handleEOF() throws JsonParseException {
        this.notImplemented();
    }

    private void notImplemented() {
        throw new RuntimeException("Called operation not implemented for DocumentParser.");
    }
}

