/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.service;

import com.google.common.base.Preconditions;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.MapRDataGrpcService;
import com.mapr.web.security.WebSecurityManager;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ojai.Document;
import org.ojai.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    private static final String DEFAULT_PROCESS_NAME = "data-access-gateway";
    private static String processName = "data-access-gateway";
    private static final Document config = Json.newDocument();

    public static void main(String[] args) throws Exception {
        try {
            Launcher.parseArgs(args);
            WebSecurityManager.getSecurityManager((String)processName);
            if (!Configs.getBoolean((Document)config, (String)"auth.spoof.authenticator", (boolean)false)) {
                Launcher.configPAMAuth();
            }
            MapRDataGrpcService service = new MapRDataGrpcService(config);
            service.start();
            Signal.handle(new Signal("INT"), sig -> Launcher.shutDown(service));
            service.awaitTermination();
            logger.info("Service terminated.");
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            } else {
                logger.error(e.getMessage());
            }
            System.exit(e instanceof IllegalArgumentException ? 22 : 1);
        }
    }

    private static void configPAMAuth() {
        Configuration oldConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] maprLoginConf = oldConfig.getAppConfigurationEntry("jpamLogin");
        StringBuilder pamConfigFiles = new StringBuilder();
        for (AppConfigurationEntry entry : maprLoginConf) {
            if (!entry.getOptions().containsKey("serviceName")) continue;
            pamConfigFiles.append(",").append(entry.getOptions().get("serviceName"));
        }
        config.set("auth.pam.config.files", pamConfigFiles.substring(1));
    }

    private static void shutDown(MapRDataGrpcService service) {
        logger.info("Shutdown requested, initiating service termination.");
        service.stop();
    }

    private static void parseArgs(String[] args) {
        Preconditions.checkNotNull((Object)config);
        String currentArg = null;
        try {
            block17: for (int i = 0; i < args.length; ++i) {
                switch (currentArg = args[i]) {
                    case "-p": 
                    case "--port": {
                        int port = Integer.parseInt(args[++i]);
                        config.set("grpc.service.port", port);
                        continue block17;
                    }
                    case "--process": {
                        processName = args[++i];
                        continue block17;
                    }
                    case "--ssl": {
                        config.set("grpc.service.ssl.enabled", args[++i]);
                        continue block17;
                    }
                    case "--auth": {
                        config.set("grpc.service.auth.required", Boolean.valueOf(args[++i]).booleanValue());
                        continue block17;
                    }
                    case "--spoofauth": {
                        config.set("auth.spoof.authenticator", Boolean.valueOf(args[++i]).booleanValue());
                        continue block17;
                    }
                    default: {
                        if (currentArg.startsWith("-P")) {
                            String[] propKeyValue = currentArg.substring(2).split("=", 2);
                            String key = propKeyValue[0];
                            if (propKeyValue.length == 1) {
                                Launcher.illegalArgument("A value for the property `%s` wasn't specified.", key);
                            } else if (config.getValue(key) != null) {
                                Launcher.illegalArgument("The value for the property `%s` is already set to `%s`.", key, config.getValue(key));
                            }
                            config.set(key, propKeyValue[1]);
                            continue block17;
                        }
                        Launcher.illegalArgument("Unknown parameter `%s`.", currentArg);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Launcher.illegalArgument("The parameter `%s` requires a value.", currentArg);
        }
    }

    private static IllegalArgumentException illegalArgument(String format, Object ... args) {
        throw new IllegalArgumentException(String.format(format, args));
    }
}

