/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.fn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.types.TypeProtos;

public class CastFunctions {
    private static Map<TypeProtos.MinorType, String> TYPE2FUNC = new HashMap<TypeProtos.MinorType, String>();
    private static Set<String> CAST_FUNC_REPLACEMENT_NEEDED = new HashSet<String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY = new HashMap<String, String>();

    public static String getCastFunc(TypeProtos.MinorType targetMinorType) {
        String func = TYPE2FUNC.get(targetMinorType);
        if (func != null) {
            return func;
        }
        throw new IllegalArgumentException(String.format("cast function for type %s is not defined", targetMinorType.name()));
    }

    public static String getReplacingCastFunction(String originalCastFunction, TypeProtos.DataMode dataMode, TypeProtos.MinorType inputType) {
        if (dataMode == TypeProtos.DataMode.OPTIONAL) {
            return CastFunctions.getReplacingCastFunctionFromNullable(originalCastFunction, inputType);
        }
        if (dataMode == TypeProtos.DataMode.REQUIRED) {
            return CastFunctions.getReplacingCastFunctionFromNonNullable(originalCastFunction, inputType);
        }
        throw new RuntimeException(String.format("replacing cast function for datatype %s is not defined", dataMode));
    }

    public static boolean isReplacementNeeded(String originalfunction, TypeProtos.MinorType inputType) {
        return (inputType == TypeProtos.MinorType.VARCHAR || inputType == TypeProtos.MinorType.VARBINARY || inputType == TypeProtos.MinorType.VAR16CHAR) && CAST_FUNC_REPLACEMENT_NEEDED.contains(originalfunction);
    }

    public static boolean isCastFunction(String funcName) {
        return TYPE2FUNC.values().contains(funcName);
    }

    private static String getReplacingCastFunctionFromNonNullable(String originalCastFunction, TypeProtos.MinorType inputType) {
        if (inputType == TypeProtos.MinorType.VARCHAR && CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.get(originalCastFunction);
        }
        if (inputType == TypeProtos.MinorType.VAR16CHAR && CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.get(originalCastFunction);
        }
        if (inputType == TypeProtos.MinorType.VARBINARY && CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.get(originalCastFunction);
        }
        throw new RuntimeException(String.format("replacing cast function for %s is not defined", originalCastFunction));
    }

    private static String getReplacingCastFunctionFromNullable(String originalCastFunction, TypeProtos.MinorType inputType) {
        if (inputType == TypeProtos.MinorType.VARCHAR && CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.get(originalCastFunction);
        }
        if (inputType == TypeProtos.MinorType.VAR16CHAR && CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.get(originalCastFunction);
        }
        if (inputType == TypeProtos.MinorType.VARBINARY && CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.get(originalCastFunction);
        }
        throw new RuntimeException(String.format("replacing cast function for %s is not defined", originalCastFunction));
    }

    static {
        TYPE2FUNC.put(TypeProtos.MinorType.UNION, "castUNION");
        TYPE2FUNC.put(TypeProtos.MinorType.BIGINT, "castBIGINT");
        TYPE2FUNC.put(TypeProtos.MinorType.INT, "castINT");
        TYPE2FUNC.put(TypeProtos.MinorType.BIT, "castBIT");
        TYPE2FUNC.put(TypeProtos.MinorType.TINYINT, "castTINYINT");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT4, "castFLOAT4");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT8, "castFLOAT8");
        TYPE2FUNC.put(TypeProtos.MinorType.VARCHAR, "castVARCHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VAR16CHAR, "castVAR16CHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VARBINARY, "castVARBINARY");
        TYPE2FUNC.put(TypeProtos.MinorType.DATE, "castDATE");
        TYPE2FUNC.put(TypeProtos.MinorType.TIME, "castTIME");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMP, "castTIMESTAMP");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMPTZ, "castTIMESTAMPTZ");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALDAY, "castINTERVALDAY");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALYEAR, "castINTERVALYEAR");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVAL, "castINTERVAL");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL9, "castDECIMAL9");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL18, "castDECIMAL18");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28SPARSE, "castDECIMAL28SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28DENSE, "castDECIMAL28DENSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38SPARSE, "castDECIMAL38SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38DENSE, "castDECIMAL38DENSE");
        TYPE2FUNC.put(TypeProtos.MinorType.VARDECIMAL, "castVARDECIMAL");
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.INT));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL));
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringVarCharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringVarCharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringVarCharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringVarCharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringVarCharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringVarCharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringVarCharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringVarCharToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringVarCharToNullableVARDECIMAL");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringVar16CharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringVar16CharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringVar16CharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringVar16CharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringVar16CharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringVar16CharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringVar16CharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringVar16CharToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringVar16CharToNullableVARDECIMAL");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringVarBinaryToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringVarBinaryToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringVarBinaryToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringVarBinaryToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringVarBinaryToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringVarBinaryToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringVarBinaryToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringVarBinaryToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringVarBinaryToNullableVARDECIMAL");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringNullableVarCharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringNullableVarCharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringNullableVarCharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringNullableVarCharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringNullableVarCharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringNullableVarCharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringNullableVarCharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringNullableVarCharToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringNullableVarCharToNullableVARDECIMAL");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringNullableVar16CharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringNullableVar16CharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringNullableVar16CharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringNullableVar16CharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringNullableVar16CharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringNullableVar16CharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringNullableVar16CharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringNullableVar16CharToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringNullableVar16CharToNullableVARDECIMAL");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringNullableVarBinaryToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringNullableVarBinaryToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringNullableVarBinaryToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringNullableVarBinaryToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringNullableVarBinaryToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringNullableVarBinaryToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringNullableVarBinaryToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringNullableVarBinaryToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(TYPE2FUNC.get(TypeProtos.MinorType.VARDECIMAL), "castEmptyStringNullableVarBinaryToNullableVARDECIMAL");
    }
}

