/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.ChannelClosedException;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.DrillRpcFutureImpl;
import org.apache.drill.exec.rpc.InboundRpcMessage;
import org.apache.drill.exec.rpc.OutboundRpcMessage;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.UserRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBus<T extends Internal.EnumLite, C extends RemoteConnection>
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final OutboundRpcMessage PONG = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PONG, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    protected final RpcConfig rpcConfig;
    protected volatile SocketAddress local;
    protected volatile SocketAddress remote;

    protected abstract MessageLite getResponseDefaultInstance(int var1) throws RpcException;

    protected abstract void handle(C var1, int var2, ByteBuf var3, ByteBuf var4, ResponseSender var5) throws RpcException;

    public RpcBus(RpcConfig rpcConfig) {
        this.rpcConfig = rpcConfig;
    }

    protected void setAddresses(SocketAddress remote, SocketAddress local) {
        this.remote = remote;
        this.local = local;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        DrillRpcFutureImpl rpcFuture = new DrillRpcFutureImpl();
        this.send(rpcFuture, connection, rpcType, protobufBody, clazz, dataBodies);
        return rpcFuture;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.send(listener, connection, rpcType, protobufBody, clazz, false, dataBodies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        block11: {
            Preconditions.checkArgument((allowInEventLoop || !connection.inEventLoop() ? 1 : 0) != 0, (Object)"You attempted to send while inside the rpc event thread.  This isn't allowed because sending will block if the channel is backed up.");
            Object pBuffer = null;
            boolean completed = false;
            try {
                if (!allowInEventLoop && !connection.blockOnNotWritable(listener)) {
                    return;
                }
                assert (!Arrays.asList(dataBodies).contains(null));
                assert (this.rpcConfig.checkSend((Internal.EnumLite)rpcType, protobufBody.getClass(), clazz));
                Preconditions.checkNotNull(protobufBody);
                ByteBuf[] futureListener = connection.createNewRpcListener(listener, clazz);
                OutboundRpcMessage m = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.REQUEST, (Internal.EnumLite)rpcType, futureListener.getCoordinationId(), (MessageLite)protobufBody, dataBodies);
                ChannelFuture channelFuture = connection.getChannel().writeAndFlush((Object)m);
                channelFuture.addListener((GenericFutureListener)futureListener);
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                completed = true;
            }
            catch (AssertionError | Exception e) {
                listener.failed(new RpcException("Failure sending message.", (Throwable)e));
            }
            finally {
                if (completed) break block11;
                if (pBuffer != null) {
                    pBuffer.release();
                }
                if (dataBodies == null) break block11;
                for (ByteBuf b : dataBodies) {
                    b.release();
                }
            }
        }
    }

    protected abstract C initRemoteConnection(SocketChannel var1);

    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel channel, C clientConnection) {
        return new ChannelClosedHandler(this, clientConnection, (Channel)channel);
    }

    private static void retainByteBuf(ByteBuf buf) {
        if (buf != null) {
            buf.retain();
        }
    }

    private static void releaseByteBuf(ByteBuf buf) {
        if (buf != null) {
            buf.release();
        }
    }

    public static <T> T get(ByteBuf pBody, Parser<T> parser) throws RpcException {
        try {
            ByteBufInputStream is = new ByteBufInputStream(pBody);
            return (T)parser.parseFrom((InputStream)is);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    protected static class InboundHandler
    extends MessageToMessageDecoder<InboundRpcMessage> {
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public InboundHandler(C connection) {
            this.this$0 = this$0;
            Preconditions.checkNotNull(connection);
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> output) throws Exception {
            if (!ctx.channel().isOpen()) {
                return;
            }
            Channel channel = this.connection.getChannel();
            Stopwatch watch = Stopwatch.createStarted();
            try {
                switch (msg.mode) {
                    case REQUEST: {
                        ResponseSenderImpl sender = this.this$0.new ResponseSenderImpl((RemoteConnection)this.connection, msg.coordinationId);
                        RpcBus.retainByteBuf(msg.pBody);
                        RpcBus.retainByteBuf(msg.dBody);
                        try {
                            this.this$0.handle(this.connection, msg.rpcType, msg.pBody, msg.dBody, sender);
                            break;
                        }
                        catch (UserRpcException e) {
                            sender.sendFailure(e);
                            break;
                        }
                        finally {
                            RpcBus.releaseByteBuf(msg.pBody);
                            RpcBus.releaseByteBuf(msg.dBody);
                        }
                    }
                    case RESPONSE: {
                        RpcBus.retainByteBuf(msg.pBody);
                        RpcBus.retainByteBuf(msg.dBody);
                        try {
                            MessageLite defaultResponse = this.this$0.getResponseDefaultInstance(msg.rpcType);
                            assert (this.this$0.rpcConfig.checkReceive(msg.rpcType, defaultResponse.getClass()));
                            RpcOutcome<?> rpcFuture = this.connection.getAndRemoveRpcOutcome(msg.rpcType, msg.coordinationId, defaultResponse.getClass());
                            Parser parser = defaultResponse.getParserForType();
                            Object value = parser.parseFrom((InputStream)new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                            rpcFuture.set(value, msg.dBody);
                            break;
                        }
                        catch (Exception ex) {
                            this.this$0.logger.error("Failure while handling response.", (Throwable)ex);
                            throw ex;
                        }
                        finally {
                            RpcBus.releaseByteBuf(msg.pBody);
                            RpcBus.releaseByteBuf(msg.dBody);
                        }
                    }
                    case RESPONSE_FAILURE: {
                        UserBitShared.DrillPBError failure = UserBitShared.DrillPBError.parseFrom((InputStream)new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                        this.connection.recordRemoteFailure(msg.coordinationId, failure);
                        break;
                    }
                    case PING: {
                        channel.writeAndFlush((Object)PONG);
                        break;
                    }
                    case PONG: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (Throwable throwable) {
                long time = watch.elapsed(TimeUnit.MILLISECONDS);
                long delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
                if (time > delayThreshold) {
                    this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, delayThreshold, time));
                }
                msg.release();
                throw throwable;
            }
            long time = watch.elapsed(TimeUnit.MILLISECONDS);
            long delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
            if (time > delayThreshold) {
                this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, delayThreshold, time));
            }
            msg.release();
        }
    }

    private class ResponseSenderImpl
    implements ResponseSender {
        private final RemoteConnection connection;
        private final int coordinationId;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        public ResponseSenderImpl(RemoteConnection connection, int coordinationId) {
            this.connection = connection;
            this.coordinationId = coordinationId;
        }

        @Override
        public void send(Response r) {
            assert (RpcBus.this.rpcConfig.checkResponseSend(r.rpcType, r.pBody.getClass()));
            this.sendOnce();
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, r.rpcType, this.coordinationId, r.pBody, r.dBodies);
            this.connection.getChannel().writeAndFlush((Object)outMessage);
        }

        private void sendOnce() {
            if (!this.sent.compareAndSet(false, true)) {
                throw new IllegalStateException("Attempted to utilize a sender multiple times.");
            }
        }

        void sendFailure(UserRpcException e) {
            this.sendOnce();
            UserException uex = UserException.systemError((Throwable)((Object)e)).addIdentity(e.getEndpoint()).build(RpcBus.this.logger);
            RpcBus.this.logger.error("Unexpected Error while handling request message", (Throwable)((Object)e));
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE_FAILURE, 0, this.coordinationId, (MessageLite)uex.getOrCreatePBError(false), new ByteBuf[0]);
            this.connection.getChannel().writeAndFlush((Object)outMessage);
        }
    }

    public static class ChannelClosedHandler
    implements GenericFutureListener<ChannelFuture> {
        final C clientConnection;
        private final Channel channel;
        final /* synthetic */ RpcBus this$0;

        public ChannelClosedHandler(C clientConnection, Channel channel) {
            this.this$0 = this$0;
            this.channel = channel;
            this.clientConnection = clientConnection;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            String msg = this.this$0.local != null ? String.format("Channel closed %s <--> %s.", this.this$0.local, this.this$0.remote) : String.format("Channel closed %s <--> %s.", future.channel().localAddress(), future.channel().remoteAddress());
            ChannelClosedException ex = future.cause() != null ? new ChannelClosedException(msg, future.cause()) : new ChannelClosedException(msg);
            this.clientConnection.channelClosed(ex);
        }
    }
}

