/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.impl.ConditionNode;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OperatorExpression;
import com.mapr.ojai.store.impl.PredicateManager;
import com.mapr.ojai.store.impl.RelationalOperator;
import java.util.ArrayList;
import java.util.List;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class NaryOperator
extends OperatorExpression {
    protected final boolean isPrefix;
    protected final Expression[] arg;
    protected final int skipVisitArgs;
    private static final Expression[] EMPTY_EXPRESSION_ARRAY = new Expression[0];
    private static final ImmutableMap<String, String> RELOP_INVERSE;
    private static final ImmutableMap<String, String> OJAI_DRILL_UDF;
    private static final ImmutableMap<String, String> NULL_OP_NAME;
    private static final int HASH_SHIFT = 5;

    public NaryOperator(String opName, boolean isPrefix, int skipVisitArgs, List<Expression> arg, ConditionNode originalNode) {
        super(opName, originalNode);
        assert (!ExpressionToCondition.QUERY_CONDITIONS.containsKey(opName) || this instanceof RelationalOperator) : "improper NaryOperator " + opName;
        this.isPrefix = isPrefix;
        this.arg = arg.toArray(EMPTY_EXPRESSION_ARRAY);
        this.skipVisitArgs = skipVisitArgs;
    }

    public NaryOperator(String opName, boolean isPrefix, List<Expression> arg, ConditionNode originalNode) {
        this(opName, isPrefix, 0, arg, originalNode);
    }

    public static boolean isLogicalOperator(String name) {
        return name.equals("and") || name.equals("or");
    }

    static String getInverseOperator(String name) {
        return (String)RELOP_INVERSE.get((Object)name);
    }

    @Override
    public void emitSql(StringBuilder sb, String tableAlias) {
        String infixStr;
        String udfName = (String)OJAI_DRILL_UDF.get((Object)this.opName);
        if (udfName != null) {
            infixStr = ",";
            sb.append(udfName);
        } else {
            LiteralExpression litExpr;
            if (this.opName.equals("equals")) {
                if (this.arg.length != 2) {
                    throw new IllegalStateException(this.opName + " requires exactly two arguments");
                }
                if (!(this.arg[1] instanceof LiteralExpression)) {
                    throw new IllegalArgumentException(this.opName + " argument isn't a literal");
                }
                LiteralExpression litExpr2 = (LiteralExpression)this.arg[1];
                sb.append('(');
                this.arg[0].emitSql(sb, tableAlias);
                sb.append(" = ");
                sb.append(litExpr2.getLiteral());
                sb.append(')');
                return;
            }
            if (this.opName.equals("nequals")) {
                if (this.arg.length != 2) {
                    throw new IllegalStateException(this.opName + " requires exactly two arguments");
                }
                if (!(this.arg[1] instanceof LiteralExpression)) {
                    throw new IllegalArgumentException(this.opName + " argument isn't a literal");
                }
                LiteralExpression litExpr3 = (LiteralExpression)this.arg[1];
                sb.append('(');
                this.arg[0].emitSql(sb, tableAlias);
                sb.append(" <> ");
                sb.append(litExpr3.getLiteral());
                sb.append(')');
                return;
            }
            String useName = this.opName;
            if (this.arg.length == 2 && this.arg[1] instanceof LiteralExpression && ((litExpr = (LiteralExpression)this.arg[1]).getType() == Value.Type.NULL || litExpr.getType() == Value.Type.BOOLEAN) && (this.opName.equals("=") || this.opName.equals("<>"))) {
                useName = (String)NULL_OP_NAME.get((Object)this.opName);
            }
            infixStr = " " + useName + " ";
        }
        sb.append('(');
        this.arg[0].emitSql(sb, tableAlias);
        for (int i = 1; i < this.arg.length; ++i) {
            sb.append(infixStr);
            this.arg[i].emitSql(sb, tableAlias);
        }
        sb.append(')');
    }

    @Override
    public boolean structuralEquals(Expression e) {
        if (!(e instanceof NaryOperator)) {
            return false;
        }
        NaryOperator other = (NaryOperator)e;
        if (!this.opName.equals(other.opName)) {
            return false;
        }
        if (this.arg.length != other.arg.length) {
            return false;
        }
        for (int i = 0; i < this.arg.length; ++i) {
            if (this.arg[i].structuralEquals(other.arg[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int structuralHashCode() {
        int hash = this.opName.hashCode();
        for (int i = 0; i < this.arg.length; ++i) {
            hash = hash << 5 | (Integer.MAX_VALUE & hash) >> 27;
            hash ^= this.arg[i].structuralHashCode();
        }
        return hash;
    }

    @Deprecated
    public QueryCondition toQueryCondition(OjaiConnection ojaiConnection) {
        QueryCondition newCond = ojaiConnection.newCondition();
        switch (this.opName) {
            case "matches": {
                newCond.matches(((FieldExpression)this.arg[0]).getFieldPath(), ((LiteralExpression)this.arg[1]).getString());
                break;
            }
            case "notMatches": {
                newCond.notMatches(((FieldExpression)this.arg[0]).getFieldPath(), ((LiteralExpression)this.arg[1]).getString());
                break;
            }
            case "like": {
                newCond.like(((FieldExpression)this.arg[0]).getFieldPath(), ((LiteralExpression)this.arg[1]).getString());
                break;
            }
            case "notLike": {
                newCond.notLike(((FieldExpression)this.arg[0]).getFieldPath(), ((LiteralExpression)this.arg[1]).getString());
                break;
            }
            default: {
                throw new IllegalStateException("NaryOperator.toQueryCondition opName = " + this.opName);
            }
        }
        return newCond;
    }

    @Override
    public void gatherExpressions(int depth, PredicateManager predicateManager) {
        int skipCount = -1;
        if (depth == 0) {
            if (NaryOperator.isLogicalOperator(this.opName) || this.opName.equals("elementAnd")) {
                for (Expression expr : this.arg) {
                    if (++skipCount < this.skipVisitArgs) continue;
                    if (expr instanceof NaryOperator) {
                        expr.gatherExpressions(0, predicateManager);
                        continue;
                    }
                    predicateManager.addOtherRelation(expr);
                }
                return;
            }
            for (Expression expr : this.arg) {
                if (++skipCount < this.skipVisitArgs || !(expr instanceof FieldExpression)) continue;
                predicateManager.addTopRelation(((FieldExpression)expr).getFieldPath(), this);
            }
        }
        predicateManager.addOtherRelation(this);
    }

    @Override
    public void visit(ExpressionVisitor ev) {
        ev.visitNary(this);
    }

    public NaryOperator recreateWithNewArgs(ArrayList<Expression> newArgs) {
        return new NaryOperator(this.opName, this.isPrefix, newArgs, this.originalNode);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RELOP_INVERSE = builder.put((Object)"=", (Object)"=").put((Object)"<>", (Object)"<>").put((Object)"<", (Object)">").put((Object)"<=", (Object)">=").put((Object)">", (Object)"<").put((Object)">=", (Object)"<=").build();
        builder = ImmutableMap.builder();
        OJAI_DRILL_UDF = builder.put((Object)"matches", (Object)"ojai_matches").put((Object)"notMatches", (Object)"ojai_notmatches").put((Object)"like", (Object)"ojai_like").put((Object)"notLike", (Object)"ojai_notlike").build();
        builder = ImmutableMap.builder();
        NULL_OP_NAME = builder.put((Object)"=", (Object)"is").put((Object)"<>", (Object)"is not").build();
    }
}

