/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.mapr.data.ProtoConstants;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.auth.Authentication;
import com.mapr.data.gateway.auth.Authenticator;
import com.mapr.data.gateway.auth.Authenticators;
import com.mapr.data.gateway.auth.Constant;
import com.mapr.data.gateway.auth.UserInfo;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.ojai.Document;
import org.ojai.store.exceptions.AuthenticationException;
import org.ojai.store.exceptions.ExpiredTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ServerAuthInterceptor.class);
    private static final ServerCall.Listener NULL_LISTENER = new ServerCall.Listener(){};
    private final boolean authRequired;

    public ServerAuthInterceptor(Document config) {
        this.authRequired = Configs.getBoolean(config, "grpc.service.auth.required", true);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> nextHandler) {
        if (this.authRequired) {
            try {
                final Authentication auth = this.authenticateCall(call, headers, nextHandler);
                Context ctxWithAuth = Context.current().withValue(Constant.AUTH_CTX_KEY, (Object)auth);
                Object nextCall = call;
                if (auth.getToken() != null) {
                    nextCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                        public void sendHeaders(Metadata responseHeaders) {
                            responseHeaders.put(ProtoConstants.RSP_HEADER_JWT_TOKEN, (Object)auth.getToken());
                            super.sendHeaders(responseHeaders);
                        }
                    };
                }
                return Contexts.interceptCall((Context)ctxWithAuth, nextCall, (Metadata)headers, nextHandler);
            }
            catch (ExpiredTokenException e) {
                log.debug(e.getMessage());
                call.close(Status.UNAUTHENTICATED.withDescription("STATUS_TOKEN_EXPIRED"), headers);
                return NULL_LISTENER;
            }
            catch (AuthenticationException e) {
                log.error("Authentication failed! " + e.getMessage());
                log.debug(e.getMessage(), (Throwable)e);
                call.close(Status.UNAUTHENTICATED.withDescription(e.getMessage()), headers);
                return NULL_LISTENER;
            }
        }
        return nextHandler.startCall(call, headers);
    }

    private <ReqT, RespT> Authentication authenticateCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) throws AuthenticationException {
        String authHeader = (String)metadata.get(ProtoConstants.REQ_HEADER_AUTH);
        if (authHeader == null) {
            throw new AuthenticationException("No authentication was provided by the client");
        }
        String[] authSchemeAndToken = authHeader.trim().split("\\s+", 2);
        if (authSchemeAndToken.length == 1) {
            throw new AuthenticationException("Required authentication token missing for scheme: " + authSchemeAndToken[0]);
        }
        Authenticator authenticator = Authenticators.getAuthenticator(authSchemeAndToken[0]);
        UserInfo auth = UserInfo.builder().token(authSchemeAndToken[1]).build();
        return authenticator.authenticate(auth);
    }
}

